/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import org.teatrove.tea.compiler.CodeGenerator;
import org.teatrove.tea.parsetree.AndExpression;
import org.teatrove.tea.parsetree.ArithmeticExpression;
import org.teatrove.tea.parsetree.ArrayLookup;
import org.teatrove.tea.parsetree.AssignmentStatement;
import org.teatrove.tea.parsetree.BinaryExpression;
import org.teatrove.tea.parsetree.Block;
import org.teatrove.tea.parsetree.BooleanLiteral;
import org.teatrove.tea.parsetree.BreakStatement;
import org.teatrove.tea.parsetree.CallExpression;
import org.teatrove.tea.parsetree.CompareExpression;
import org.teatrove.tea.parsetree.ConcatenateExpression;
import org.teatrove.tea.parsetree.ContinueStatement;
import org.teatrove.tea.parsetree.ExceptionGuardStatement;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.ExpressionList;
import org.teatrove.tea.parsetree.ExpressionStatement;
import org.teatrove.tea.parsetree.ForeachStatement;
import org.teatrove.tea.parsetree.FunctionCallExpression;
import org.teatrove.tea.parsetree.IfStatement;
import org.teatrove.tea.parsetree.ImportDirective;
import org.teatrove.tea.parsetree.Lookup;
import org.teatrove.tea.parsetree.Name;
import org.teatrove.tea.parsetree.NegateExpression;
import org.teatrove.tea.parsetree.NewArrayExpression;
import org.teatrove.tea.parsetree.NoOpExpression;
import org.teatrove.tea.parsetree.Node;
import org.teatrove.tea.parsetree.NodeVisitor;
import org.teatrove.tea.parsetree.NotExpression;
import org.teatrove.tea.parsetree.NullLiteral;
import org.teatrove.tea.parsetree.NumberLiteral;
import org.teatrove.tea.parsetree.OrExpression;
import org.teatrove.tea.parsetree.ParenExpression;
import org.teatrove.tea.parsetree.RelationalExpression;
import org.teatrove.tea.parsetree.ReturnStatement;
import org.teatrove.tea.parsetree.SpreadExpression;
import org.teatrove.tea.parsetree.Statement;
import org.teatrove.tea.parsetree.StatementList;
import org.teatrove.tea.parsetree.StringLiteral;
import org.teatrove.tea.parsetree.SubstitutionStatement;
import org.teatrove.tea.parsetree.Template;
import org.teatrove.tea.parsetree.TemplateCallExpression;
import org.teatrove.tea.parsetree.TernaryExpression;
import org.teatrove.tea.parsetree.TypeExpression;
import org.teatrove.tea.parsetree.TypeName;
import org.teatrove.tea.parsetree.Variable;
import org.teatrove.tea.parsetree.VariableRef;

public class TreePrinter
extends CodeGenerator {
    private String mIndentStr;
    private boolean mExtraParens;

    public TreePrinter(Template tree) {
        this(tree, "    ", false);
    }

    public TreePrinter(Template tree, String indentStr) {
        this(tree, indentStr, false);
    }

    public TreePrinter(Template tree, boolean extraParens) {
        this(tree, "    ", extraParens);
    }

    public TreePrinter(Template tree, String indentStr, boolean extraParens) {
        super(tree);
        this.mIndentStr = indentStr;
        this.mExtraParens = extraParens;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out));
        Visitor v = new Visitor(w, this.mIndentStr, this.mExtraParens);
        try {
            this.getParseTree().accept(v);
        }
        catch (IOError e) {
            e.rethrow();
        }
        w.flush();
    }

    public static String toString(Node node) {
        return TreePrinter.toString(node, "    ");
    }

    public static String toString(Node node, String indentStr) {
        StringWriter sw = new StringWriter();
        BufferedWriter w = new BufferedWriter(sw);
        Visitor v = new Visitor(w, indentStr, false);
        node.accept(v);
        try {
            w.flush();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return sw.toString();
    }

    private static class Visitor
    implements NodeVisitor {
        private BufferedWriter mWriter;
        private String mIndentStr;
        private boolean mExtraParens;
        private int mIndent;
        private boolean mNeedIndent = true;

        public Visitor(BufferedWriter writer, String indentStr, boolean extraParens) {
            this.mWriter = writer;
            this.mIndentStr = indentStr;
            this.mExtraParens = extraParens;
        }

        public void indent(int amount) {
            this.mIndent += amount;
            if (this.mIndent < 0) {
                this.mIndent = 0;
            }
        }

        private void print(String str) throws IOError {
            this.doIndent();
            try {
                this.mWriter.write(str);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        private void println() throws IOError {
            this.mNeedIndent = true;
            try {
                this.mWriter.newLine();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        private void doIndent() throws IOError {
            if (this.mNeedIndent) {
                this.mNeedIndent = false;
                try {
                    for (int i = this.mIndent; i > 0; --i) {
                        this.mWriter.write(this.mIndentStr);
                    }
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        }

        @Override
        public Object visit(Template node) {
            Statement stmt;
            this.print("template ");
            this.print(node.getName().getName());
            Variable[] params = node.getParams();
            this.print(" (");
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    if (i > 0) {
                        this.print(", ");
                    }
                    params[i].accept(this);
                }
            }
            this.print(") ");
            if (node.hasSubstitutionParam()) {
                this.print("{...} ");
            }
            if ((stmt = node.getStatement()) != null) {
                stmt.accept(this);
            }
            return null;
        }

        @Override
        public Object visit(Name node) {
            this.print(node.getName());
            return null;
        }

        @Override
        public Object visit(TypeName node) {
            this.print(node.getName());
            int dim = node.getDimensions();
            for (int i = 0; i < dim; ++i) {
                this.print("[]");
            }
            return null;
        }

        @Override
        public Object visit(Variable node) {
            TypeName typeName = node.getTypeName();
            if (typeName != null) {
                typeName.accept(this);
                this.print(" ");
            }
            this.print(node.getName());
            return null;
        }

        @Override
        public Object visit(ExpressionList node) {
            Expression[] exprs = node.getExpressions();
            for (int i = 0; i < exprs.length; ++i) {
                if (i > 0) {
                    this.print(", ");
                }
                exprs[i].accept(this);
            }
            return null;
        }

        @Override
        public Object visit(Statement node) {
            return null;
        }

        @Override
        public Object visit(ImportDirective node) {
            return null;
        }

        @Override
        public Object visit(StatementList node) {
            Statement[] stmts = node.getStatements();
            if (stmts != null) {
                for (int i = 0; i < stmts.length; ++i) {
                    this.println();
                    stmts[i].accept(this);
                }
                this.println();
            }
            return null;
        }

        @Override
        public Object visit(Block node) {
            this.print("{ ");
            this.indent(1);
            this.visit((StatementList)node);
            this.indent(-1);
            this.print("} ");
            return null;
        }

        @Override
        public Object visit(AssignmentStatement node) {
            node.getLValue().accept(this);
            this.print(" = ");
            node.getRValue().accept(this);
            this.print(" ");
            return null;
        }

        @Override
        public Object visit(BreakStatement node) {
            this.print("break");
            return null;
        }

        @Override
        public Object visit(ContinueStatement node) {
            this.print("continue");
            return null;
        }

        @Override
        public Object visit(ForeachStatement node) {
            this.print("foreach (");
            node.getLoopVariable().accept(this);
            this.print(" in ");
            node.getRange().accept(this);
            if (node.getEndRange() != null) {
                this.print("..");
                node.getEndRange().accept(this);
            }
            this.print(") ");
            Block body = node.getBody();
            if (body != null) {
                ((Statement)body).accept(this);
            }
            return null;
        }

        @Override
        public Object visit(IfStatement node) {
            this.print("if ");
            node.getCondition().accept(this);
            Block stmt = node.getThenPart();
            if (stmt != null) {
                this.print(" ");
                ((Statement)stmt).accept(this);
            } else {
                this.print(" {");
                this.println();
                this.print("} ");
            }
            stmt = node.getElsePart();
            if (stmt != null) {
                this.println();
                this.print("else ");
                ((Statement)stmt).accept(this);
            }
            return null;
        }

        @Override
        public Object visit(SubstitutionStatement node) {
            this.print("...");
            return null;
        }

        @Override
        public Object visit(ExpressionStatement node) {
            node.getExpression().accept(this);
            return null;
        }

        @Override
        public Object visit(ReturnStatement node) {
            Expression expr = node.getExpression();
            if (expr != null) {
                this.print("/* return */ ");
                expr.accept(this);
            } else {
                this.print("/* return void */ ");
            }
            return null;
        }

        @Override
        public Object visit(ExceptionGuardStatement node) {
            this.print("/* try { */");
            if (node.getGuarded() != null) {
                this.indent(1);
                node.getGuarded().accept(this);
                this.indent(-1);
            }
            this.print("/* } catch (java.lang.Exception e) { */");
            if (node.getReplacement() != null) {
                this.indent(1);
                node.getReplacement().accept(this);
                this.indent(-1);
            }
            this.print("/* } */");
            return null;
        }

        @Override
        public Object visit(Expression node) {
            this.print(String.valueOf(node));
            return null;
        }

        @Override
        public Object visit(ParenExpression node) {
            this.print("(");
            node.getExpression().accept(this);
            this.print(")");
            return null;
        }

        @Override
        public Object visit(NewArrayExpression node) {
            if (node.isAssociative()) {
                this.print("##(");
            } else {
                this.print("#(");
            }
            node.getExpressionList().accept(this);
            this.print(")");
            return null;
        }

        @Override
        public Object visit(FunctionCallExpression node) {
            return this.visit((CallExpression)node);
        }

        @Override
        public Object visit(TemplateCallExpression node) {
            this.print("call ");
            return this.visit((CallExpression)node);
        }

        private Object visit(CallExpression node) {
            node.getTarget().accept(this);
            this.print("(");
            node.getParams().accept(this);
            this.print(")");
            Block subParam = node.getSubstitutionParam();
            if (subParam != null) {
                this.print(" ");
                ((Statement)subParam).accept(this);
            }
            return null;
        }

        @Override
        public Object visit(VariableRef node) {
            this.print(node.getName());
            return null;
        }

        @Override
        public Object visit(Lookup node) {
            if (this.mExtraParens) {
                this.print("(");
                node.getExpression().accept(this);
                this.print(")");
            } else {
                node.getExpression().accept(this);
            }
            if (node.isNullSafe()) {
                this.print("?");
            }
            this.print(".");
            this.print(node.getLookupName().getName());
            return null;
        }

        @Override
        public Object visit(ArrayLookup node) {
            if (this.mExtraParens) {
                this.print("(");
                node.getExpression().accept(this);
                this.print(")");
            } else {
                node.getExpression().accept(this);
            }
            if (node.isNullSafe()) {
                this.print("?");
            }
            this.print("[");
            node.getLookupIndex().accept(this);
            this.print("]");
            return null;
        }

        @Override
        public Object visit(NegateExpression node) {
            if (this.mExtraParens) {
                this.print("-(");
                node.getExpression().accept(this);
                this.print(")");
            } else {
                this.print("-");
                node.getExpression().accept(this);
            }
            return null;
        }

        @Override
        public Object visit(NotExpression node) {
            if (this.mExtraParens) {
                this.print("not (");
                node.getExpression().accept(this);
                this.print(")");
            } else {
                this.print("not ");
                node.getExpression().accept(this);
            }
            return null;
        }

        public Object visit(BinaryExpression node) {
            if (this.mExtraParens) {
                this.print("(");
            }
            node.getLeftExpression().accept(this);
            this.print(" ");
            this.print(node.getOperator().getImage());
            this.print(" ");
            node.getRightExpression().accept(this);
            if (this.mExtraParens) {
                this.print(")");
            }
            return null;
        }

        @Override
        public Object visit(ConcatenateExpression node) {
            return this.visit((BinaryExpression)node);
        }

        @Override
        public Object visit(ArithmeticExpression node) {
            return this.visit((BinaryExpression)node);
        }

        @Override
        public Object visit(RelationalExpression node) {
            if (node.getOperator().getID() != 49) {
                return this.visit((BinaryExpression)node);
            }
            if (this.mExtraParens) {
                this.print("(");
            }
            node.getLeftExpression().accept(this);
            this.print(" ");
            this.print(node.getOperator().getImage());
            this.print(" ");
            node.getIsaTypeName().accept(this);
            if (this.mExtraParens) {
                this.print(")");
            }
            return null;
        }

        @Override
        public Object visit(AndExpression node) {
            return this.visit((BinaryExpression)node);
        }

        @Override
        public Object visit(OrExpression node) {
            return this.visit((BinaryExpression)node);
        }

        @Override
        public Object visit(TernaryExpression node) {
            Expression condition = node.getCondition();
            Expression thenPart = node.getCondition();
            Expression elsePart = node.getCondition();
            condition.accept(this);
            this.print(" ? ");
            thenPart.accept(this);
            this.print(" : ");
            elsePart.accept(this);
            return null;
        }

        @Override
        public Object visit(CompareExpression node) {
            node.getLeftExpression().accept(this);
            this.print(" <=> ");
            node.getRightExpression().accept(this);
            return null;
        }

        @Override
        public Object visit(NoOpExpression node) {
            return null;
        }

        @Override
        public Object visit(TypeExpression node) {
            node.getTypeName().accept(this);
            return null;
        }

        @Override
        public Object visit(SpreadExpression node) {
            node.getExpression().accept(this);
            this.print("*.");
            node.getOperation().accept(this);
            return null;
        }

        @Override
        public Object visit(NullLiteral node) {
            this.print(String.valueOf(node.getValue()));
            return null;
        }

        @Override
        public Object visit(BooleanLiteral node) {
            this.print(String.valueOf(node.getValue()));
            return null;
        }

        @Override
        public Object visit(StringLiteral node) {
            String str = node.getValue().toString();
            int length = str.length();
            StringBuffer buf = new StringBuffer(length);
            block10: for (int i = 0; i < length; ++i) {
                char c = str.charAt(i);
                if (c > '\"' && c < '\u0080') {
                    buf.append(c);
                    continue;
                }
                switch (c) {
                    case ' ': 
                    case '!': {
                        buf.append(c);
                        continue block10;
                    }
                    case '\"': {
                        buf.append("\\\"");
                        continue block10;
                    }
                    case '\u0000': {
                        buf.append("\\0");
                        continue block10;
                    }
                    case '\b': {
                        buf.append("\\b");
                        continue block10;
                    }
                    case '\t': {
                        buf.append("\\t");
                        continue block10;
                    }
                    case '\n': {
                        buf.append("\\n");
                        continue block10;
                    }
                    case '\f': {
                        buf.append("\\f");
                        continue block10;
                    }
                    case '\r': {
                        buf.append("\\r");
                        continue block10;
                    }
                    default: {
                        buf.append("\\u");
                        String hex = "0000" + Integer.toHexString(c);
                        buf.append(hex.substring(hex.length() - 4));
                    }
                }
            }
            this.print("\"");
            this.print(buf.toString());
            this.print("\"");
            return null;
        }

        @Override
        public Object visit(NumberLiteral node) {
            Number value = (Number)node.getValue();
            this.print(value.toString());
            if (value instanceof Long) {
                this.print("L");
            } else if (value instanceof Float) {
                this.print("f");
            } else if (value instanceof Double) {
                this.print("d");
            }
            return null;
        }
    }

    private static class IOError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private IOException mException;

        public IOError(IOException e) {
            this.mException = e;
        }

        public void rethrow() throws IOException {
            throw this.mException;
        }
    }
}

