/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teatrove.tea.TypedElement;
import org.teatrove.tea.util.BeanAnalyzer;
import org.teatrove.tea.util.KeyedPropertyDescriptor;
import org.teatrove.trove.generics.GenericType;

public class Type
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Type NULL_TYPE = new Type((Class)Object.class){
        private static final long serialVersionUID = 1L;

        @Override
        public String getSimpleName() {
            return this.toString();
        }

        @Override
        public String getFullName() {
            return this.toString();
        }

        @Override
        public String toString() {
            return "null-type";
        }
    };
    public static final Type VOID_TYPE = new Type(Void.TYPE);
    public static final Type OBJECT_TYPE = new Type(Object.class);
    public static final Type INT_TYPE = new Type(Integer.TYPE);
    public static final Type LONG_TYPE = new Type(Long.TYPE);
    public static final Type BOOLEAN_TYPE = new Type(Boolean.TYPE);
    public static final Type STRING_TYPE = new Type(String.class);
    public static final Type NON_NULL_STRING_TYPE = STRING_TYPE.toNonNull();
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private final String mClassName;
    private final Class<?> mObjectClass;
    private final Class<?> mNaturalClass;
    private final GenericType mGenericType;
    private final boolean mPrimitive;
    private transient boolean mCheckedForArrayLookup;
    private transient Type mArrayElementType;
    private transient Type[] mArrayIndexTypes;
    private transient Method[] mArrayAccessMethods;
    private transient boolean mCheckedForIteration;
    private transient Type mIterationElementType;
    private transient boolean mCheckedForKey;
    private transient Type mKeyElementType;
    private transient boolean mCheckedForValue;
    private transient Type mValueElementType;
    private static byte[][] mCostTable = new byte[][]{{1, -1, -1, -1, -1, -1, -1, -1, 4, -1, -1, -1, -1, -1, -1, -1, -1, 37, 40}, {-1, 1, -1, -1, -1, -1, -1, -1, -1, 4, -1, -1, -1, -1, -1, -1, -1, 37, 40}, {-1, -1, 1, 5, 5, 7, 6, 8, -1, -1, 4, 11, 11, 11, 11, 11, 10, 37, 40}, {-1, -1, 33, 1, 5, 7, 6, 8, -1, -1, 35, 4, 11, 11, 11, 11, 10, 37, 40}, {-1, -1, 33, 29, 1, 21, 6, 8, -1, -1, 35, 31, 4, 23, 11, 11, 10, 37, 40}, {-1, -1, 33, 29, 25, 1, 17, 8, -1, -1, 35, 31, 27, 4, 19, 11, 10, 37, 40}, {-1, -1, 33, 29, 25, 21, 1, 13, -1, -1, 35, 31, 27, 23, 4, 15, 10, 37, 40}, {-1, -1, 33, 29, 25, 21, 17, 1, -1, -1, 35, 31, 27, 23, 19, 4, 10, 37, 40}, {3, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, 2, 40}, {-1, 3, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, 2, 40}, {-1, -1, 3, 9, 9, 9, 9, 9, -1, -1, 1, 12, 12, 12, 12, 12, 2, 2, 40}, {-1, -1, 34, 3, 9, 9, 9, 9, -1, -1, 36, 1, 12, 12, 12, 12, 2, 2, 40}, {-1, -1, 34, 30, 3, 22, 9, 9, -1, -1, 36, 32, 1, 24, 12, 12, 2, 2, 40}, {-1, -1, 34, 30, 26, 3, 18, 9, -1, -1, 36, 32, 28, 1, 20, 12, 2, 2, 40}, {-1, -1, 34, 30, 26, 22, 3, 14, -1, -1, 36, 32, 28, 24, 1, 16, 2, 2, 40}, {-1, -1, 34, 30, 26, 22, 18, 3, -1, -1, 36, 32, 28, 24, 20, 1, 2, 2, 40}, {-1, -1, 34, 30, 26, 22, 18, 14, -1, -1, 36, 32, 28, 24, 20, 16, 1, 2, 40}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 40}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2, 1}, {66, 82, 73, 65, 78, 32, 83, 32, 79, 39, 78, 69, 73, 76, 76, -1, -1, -1, -1}};

    public Type(Class<?> type) {
        this(type, (java.lang.reflect.Type)null);
    }

    public Type(Class<?> type, java.lang.reflect.Type generic) {
        this.mNaturalClass = type;
        this.mClassName = type.getName();
        this.mPrimitive = type.isPrimitive();
        this.mGenericType = new GenericType(this.mNaturalClass, generic);
        this.mObjectClass = this.mPrimitive ? Type.convertToObject(type) : type;
    }

    public Type(GenericType type) {
        Class<?> natural = type.getRawType().getType();
        this.mGenericType = type;
        this.mNaturalClass = natural;
        this.mClassName = natural.getName();
        this.mPrimitive = natural.isPrimitive();
        this.mObjectClass = this.mPrimitive ? Type.convertToObject(natural) : natural;
    }

    private Type(Class<?> object, Class<?> natural) {
        this(object, natural, (java.lang.reflect.Type)null);
    }

    private Type(Class<?> object, Class<?> natural, java.lang.reflect.Type generic) {
        this.mObjectClass = object;
        this.mNaturalClass = natural;
        this.mClassName = natural.getName();
        this.mPrimitive = natural.isPrimitive();
        this.mGenericType = new GenericType(this.mNaturalClass, generic);
    }

    private Type(GenericType type, Class<?> natural) {
        this.mGenericType = type;
        this.mNaturalClass = natural;
        this.mClassName = natural.getName();
        this.mPrimitive = natural.isPrimitive();
        this.mObjectClass = type.getRawType().getType();
    }

    public Type(Class<?> type, TypedElement te) {
        this(type);
        this.mIterationElementType = new Type(te.value());
    }

    public Type(Class<?> type, java.lang.reflect.Type generic, TypedElement te) {
        this(type, generic);
        this.mIterationElementType = new Type(te.value());
    }

    public Type(GenericType type, TypedElement te) {
        this(type);
        this.mIterationElementType = new Type(te.value());
    }

    Type(Type type) {
        this.mClassName = type.mClassName;
        this.mGenericType = type.mGenericType;
        this.mObjectClass = type.mObjectClass;
        this.mNaturalClass = type.mNaturalClass;
        this.mPrimitive = type.mPrimitive;
        this.mCheckedForArrayLookup = type.mCheckedForArrayLookup;
        this.mArrayElementType = type.mArrayElementType;
        this.mArrayIndexTypes = type.mArrayIndexTypes;
        this.mArrayAccessMethods = type.mArrayAccessMethods;
        this.mCheckedForIteration = type.mCheckedForIteration;
        this.mIterationElementType = type.mIterationElementType;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public Class<?> getObjectClass() {
        return this.mObjectClass;
    }

    public GenericType getGenericType() {
        return this.mGenericType;
    }

    public java.lang.reflect.Type getGenericClass() {
        return this.mGenericType.getGenericType();
    }

    public Class<?> getNaturalClass() {
        return this.mNaturalClass;
    }

    public boolean isVoid() {
        Class<?> natural = this.getNaturalClass();
        return Void.class.equals(natural) || Void.TYPE.equals(natural);
    }

    public boolean isPrimitive() {
        return this.mPrimitive;
    }

    public boolean hasPrimitivePeer() {
        return this.mObjectClass == Integer.class || this.mObjectClass == Boolean.class || this.mObjectClass == Byte.class || this.mObjectClass == Character.class || this.mObjectClass == Short.class || this.mObjectClass == Long.class || this.mObjectClass == Float.class || this.mObjectClass == Double.class || this.mObjectClass == Void.class;
    }

    public Type toPrimitive() {
        if (this.mPrimitive) {
            return this;
        }
        Class<?> primitive = Type.convertToPrimitive(this.mObjectClass);
        if (primitive.isPrimitive()) {
            return new Type(primitive);
        }
        return new Type(this.mGenericType, primitive);
    }

    public Type toNonPrimitive() {
        if (this.mPrimitive) {
            return new Type(this.mObjectClass).toNonNull();
        }
        return this;
    }

    public boolean isNonNull() {
        return this.isPrimitive();
    }

    public boolean isNullable() {
        return !this.isNonNull();
    }

    public Type toNonNull() {
        if (this.isNonNull()) {
            return this;
        }
        return new Type(this){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isNonNull() {
                return true;
            }

            @Override
            public boolean isNullable() {
                return false;
            }

            @Override
            public Type toNullable() {
                return Type.this;
            }
        };
    }

    public Type toNullable() {
        if (!this.isNonNull()) {
            return this;
        }
        if (this.isPrimitive()) {
            return new Type(this.mObjectClass);
        }
        return new Type(this.mGenericType);
    }

    public Type getArrayElementType() throws IntrospectionException {
        if (!this.mCheckedForArrayLookup) {
            this.checkForArrayLookup();
        }
        return this.mArrayElementType;
    }

    public Type[] getArrayIndexTypes() throws IntrospectionException {
        if (!this.mCheckedForArrayLookup) {
            this.checkForArrayLookup();
        }
        return this.mArrayIndexTypes == null ? null : (Type[])this.mArrayIndexTypes.clone();
    }

    public Method[] getArrayAccessMethods() throws IntrospectionException {
        if (!this.mCheckedForArrayLookup) {
            this.checkForArrayLookup();
        }
        return this.mArrayAccessMethods == null ? null : (Method[])this.mArrayAccessMethods.clone();
    }

    public Type getIterationElementType() throws IntrospectionException {
        if (!this.mCheckedForIteration) {
            this.mCheckedForIteration = true;
            if (this.mIterationElementType != null) {
                return this.mIterationElementType;
            }
            if (this.mNaturalClass.isArray()) {
                this.mIterationElementType = this.getArrayElementType();
            } else if (Collection.class.isAssignableFrom(this.mNaturalClass) || Map.class.isAssignableFrom(this.mNaturalClass)) {
                this.mIterationElementType = Type.getIterationType(this.mGenericType);
                if (this.mIterationElementType == null || this.mIterationElementType == OBJECT_TYPE) {
                    try {
                        Field field = this.mNaturalClass.getField("ELEMENT_TYPE");
                        if (field.getType() == Class.class && Modifier.isStatic(field.getModifiers())) {
                            this.mIterationElementType = new Type((Class)field.get(null));
                        }
                    }
                    catch (NoSuchFieldException e) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
            if (this.mIterationElementType == null) {
                this.mIterationElementType = OBJECT_TYPE;
            }
        }
        return this.mIterationElementType;
    }

    public Type getKeyElementType() throws IntrospectionException {
        if (!this.mCheckedForKey) {
            this.mCheckedForKey = true;
            if (this.mKeyElementType == null) {
                return this.mKeyElementType;
            }
            if (Map.class.isAssignableFrom(this.mNaturalClass)) {
                this.mKeyElementType = Type.getKeyType(this.mGenericType);
            }
            if (this.mKeyElementType == null) {
                this.mKeyElementType = OBJECT_TYPE;
            }
        }
        return this.mKeyElementType;
    }

    public Type getValueElementType() throws IntrospectionException {
        if (!this.mCheckedForValue) {
            this.mCheckedForValue = true;
            if (this.mValueElementType == null) {
                return this.mValueElementType;
            }
            if (Map.class.isAssignableFrom(this.mNaturalClass)) {
                this.mValueElementType = Type.getValueType(this.mGenericType);
            }
            if (this.mValueElementType == null) {
                this.mValueElementType = OBJECT_TYPE;
            }
        }
        return this.mValueElementType;
    }

    public boolean isReverseIterationSupported() {
        return this.mNaturalClass.isArray() || List.class.isAssignableFrom(this.mNaturalClass) || Set.class.isAssignableFrom(this.mNaturalClass) || Map.class.isAssignableFrom(this.mNaturalClass);
    }

    private void checkForArrayLookup() throws IntrospectionException {
        this.mCheckedForArrayLookup = true;
        if (this.mGenericType.isArray()) {
            this.mArrayElementType = new Type(this.mGenericType.getComponentType());
            this.mArrayAccessMethods = EMPTY_METHOD_ARRAY;
            this.mArrayIndexTypes = new Type[]{INT_TYPE};
            return;
        }
        try {
            Map<String, PropertyDescriptor> properties = BeanAnalyzer.getAllProperties(this.mGenericType);
            KeyedPropertyDescriptor keyed = (KeyedPropertyDescriptor)properties.get("[]");
            if (keyed == null) {
                return;
            }
            this.mArrayElementType = new Type(keyed.getKeyedPropertyType().getRawType());
            this.mArrayAccessMethods = keyed.getKeyedReadMethods();
        }
        catch (ClassCastException e) {
            return;
        }
        int length = this.mArrayAccessMethods.length;
        this.mArrayIndexTypes = new Type[length];
        for (int i = 0; i < length; ++i) {
            Method m = this.mArrayAccessMethods[i];
            this.mArrayIndexTypes[i] = new Type(m.getReturnType(), m.getGenericReturnType());
        }
    }

    public Type setArrayElementType(Type elementType) throws IntrospectionException {
        Type type = new Type(this.mGenericType, this.mNaturalClass);
        type.checkForArrayLookup();
        type.mArrayElementType = elementType;
        return type;
    }

    public String getSimpleName() {
        if (this.mNaturalClass.isArray()) {
            int dim = 0;
            Class<?> baseNat = this.mNaturalClass;
            Type baseType = this;
            while (baseNat.isArray()) {
                ++dim;
                baseNat = baseNat.getComponentType();
                try {
                    baseType = baseType.getArrayElementType();
                }
                catch (IntrospectionException e) {
                    baseType = new Type(baseNat);
                }
            }
            String baseName = baseType.getSimpleName();
            StringBuffer nameBuf = new StringBuffer(baseName.length() + dim * 2);
            nameBuf.append(baseName);
            while (dim-- > 0) {
                nameBuf.append('[');
                nameBuf.append(']');
            }
            return nameBuf.toString();
        }
        if (this.mPrimitive) {
            return this.mNaturalClass.getName();
        }
        String name = this.mObjectClass.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public String getFullName() {
        if (this.isPrimitive()) {
            return this.mNaturalClass.getName();
        }
        StringBuffer nameBuf = new StringBuffer(20);
        if (this.isNonNull()) {
            nameBuf.append("non-null ");
        }
        if (!this.mNaturalClass.isArray()) {
            nameBuf.append(this.mObjectClass.getName());
        } else {
            int dim = 0;
            Class<?> baseNat = this.mNaturalClass;
            Type baseType = this;
            while (baseNat.isArray()) {
                ++dim;
                baseNat = baseNat.getComponentType();
                try {
                    baseType = baseType.getArrayElementType();
                }
                catch (IntrospectionException e) {
                    baseType = new Type(baseNat);
                }
            }
            String baseName = baseType.getFullName();
            nameBuf.append(baseName);
            while (dim-- > 0) {
                nameBuf.append('[');
                nameBuf.append(']');
            }
        }
        return nameBuf.toString();
    }

    public String toString() {
        if (!this.isPrimitive() && this.isNonNull()) {
            return "non-null " + this.mNaturalClass.getName();
        }
        return this.mNaturalClass.getName();
    }

    public int hashCode() {
        return this.mNaturalClass.hashCode();
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (another instanceof Type) {
            Type t = (Type)another;
            if (this == NULL_TYPE || another == NULL_TYPE) {
                return false;
            }
            if (this.mNaturalClass.equals(t.mNaturalClass) && this.mGenericType.equals((Object)t.mGenericType) && this.isNonNull() == t.isNonNull()) {
                if (!this.mCheckedForArrayLookup && !t.mCheckedForArrayLookup) {
                    return true;
                }
                try {
                    Type thisArrayType = this.getArrayElementType();
                    Type otherArrayType = t.getArrayElementType();
                    if (thisArrayType != null ? thisArrayType.equals(otherArrayType) : otherArrayType == null) {
                        return true;
                    }
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Type getCompatibleType(Type other) {
        Type compat;
        if (other == null) {
            return null;
        }
        if (this.equals(other)) {
            if (this != NULL_TYPE) return this;
            return other;
        }
        Class<?> classA = this.mObjectClass;
        Class<?> classB = other.mObjectClass;
        if (classA == Void.class) {
            if (classB != Void.class) return null;
            compat = this;
        } else {
            if (classB == Void.class) {
                return null;
            }
            if (other == NULL_TYPE) {
                compat = this.toNullable();
            } else if (this == NULL_TYPE) {
                compat = other.toNullable();
            } else if (Number.class.isAssignableFrom(classA) && Number.class.isAssignableFrom(classB)) {
                Class<?> clazz = Type.compatibleNumber(classA, classB);
                compat = this.isPrimitive() && other.isPrimitive() ? new Type(clazz, Type.convertToPrimitive(clazz)) : new Type(clazz);
            } else {
                compat = new Type(Type.findCommonBaseClass(classA, classB));
            }
        }
        if (!this.isNonNull()) return compat;
        if (!other.isNonNull()) return compat;
        return compat.toNonNull();
    }

    public static Type getIterationType(GenericType type) {
        return Type.getTypeArgument(type, 0);
    }

    public static Type getKeyType(GenericType type) {
        return Type.getTypeArgument(type, 0);
    }

    public static Type getValueType(GenericType type) {
        return Type.getTypeArgument(type, 1);
    }

    protected static Type getTypeArgument(GenericType type, int index) {
        GenericType arg = type.getTypeArgument(index);
        if (arg != null) {
            return new Type(arg);
        }
        return OBJECT_TYPE;
    }

    public static Type preserveType(Type currentType, Type newType) {
        Type result = newType;
        if (newType != null && currentType != null && currentType.getObjectClass() == newType.getObjectClass() && newType.getGenericType().getGenericType() instanceof Class && !(currentType.getGenericType().getGenericType() instanceof Class)) {
            if (newType.isNonNull() && !currentType.isNonNull()) {
                result = currentType.toNonNull();
            } else if (!newType.isNonNull() && currentType.isNonNull()) {
                result = currentType.toNullable();
            }
        }
        return result;
    }

    public static Class<?> findCommonBaseClass(Class<?> a, Class<?> b) {
        Class<?> clazz = Type.findCommonBaseClass0(a, b);
        if (clazz == null || !clazz.isInterface() || clazz.getMethods().length <= 0) {
            // empty if block
        }
        return clazz;
    }

    private static Class<?> findCommonBaseClass0(Class<?> a, Class<?> b) {
        if (a == b) {
            return a;
        }
        if (a.isPrimitive() || b.isPrimitive()) {
            return null;
        }
        if (a.isArray() && b.isArray()) {
            Class<?> clazz = Type.findCommonBaseClass(a.getComponentType(), b.getComponentType());
            if (clazz == null) {
                return Object.class;
            }
            return Array.newInstance(clazz, 0).getClass();
        }
        HashSet set = new HashSet(19);
        Type.addToClassSet(set, a);
        HashSet setB = new HashSet(19);
        Type.addToClassSet(setB, b);
        set.retainAll(setB);
        int size = set.size();
        if (size == 1) {
            return (Class)set.iterator().next();
        }
        if (size == 0) {
            return Object.class;
        }
        Iterator i = set.iterator();
        block0: while (i.hasNext()) {
            Class x = (Class)i.next();
            for (Class clazz : set) {
                if (x == clazz || !x.isAssignableFrom(clazz)) continue;
                i.remove();
                continue block0;
            }
        }
        size = set.size();
        if (size == 1) {
            return (Class)set.iterator().next();
        }
        if (size == 0) {
            return Object.class;
        }
        i = set.iterator();
        while (i.hasNext()) {
            if (!((Class)i.next()).isInterface()) continue;
            i.remove();
        }
        if (set.size() == 1) {
            return (Class)set.iterator().next();
        }
        return Object.class;
    }

    private static void addToClassSet(Set<Class<?>> set, Class<?> clazz) {
        if (clazz == null || !set.add(clazz)) {
            return;
        }
        Type.addToClassSet(set, clazz.getSuperclass());
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Type.addToClassSet(set, interfaces[i]);
        }
    }

    private static Class<?> compatibleNumber(Class<?> classA, Class<?> classB) {
        if (classA == Integer.class) {
            if (classB == Integer.class || classB == Byte.class || classB == Short.class) {
                return Integer.class;
            }
            if (classB == Long.class) {
                return classB;
            }
        } else if (classA == Byte.class || classA == Short.class) {
            if (classB == Integer.class || classB == Byte.class || classB == Short.class) {
                return Integer.class;
            }
            if (classB == Long.class) {
                return classB;
            }
            if (classB == Float.class) {
                return Float.class;
            }
        } else if (classA == Float.class) {
            if (classB == Float.class) {
                return classB;
            }
            if (classB == Byte.class || classB == Short.class) {
                return Float.class;
            }
        } else if (classA == Long.class && (classB == Integer.class || classB == Byte.class || classB == Short.class || classB == Long.class)) {
            return Long.class;
        }
        return Double.class;
    }

    private static Class<?> convertToObject(Class<?> type) {
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Void.TYPE) {
            return Void.class;
        }
        return type;
    }

    private static Class<?> convertToPrimitive(Class<?> type) {
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        if (type == Void.class) {
            return Void.TYPE;
        }
        return type;
    }

    public int convertableFrom(Type other) {
        int aCode;
        boolean arrayConversion;
        if (this.equals(other)) {
            return 1;
        }
        Class<?> thisNat = this.mNaturalClass;
        Class<?> otherNat = other.mNaturalClass;
        if (thisNat.isAssignableFrom(otherNat)) {
            return 2;
        }
        if (other == NULL_TYPE && !thisNat.isPrimitive()) {
            return 38;
        }
        boolean bl = arrayConversion = thisNat.isArray() && otherNat.isArray();
        if (arrayConversion) {
            int thisDim = 0;
            while (thisNat.isArray()) {
                ++thisDim;
                thisNat = thisNat.getComponentType();
            }
            int otherDim = 0;
            while (otherNat.isArray()) {
                ++otherDim;
                otherNat = otherNat.getComponentType();
            }
            if (thisDim != otherDim) {
                return -1;
            }
        }
        if ((aCode = Type.typeCode(thisNat)) < 0) {
            return -1;
        }
        int bCode = Type.typeCode(otherNat);
        if (bCode < 0) {
            if (aCode == 18) {
                return 40;
            }
            return -1;
        }
        int cost = mCostTable[bCode][aCode];
        if (cost == 40 && arrayConversion) {
            --cost;
        }
        return cost;
    }

    private static int typeCode(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return 0;
            }
            if (clazz == Character.TYPE) {
                return 1;
            }
            if (clazz == Byte.TYPE) {
                return 2;
            }
            if (clazz == Short.TYPE) {
                return 3;
            }
            if (clazz == Integer.TYPE) {
                return 4;
            }
            if (clazz == Float.TYPE) {
                return 5;
            }
            if (clazz == Long.TYPE) {
                return 6;
            }
            if (clazz == Double.TYPE) {
                return 7;
            }
        } else {
            if (clazz == Boolean.class) {
                return 8;
            }
            if (clazz == Character.class) {
                return 9;
            }
            if (clazz == Byte.class) {
                return 10;
            }
            if (clazz == Short.class) {
                return 11;
            }
            if (clazz == Integer.class) {
                return 12;
            }
            if (clazz == Float.class) {
                return 13;
            }
            if (clazz == Long.class) {
                return 14;
            }
            if (clazz == Double.class) {
                return 15;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return 16;
            }
            if (clazz == Object.class) {
                return 17;
            }
            if (clazz == String.class) {
                return 18;
            }
        }
        return -1;
    }
}

