/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.teatrove.tea.TypedElement;
import org.teatrove.tea.compiler.CompilationUnit;
import org.teatrove.tea.compiler.Compiler;
import org.teatrove.tea.compiler.ErrorEvent;
import org.teatrove.tea.compiler.ErrorListener;
import org.teatrove.tea.compiler.Generics;
import org.teatrove.tea.compiler.MessageFormatter;
import org.teatrove.tea.compiler.MethodMatcher;
import org.teatrove.tea.compiler.Scope;
import org.teatrove.tea.compiler.SourceDetailedInfo;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Token;
import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.AndExpression;
import org.teatrove.tea.parsetree.ArithmeticExpression;
import org.teatrove.tea.parsetree.ArrayLookup;
import org.teatrove.tea.parsetree.AssignmentStatement;
import org.teatrove.tea.parsetree.BinaryExpression;
import org.teatrove.tea.parsetree.Block;
import org.teatrove.tea.parsetree.BooleanLiteral;
import org.teatrove.tea.parsetree.BreakStatement;
import org.teatrove.tea.parsetree.CallExpression;
import org.teatrove.tea.parsetree.CompareExpression;
import org.teatrove.tea.parsetree.ConcatenateExpression;
import org.teatrove.tea.parsetree.ContinueStatement;
import org.teatrove.tea.parsetree.Directive;
import org.teatrove.tea.parsetree.ExceptionGuardStatement;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.ExpressionList;
import org.teatrove.tea.parsetree.ExpressionStatement;
import org.teatrove.tea.parsetree.ForeachStatement;
import org.teatrove.tea.parsetree.FunctionCallExpression;
import org.teatrove.tea.parsetree.IfStatement;
import org.teatrove.tea.parsetree.ImportDirective;
import org.teatrove.tea.parsetree.Lookup;
import org.teatrove.tea.parsetree.Name;
import org.teatrove.tea.parsetree.NegateExpression;
import org.teatrove.tea.parsetree.NewArrayExpression;
import org.teatrove.tea.parsetree.NoOpExpression;
import org.teatrove.tea.parsetree.Node;
import org.teatrove.tea.parsetree.NotExpression;
import org.teatrove.tea.parsetree.NullLiteral;
import org.teatrove.tea.parsetree.NumberLiteral;
import org.teatrove.tea.parsetree.OrExpression;
import org.teatrove.tea.parsetree.ParenExpression;
import org.teatrove.tea.parsetree.RelationalExpression;
import org.teatrove.tea.parsetree.ReturnStatement;
import org.teatrove.tea.parsetree.SpreadExpression;
import org.teatrove.tea.parsetree.Statement;
import org.teatrove.tea.parsetree.StatementList;
import org.teatrove.tea.parsetree.StringLiteral;
import org.teatrove.tea.parsetree.SubstitutionStatement;
import org.teatrove.tea.parsetree.Template;
import org.teatrove.tea.parsetree.TemplateCallExpression;
import org.teatrove.tea.parsetree.TernaryExpression;
import org.teatrove.tea.parsetree.TreeMutator;
import org.teatrove.tea.parsetree.TreeWalker;
import org.teatrove.tea.parsetree.TypeExpression;
import org.teatrove.tea.parsetree.TypeName;
import org.teatrove.tea.parsetree.Variable;
import org.teatrove.tea.parsetree.VariableRef;
import org.teatrove.tea.runtime.Substitution;
import org.teatrove.tea.util.BeanAnalyzer;
import org.teatrove.tea.util.GenericPropertyDescriptor;
import org.teatrove.trove.classfile.Modifiers;

public class TypeChecker {
    protected CompilationUnit mUnit;
    private String[] mImports;
    private boolean mHasImports = false;
    private Vector<ErrorListener> mListeners = new Vector(1);
    private int mErrorCount = 0;
    private ClassLoader mClassLoader;
    private boolean mExceptionGuardian;
    private MessageFormatter mFormatter;
    private int mForeachCount;

    public TypeChecker(CompilationUnit unit) {
        this.mUnit = unit;
        this.mImports = this.mUnit.getImportedPackages();
        this.mFormatter = MessageFormatter.lookup(this);
    }

    public void addErrorListener(ErrorListener listener) {
        this.mListeners.addElement(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.mListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchParseError(ErrorEvent e) {
        ++this.mErrorCount;
        Vector<ErrorListener> vector = this.mListeners;
        synchronized (vector) {
            for (int i = 0; i < this.mListeners.size(); ++i) {
                this.mListeners.elementAt(i).compileError(e);
            }
        }
    }

    private void error(String str, Node culprit) {
        str = this.mFormatter.format(str);
        this.dispatchParseError(new ErrorEvent((Object)this, str, culprit.getSourceInfo(), this.mUnit));
    }

    private void error(String str, String arg, Node culprit) {
        str = this.mFormatter.format(str, arg);
        this.dispatchParseError(new ErrorEvent((Object)this, str, culprit.getSourceInfo(), this.mUnit));
    }

    private void error(String str, String arg1, String arg2, Node culprit) {
        str = this.mFormatter.format(str, arg1, arg2);
        this.dispatchParseError(new ErrorEvent((Object)this, str, culprit.getSourceInfo(), this.mUnit));
    }

    private void error(String str, String arg1, String arg2, String arg3, Node culprit) {
        str = this.mFormatter.format(str, arg1, arg2, arg3);
        this.dispatchParseError(new ErrorEvent((Object)this, str, culprit.getSourceInfo(), this.mUnit));
    }

    private void error(String str, String arg, Token culprit) {
        str = this.mFormatter.format(str, arg);
        this.dispatchParseError(new ErrorEvent((Object)this, str, culprit.getSourceInfo(), this.mUnit));
    }

    private void error(String str, String arg, SourceInfo info) {
        str = this.mFormatter.format(str, arg);
        this.dispatchParseError(new ErrorEvent((Object)this, str, info, this.mUnit));
    }

    private void error(String str, String arg1, String arg2, SourceInfo info) {
        str = this.mFormatter.format(str, arg1, arg2);
        this.dispatchParseError(new ErrorEvent((Object)this, str, info, this.mUnit));
    }

    public void setClassLoader(ClassLoader loader) {
        this.mClassLoader = loader;
    }

    public void setExceptionGuardianEnabled(boolean enabled) {
        this.mExceptionGuardian = enabled;
    }

    private Class<?> loadClass(String name) throws ClassNotFoundException {
        while (true) {
            try {
                if (this.mClassLoader == null) {
                    return Class.forName(name);
                }
                return this.mClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                int index = name.lastIndexOf(46);
                if (index < 0) {
                    throw e;
                }
                name = name.substring(0, index) + '$' + name.substring(index + 1);
                continue;
            }
            break;
        }
    }

    public void typeCheck() {
        this.typeCheck(new Visitor());
    }

    public void typeCheck(Visitor visitor) {
        Template template = this.mUnit.getParseTree();
        Name name = template.getName();
        if (name != null && !this.mUnit.getShortName().equals(name.getName())) {
            this.error("template.name", this.mUnit.getShortName(), name);
        }
        template.accept(new ReturnConvertor());
        template.accept(new ConcatenationReducer());
        visitor.check(template);
        if (this.mErrorCount == 0 && this.mExceptionGuardian) {
            template.accept(new ExceptionGuardian());
        }
    }

    public int getErrorCount() {
        return this.mErrorCount;
    }

    static /* synthetic */ String[] access$402(TypeChecker x0, String[] x1) {
        x0.mImports = x1;
        return x1;
    }

    public static class ParameterizedTypeImpl
    implements ParameterizedType {
        private java.lang.reflect.Type rawType;
        private java.lang.reflect.Type ownerType;
        private java.lang.reflect.Type[] typeArguments;

        public ParameterizedTypeImpl(java.lang.reflect.Type rawType, java.lang.reflect.Type[] typeArguments) {
            this.rawType = rawType;
            this.typeArguments = typeArguments;
        }

        public ParameterizedTypeImpl(java.lang.reflect.Type ownerType, java.lang.reflect.Type rawType, java.lang.reflect.Type[] typeArguments) {
            this.rawType = rawType;
            this.ownerType = ownerType;
            this.typeArguments = typeArguments;
        }

        @Override
        public java.lang.reflect.Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public java.lang.reflect.Type getRawType() {
            return this.rawType;
        }

        @Override
        public java.lang.reflect.Type[] getActualTypeArguments() {
            return this.typeArguments;
        }

        public int hashCode() {
            int hash = 17;
            hash += 19 * this.rawType.hashCode();
            for (java.lang.reflect.Type argument : this.typeArguments) {
                hash += 23 * argument.hashCode();
            }
            return hash;
        }

        public boolean equals(Object object) {
            java.lang.reflect.Type[] otherArguments;
            if (object == this) {
                return true;
            }
            if (!(object instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType other = (ParameterizedType)object;
            if (!this.getRawType().equals(other.getRawType())) {
                return false;
            }
            java.lang.reflect.Type[] thisArguments = this.getActualTypeArguments();
            if (thisArguments.length != (otherArguments = other.getActualTypeArguments()).length) {
                return false;
            }
            for (int i = 0; i < thisArguments.length; ++i) {
                if (thisArguments[i].equals(otherArguments[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.getRawType()).append('<');
            boolean first = true;
            for (java.lang.reflect.Type argument : this.getActualTypeArguments()) {
                if (!first) {
                    buffer.append(',');
                }
                first = false;
                buffer.append(argument);
            }
            buffer.append('>');
            return buffer.toString();
        }
    }

    public static class GenericArrayTypeImpl
    implements GenericArrayType {
        private java.lang.reflect.Type componentType;

        public GenericArrayTypeImpl(java.lang.reflect.Type componentType) {
            this.componentType = componentType;
        }

        @Override
        public java.lang.reflect.Type getGenericComponentType() {
            return this.componentType;
        }

        public int hashCode() {
            int hash = 17 * this.componentType.hashCode();
            return hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType other = (GenericArrayType)object;
            return this.getGenericComponentType().equals(other.getGenericComponentType());
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.getGenericComponentType()).append("[]");
            return buffer.toString();
        }
    }

    private static class ConcatenationIncreaser
    extends TreeMutator {
        private ConcatenationIncreaser() {
        }

        @Override
        public Object visit(StatementList node) {
            super.visit(node);
            return new StatementList(node.getSourceInfo(), this.visit(node.getStatements()));
        }

        @Override
        public Object visit(Block node) {
            super.visit(node);
            return new Block(node.getSourceInfo(), this.visit(node.getStatements()));
        }

        private Statement[] visit(Statement[] stmts) {
            int length = stmts.length;
            ArrayList<Statement> statements = new ArrayList<Statement>();
            ArrayList<ExpressionStatement> expressionStatements = new ArrayList<ExpressionStatement>();
            for (int i = 0; i < length; ++i) {
                Expression expr;
                Statement stmt = stmts[i];
                if (stmt instanceof ExpressionStatement && !((expr = ((ExpressionStatement)stmt).getExpression()) instanceof CallExpression)) {
                    expressionStatements.add((ExpressionStatement)stmt);
                    continue;
                }
                this.merge(statements, expressionStatements);
                expressionStatements.clear();
                statements.add(stmt);
            }
            this.merge(statements, expressionStatements);
            stmts = new Statement[statements.size()];
            return statements.toArray(stmts);
        }

        private void merge(Collection<Statement> statements, List<ExpressionStatement> expressionStatements) {
            int size = expressionStatements.size();
            if (size != 0) {
                if (size == 1) {
                    statements.add(expressionStatements.get(0));
                } else {
                    ArrayList<Expression> expressions = new ArrayList<Expression>();
                    for (int i = 0; i < size; ++i) {
                        ExpressionStatement stmt = expressionStatements.get(i);
                        this.gatherExpressions(expressions, stmt.getExpression());
                    }
                    size = expressions.size();
                    Expression concat = (Expression)expressions.get(0);
                    for (int i = 1; i < size; ++i) {
                        Expression right = (Expression)expressions.get(i);
                        SourceInfo rightInfo = right.getSourceInfo();
                        SourceInfo info = concat.getSourceInfo().setEndPosition(rightInfo);
                        Token token = new Token(rightInfo, 28);
                        concat = new ConcatenateExpression(info, token, concat, right);
                    }
                    statements.add(new ExpressionStatement(concat));
                }
            }
        }

        private void gatherExpressions(Collection<Expression> expressions, Expression expr) {
            if (expr instanceof ConcatenateExpression) {
                ConcatenateExpression concat = (ConcatenateExpression)expr;
                this.gatherExpressions(expressions, concat.getLeftExpression());
                this.gatherExpressions(expressions, concat.getRightExpression());
            } else {
                expressions.add(expr);
            }
        }
    }

    private static class ConcatenationReducer
    extends TreeMutator {
        private ConcatenationReducer() {
        }

        @Override
        public Object visit(ExpressionStatement node) {
            super.visit(node);
            Expression expr = node.getExpression();
            if (!(expr instanceof ConcatenateExpression)) {
                return node;
            }
            ArrayList<Statement> statements = new ArrayList<Statement>();
            this.breakup(statements, (ConcatenateExpression)expr);
            Statement[] stmts = new Statement[statements.size()];
            stmts = statements.toArray(stmts);
            return new StatementList(node.getSourceInfo(), stmts);
        }

        private void breakup(Collection<Statement> statements, ConcatenateExpression concat) {
            Expression left = concat.getLeftExpression();
            if (left instanceof ConcatenateExpression) {
                this.breakup(statements, (ConcatenateExpression)left);
            } else {
                statements.add(new ExpressionStatement(left));
            }
            Expression right = concat.getRightExpression();
            if (right instanceof ConcatenateExpression) {
                this.breakup(statements, (ConcatenateExpression)right);
            } else {
                statements.add(new ExpressionStatement(right));
            }
        }
    }

    private static class ExceptionGuardian
    extends TreeMutator {
        private ExceptionGuardian() {
        }

        @Override
        public Object visit(AssignmentStatement node) {
            if (!node.getRValue().isExceptionPossible()) {
                return node;
            }
            SourceInfo info = node.getSourceInfo();
            VariableRef lvalue = node.getLValue();
            AssignmentStatement replacement = new AssignmentStatement(info, lvalue, new NullLiteral(info));
            return new ExceptionGuardStatement(node, replacement);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Object visit(ForeachStatement node) {
            body = node.getBody();
            if (body != null) {
                node.setBody(this.visitBlock(body));
            }
            guard = false;
            range = node.getRange();
            if (range == null) ** GOTO lbl-1000
            if (range.isExceptionPossible()) {
                guard = true;
            } else {
                type = range.getType();
                if (type != null && type.isNullable()) {
                    guard = true;
                } else if ((range = node.getEndRange()) != null) {
                    if (range.isExceptionPossible()) {
                        guard = true;
                    } else {
                        type = range.getType();
                        if (type != null && type.isNullable()) {
                            guard = true;
                        }
                    }
                }
            }
            if (!guard) {
                return node;
            }
            return new ExceptionGuardStatement(node, node.getInitializer());
        }

        @Override
        public Object visit(IfStatement node) {
            int length;
            Block block = node.getThenPart();
            if (block != null) {
                node.setThenPart(this.visitBlock(block));
            }
            if ((block = node.getElsePart()) != null) {
                node.setElsePart(this.visitBlock(block));
            }
            if (!node.getCondition().isExceptionPossible()) {
                return node;
            }
            Variable[] vars = node.getMergedVariables();
            if (vars == null || (length = vars.length) == 0) {
                return new ExceptionGuardStatement(node, null);
            }
            Statement[] replacements = new Statement[length];
            SourceInfo info = node.getSourceInfo();
            for (int i = 0; i < length; ++i) {
                Variable v = vars[i];
                VariableRef lvalue = new VariableRef(v.getSourceInfo(), v.getName());
                lvalue.setVariable(v);
                replacements[i] = new AssignmentStatement(info, lvalue, new NullLiteral(info));
            }
            StatementList replacement = new StatementList(info, replacements);
            return new ExceptionGuardStatement(node, replacement);
        }

        @Override
        public Object visit(SubstitutionStatement node) {
            return new ExceptionGuardStatement(node, null);
        }

        @Override
        public Object visit(ExpressionStatement node) {
            Expression expr = node.getExpression();
            if (expr != null) {
                if (expr instanceof CallExpression) {
                    expr = (CallExpression)expr.accept(this);
                    node.setExpression(expr);
                }
                if (expr.isExceptionPossible()) {
                    return new ExceptionGuardStatement(node, null);
                }
            }
            return node;
        }

        @Override
        public Object visit(ReturnStatement node) {
            Expression expr = node.getExpression();
            if (expr instanceof CallExpression) {
                node.setExpression((CallExpression)expr.accept(this));
            }
            return node;
        }

        @Override
        public Object visit(FunctionCallExpression node) {
            return this.visit((CallExpression)node);
        }

        @Override
        public Object visit(TemplateCallExpression node) {
            return this.visit((CallExpression)node);
        }

        private Object visit(CallExpression node) {
            Block subParam = node.getSubstitutionParam();
            if (subParam != null) {
                node.setSubstitutionParam(this.visitBlock(subParam));
            }
            return node;
        }
    }

    private static class ReturnConvertor
    extends TreeMutator {
        private boolean mReturnAdded;

        private ReturnConvertor() {
        }

        @Override
        public Object visit(Template node) {
            Statement stmt = node.getStatement();
            if (stmt != null) {
                stmt = (Statement)stmt.accept(this);
                if (!this.mReturnAdded) {
                    Statement[] stmts = new Statement[]{stmt, new ReturnStatement(stmt.getSourceInfo())};
                    stmt = new StatementList(stmt.getSourceInfo(), stmts);
                }
                node.setStatement(stmt);
            } else {
                node.setStatement(new ReturnStatement(node.getSourceInfo()));
            }
            return node;
        }

        @Override
        public Object visit(Statement node) {
            return node;
        }

        @Override
        public Object visit(ImportDirective node) {
            return node;
        }

        @Override
        public Object visit(StatementList node) {
            Statement[] statements = node.getStatements();
            for (int i = statements.length - 1; i >= 0; --i) {
                Statement stmt = statements[i];
                if (stmt == null) continue;
                statements[i] = (Statement)stmt.accept(this);
                break;
            }
            return node;
        }

        @Override
        public Object visit(Block node) {
            return this.visit((StatementList)node);
        }

        @Override
        public Object visit(ExpressionStatement node) {
            this.mReturnAdded = true;
            Expression expr = node.getExpression();
            if (expr instanceof CallExpression) {
                ((CallExpression)expr).setVoidPermitted(true);
            }
            return new ReturnStatement(expr);
        }

        @Override
        public Object visit(AssignmentStatement node) {
            return node;
        }

        @Override
        public Object visit(BreakStatement node) {
            return node;
        }

        @Override
        public Object visit(ContinueStatement node) {
            return node;
        }

        @Override
        public Object visit(ForeachStatement node) {
            return node;
        }

        @Override
        public Object visit(IfStatement node) {
            return node;
        }

        @Override
        public Object visit(SubstitutionStatement node) {
            return node;
        }

        @Override
        public Object visit(ReturnStatement node) {
            this.mReturnAdded = true;
            return node;
        }
    }

    private static class IsaDetector
    extends TreeWalker {
        private static final char NOT_OP = 'n';
        private static final char AND_OP = 'a';
        private static final char OR_OP = 'o';
        private StringBuffer mOpStack;
        private Collection<Variable> mThenCasts;
        private Collection<Variable> mElseCasts;

        private IsaDetector() {
        }

        public Variable[] getThenCasts() {
            if (this.mThenCasts == null) {
                return null;
            }
            Variable[] vars = new Variable[this.mThenCasts.size()];
            return this.mThenCasts.toArray(vars);
        }

        public Variable[] getElseCasts() {
            if (this.mElseCasts == null) {
                return null;
            }
            Variable[] vars = new Variable[this.mElseCasts.size()];
            return this.mElseCasts.toArray(vars);
        }

        @Override
        public Object visit(RelationalExpression node) {
            int operator = node.getOperator().getID();
            boolean forThenPart = operator != 24;
            boolean typeKnown = true;
            if (this.mOpStack != null) {
                int length = this.mOpStack.length();
                block5: for (int i = 0; i < length; ++i) {
                    switch (this.mOpStack.charAt(i)) {
                        case 'n': {
                            forThenPart = !forThenPart;
                            continue block5;
                        }
                        case 'a': {
                            if (forThenPart) continue block5;
                            typeKnown = false;
                            continue block5;
                        }
                        case 'o': {
                            if (!forThenPart) continue block5;
                            typeKnown = false;
                        }
                    }
                }
            }
            if (!typeKnown) {
                return super.visit(node);
            }
            if (operator == 49) {
                Type type;
                Expression left;
                TypeName typeName = node.getIsaTypeName();
                if (typeName != null && (left = node.getLeftExpression()) instanceof VariableRef && (type = typeName.getType()) != null) {
                    this.addCast((VariableRef)left, type.toNonNull(), forThenPart);
                }
            } else if (operator == 24 || operator == 27) {
                Type type;
                Expression test;
                VariableRef ref;
                Expression left = node.getLeftExpression();
                Expression right = node.getRightExpression();
                if (left instanceof VariableRef) {
                    ref = (VariableRef)left;
                    test = right;
                } else if (right instanceof VariableRef) {
                    ref = (VariableRef)right;
                    test = left;
                } else {
                    ref = null;
                    test = null;
                }
                if (test != null && test.isValueKnown() && test.getValue() == null && (type = ref.getType()) != null && !type.isNonNull()) {
                    this.addCast(ref, type.toNonNull(), forThenPart);
                }
            }
            return super.visit(node);
        }

        @Override
        public Object visit(NotExpression node) {
            this.pushOp('n');
            super.visit(node);
            this.popOp();
            return null;
        }

        @Override
        public Object visit(AndExpression node) {
            this.pushOp('a');
            super.visit(node);
            this.popOp();
            return null;
        }

        @Override
        public Object visit(OrExpression node) {
            this.pushOp('o');
            super.visit(node);
            this.popOp();
            return null;
        }

        private void pushOp(char op) {
            if (this.mOpStack == null) {
                this.mOpStack = new StringBuffer(4);
            }
            this.mOpStack.append(op);
        }

        private void popOp() {
            int length;
            if (this.mOpStack != null && (length = this.mOpStack.length()) > 0) {
                this.mOpStack.setLength(length - 1);
            }
        }

        private void addCast(VariableRef ref, Type type, boolean forThenPart) {
            Variable oldVar = ref.getVariable();
            if (oldVar != null) {
                Variable newVar = (Variable)oldVar.clone();
                if (newVar.getType() == null || !newVar.getType().equals(type)) {
                    newVar.setType(type);
                }
                newVar.setField(false);
                if (forThenPart) {
                    if (this.mThenCasts == null) {
                        this.mThenCasts = new ArrayList<Variable>(2);
                    }
                    this.mThenCasts.add(newVar);
                } else {
                    if (this.mElseCasts == null) {
                        this.mElseCasts = new ArrayList<Variable>(2);
                    }
                    this.mElseCasts.add(newVar);
                }
            }
        }
    }

    protected class Visitor
    extends TreeWalker {
        private Type mReturnType;
        private Scope mScope = new Scope();
        private Stack<String> mLoopVariables = new Stack();

        private Scope enterScope() {
            this.mScope = new Scope(this.mScope);
            return this.mScope;
        }

        private Scope exitScope() {
            this.mScope = this.mScope.getParent();
            return this.mScope;
        }

        private void defineVariable(VariableRef ref, Type type) {
            Variable v = ref.getVariable();
            boolean staticallyTyped = v != null ? v.isStaticallyTyped() : false;
            Variable newVar = null;
            if (v == null) {
                newVar = new Variable(ref.getSourceInfo(), ref.getName(), type, staticallyTyped);
            } else {
                newVar = new Variable(ref.getSourceInfo(), ref.getName(), v.getTypeName(), staticallyTyped);
                newVar.setType(type);
            }
            this.mScope.declareVariable(newVar);
            if (!this.mScope.bindToVariable(ref)) {
                TypeChecker.this.error("variable.undefined", ref.getName(), ref);
            }
        }

        public void check(Node node) {
            node.accept(this);
        }

        private void checkAccess(Class<?> clazz, Node node) {
            if (!Modifier.isPublic(clazz.getModifiers())) {
                TypeChecker.this.error("access.check", clazz.getName(), node);
            }
        }

        @Override
        public Object visit(Template node) {
            Type returnType;
            Statement stmt;
            Variable[] declared;
            this.enterScope();
            if (node.getDirectives() != null) {
                for (Directive directive : node.getDirectives()) {
                    this.check(directive);
                }
            }
            if ((declared = node.getParams()) != null) {
                for (int i = 0; i < declared.length; ++i) {
                    this.check(declared[i]);
                }
            }
            if ((stmt = node.getStatement()) != null) {
                this.check(stmt);
            }
            if ((returnType = this.mReturnType) == null) {
                returnType = Type.VOID_TYPE;
            }
            node.setReturnType(returnType);
            this.exitScope();
            return null;
        }

        @Override
        public Object visit(Name node) {
            return null;
        }

        protected Class<?> lookupType(String name, int dim, Node node) {
            String checkName;
            StringBuffer fb = new StringBuffer(name);
            if (name != null && !name.isEmpty() && name.charAt(0) == '[') {
                fb.deleteCharAt(name.lastIndexOf(91) + 1);
                int i = 0;
                while ((i = fb.indexOf("[")) != -1) {
                    fb.deleteCharAt(i);
                }
                i = fb.indexOf(";");
                if (i != -1) {
                    fb.deleteCharAt(i);
                }
            }
            String fixedName = checkName = fb.toString();
            String errorMsg = null;
            boolean resolved = false;
            Class<Comparable<Boolean>> resolvedClass = null;
            String resolvedPackage = TypeChecker.this.mImports[0];
            for (int i = -1; i < TypeChecker.this.mImports.length; ++i) {
                if (i >= 0) {
                    checkName = TypeChecker.this.mImports[i] + '.' + fixedName;
                }
                try {
                    Class<Serializable> clazz = null;
                    clazz = checkName.equals("boolean") ? Boolean.TYPE : (checkName.equals("int") ? Integer.TYPE : (checkName.equals("double") ? Double.TYPE : (checkName.equals("long") ? Long.TYPE : (checkName.equals("short") ? Short.TYPE : TypeChecker.this.loadClass(checkName)))));
                    this.checkAccess(clazz, node);
                    if (dim > 0) {
                        clazz = Array.newInstance(clazz, new int[dim]).getClass();
                    }
                    errorMsg = null;
                    if (!resolved) {
                        if (!TypeChecker.this.mHasImports) {
                            return clazz;
                        }
                        resolved = true;
                        resolvedClass = clazz;
                        if (i > 0) {
                            resolvedPackage = TypeChecker.this.mImports[i];
                        }
                        continue;
                    }
                    if (i >= 0) {
                        TypeChecker.this.error("typename.package.conflict", name, resolvedPackage, TypeChecker.this.mImports[i], node);
                    }
                    return clazz;
                }
                catch (ClassNotFoundException e) {
                    if (errorMsg != null) continue;
                    errorMsg = TypeChecker.this.mFormatter.format("typename.unknown", name);
                    continue;
                }
                catch (RuntimeException e) {
                    TypeChecker.this.error(e.toString(), node);
                    return null;
                }
                catch (LinkageError e) {
                    TypeChecker.this.error(e.toString(), node);
                    return null;
                }
            }
            if (!resolved && errorMsg != null && node != null) {
                TypeChecker.this.error(errorMsg, node);
            }
            return resolvedClass;
        }

        @Override
        public Object visit(TypeName node) {
            String name = node.getName();
            Class<?> clazz = this.lookupType(name, node.getDimensions(), node);
            if (clazz != null) {
                this.checkGenericTypeNames(clazz, node);
            }
            return null;
        }

        protected void checkGenericTypeNames(Class<?> rawType, TypeName node) {
            TypeName[] genericTypes = node.getGenericTypes();
            if (genericTypes != null) {
                java.lang.reflect.Type[] arguments = new java.lang.reflect.Type[genericTypes.length];
                for (int i = 0; i < genericTypes.length; ++i) {
                    this.check(genericTypes[i]);
                    Type result = genericTypes[i].getType();
                    arguments[i] = result != null ? result.getGenericClass() : Object.class;
                }
                node.setType(new Type(rawType, new ParameterizedTypeImpl(rawType, arguments)));
            } else {
                node.setType(new Type(rawType));
            }
        }

        @Override
        public Object visit(Variable node) {
            String name = node.getName();
            Variable v = this.mScope.getDeclaredVariable(name);
            if (v == null) {
                this.mScope.declareVariable(node);
            } else {
                TypeChecker.this.error("variable.declared", name, node);
                TypeChecker.this.error("variable.declared.here", name, v);
            }
            TypeName typeName = node.getTypeName();
            this.check(typeName);
            node.setType(typeName.getType());
            return null;
        }

        @Override
        public Object visit(ExpressionList node) {
            Expression[] exprs = node.getExpressions();
            for (int i = 0; i < exprs.length; ++i) {
                this.check(exprs[i]);
            }
            return null;
        }

        public Object visit(Directive node) {
            if (node instanceof ImportDirective) {
                return this.visit((ImportDirective)node);
            }
            return null;
        }

        @Override
        public Object visit(ImportDirective node) {
            String packageName = node.getName();
            TypeChecker.this.mHasImports = true;
            LinkedHashSet<String> importSet = new LinkedHashSet<String>(Arrays.asList(TypeChecker.this.mImports));
            if (!importSet.contains(packageName)) {
                importSet.add(packageName);
                TypeChecker.access$402(TypeChecker.this, importSet.toArray(new String[importSet.size()]));
            }
            return null;
        }

        @Override
        public Object visit(Statement node) {
            return null;
        }

        @Override
        public Object visit(StatementList node) {
            Statement[] stmts = node.getStatements();
            for (int i = 0; i < stmts.length; ++i) {
                if (i > 0 && stmts[i - 1].isBreak() && stmts[i].getClass() != Statement.class) {
                    TypeChecker.this.error("break.code.unreachable", stmts[i]);
                }
                this.check(stmts[i]);
            }
            return null;
        }

        @Override
        public Object visit(Block node) {
            return this.visit((StatementList)node);
        }

        @Override
        public Object visit(AssignmentStatement node) {
            VariableRef lvalue = node.getLValue();
            String lname = lvalue.getName();
            if (this.mLoopVariables.contains(lname)) {
                TypeChecker.this.error("foreach.loopvar.nomodify", lname, node.getSourceInfo());
                return null;
            }
            Expression rvalue = node.getRValue();
            this.check(rvalue);
            Type type = rvalue.getType();
            if (type != null) {
                Class<?> rclass = type.getObjectClass();
                Variable dvar = this.mScope.getDeclaredVariable(lname);
                if (dvar == null) {
                    dvar = lvalue.getVariable();
                }
                if (dvar != null && dvar.isStaticallyTyped()) {
                    this.check(dvar.getTypeName());
                    if (dvar.getType() == null) {
                        dvar.setType(dvar.getTypeName().getType());
                    }
                    if (dvar.getType() == null) {
                        return null;
                    }
                    Class<?> lclass = dvar.getType().getObjectClass();
                    if (lvalue.getVariable() == null) {
                        lvalue.setVariable(dvar);
                    }
                    if (!type.isPrimitive()) {
                        type = dvar.getType();
                    }
                    if (rclass != null && lclass != null && rclass.isAssignableFrom(lclass) && rclass != lclass) {
                        type = dvar.getType();
                        if (rvalue instanceof NullLiteral && type.isPrimitive()) {
                            TypeChecker.this.error("variable.primitive.uninitialized", type.getNaturalClass().getName(), node);
                            return null;
                        }
                        rvalue.convertTo(type.toNullable());
                    } else if (rclass != lclass) {
                        if (lclass != null && rclass != null && lclass.isAssignableFrom(rclass)) {
                            rvalue.convertTo(dvar.getType().toNullable());
                        } else if (rclass != lclass) {
                            TypeChecker.this.error("assignmentstatement.cast.invalid", rclass.getName(), lclass.getName(), node);
                            return null;
                        }
                    }
                }
            }
            if (type != null) {
                if (TypeChecker.this.mExceptionGuardian && rvalue.isExceptionPossible() && type.isNonNull()) {
                    rvalue.convertTo(type.toNullable());
                    type = rvalue.getType();
                }
                this.defineVariable(lvalue, type);
            }
            return null;
        }

        @Override
        public Object visit(BreakStatement node) {
            if (TypeChecker.this.mForeachCount <= 0) {
                TypeChecker.this.error("break.not.inside.foreach", node);
            }
            return null;
        }

        @Override
        public Object visit(ContinueStatement node) {
            if (TypeChecker.this.mForeachCount <= 0) {
                TypeChecker.this.error("continue.not.inside.foreach", node);
            }
            return null;
        }

        @Override
        public Object visit(ForeachStatement node) {
            Type elementType;
            Type endRangeType;
            ++TypeChecker.this.mForeachCount;
            VariableRef loopVar = node.getLoopVariable();
            String varName = loopVar.getName();
            if (this.mLoopVariables.contains(varName)) {
                TypeChecker.this.error("foreach.loopvar.noreuse", varName, loopVar.getSourceInfo());
                return null;
            }
            this.mLoopVariables.push(varName);
            Expression range = node.getRange();
            Expression endRange = node.getEndRange();
            Block body = node.getBody();
            this.check(range);
            Type rangeType = range.getType();
            if (endRange == null) {
                endRangeType = null;
            } else {
                this.check(endRange);
                endRangeType = endRange.getType();
            }
            if (rangeType == null || endRange != null && endRangeType == null) {
                this.enterScope();
                this.check(body);
                this.exitScope();
                this.mLoopVariables.pop();
                --TypeChecker.this.mForeachCount;
                return null;
            }
            Class<?> rangeClass = rangeType.getObjectClass();
            if (endRangeType == null) {
                if (loopVar.getVariable() != null && loopVar.getVariable().isStaticallyTyped()) {
                    this.check(loopVar.getVariable().getTypeName());
                    try {
                        if (rangeType.getIterationElementType() == null) {
                            TypeChecker.this.error("foreach.as.collection.required", rangeType.getSimpleName(), range);
                        }
                    }
                    catch (IntrospectionException e) {
                        TypeChecker.this.error(e.toString(), node);
                        return null;
                    }
                    elementType = loopVar.getVariable().getTypeName().getType();
                    if (rangeClass.isArray() && !rangeClass.getComponentType().isAssignableFrom(elementType.getNaturalClass()) && !elementType.getNaturalClass().isAssignableFrom(rangeClass.getComponentType())) {
                        try {
                            TypeChecker.this.error("foreach.as.not.assignable", elementType.getSimpleName(), rangeType.getArrayElementType().getSimpleName(), range);
                        }
                        catch (IntrospectionException e) {
                            TypeChecker.this.error(e.toString(), node);
                            return null;
                        }
                    }
                } else {
                    try {
                        elementType = rangeType.getIterationElementType();
                    }
                    catch (IntrospectionException e) {
                        TypeChecker.this.error(e.toString(), node);
                        return null;
                    }
                }
                if (elementType == null) {
                    TypeChecker.this.error("foreach.iteration.not.supported", rangeType.getSimpleName(), range);
                } else {
                    this.checkAccess(elementType.getNaturalClass(), range);
                    if (node.isReverse() && !rangeType.isReverseIterationSupported()) {
                        TypeChecker.this.error("foreach.reverse.not.supported", rangeType.getSimpleName(), range);
                    }
                }
            } else {
                elementType = Type.INT_TYPE;
                if (!Number.class.isAssignableFrom(rangeClass)) {
                    TypeChecker.this.error("foreach.range.start", rangeType.getSimpleName(), range);
                    range.setType(elementType);
                } else if (Long.class.isAssignableFrom(rangeClass)) {
                    elementType = Type.LONG_TYPE;
                }
                Class<?> endRangeClass = endRangeType.getObjectClass();
                if (!Number.class.isAssignableFrom(endRangeClass)) {
                    TypeChecker.this.error("foreach.range.end", endRangeType.getSimpleName(), endRange);
                    endRange.setType(elementType);
                } else if (Long.class.isAssignableFrom(endRangeClass)) {
                    elementType = Type.LONG_TYPE;
                }
                range.convertTo(elementType);
                endRange.convertTo(elementType);
            }
            Scope bodyScope = this.enterScope();
            if (elementType != null) {
                this.defineVariable(loopVar, elementType);
            }
            this.check(body);
            this.exitScope();
            Variable[] vars = bodyScope.promote();
            if (vars.length > 0) {
                node.setInitializer(this.createConversions(this.mScope, vars, node.getSourceInfo()));
                body.setFinalizer(this.createConversions(bodyScope, vars, body.getSourceInfo()));
                this.mScope.declareVariables(vars);
                if (TypeChecker.this.mErrorCount == 0) {
                    bodyScope.delete();
                    bodyScope = this.enterScope();
                    if (elementType != null) {
                        this.defineVariable(loopVar, elementType);
                    }
                    this.check(body);
                    this.exitScope();
                }
            }
            this.mLoopVariables.pop();
            --TypeChecker.this.mForeachCount;
            return null;
        }

        @Override
        public Object visit(IfStatement node) {
            Statement stmt;
            Expression condition = node.getCondition();
            Block thenPart = node.getThenPart();
            Block elsePart = node.getElsePart();
            Variable[] thenCasts = null;
            Variable[] elseCasts = null;
            int preCondErrorCount = TypeChecker.this.mErrorCount;
            this.check(condition);
            if (preCondErrorCount == TypeChecker.this.mErrorCount) {
                IsaDetector detector = new IsaDetector();
                condition.accept(detector);
                thenCasts = detector.getThenCasts();
                elseCasts = detector.getElseCasts();
            }
            Scope thenScope = null;
            Scope elseScope = null;
            thenScope = this.enterScope();
            if (thenPart != null) {
                stmt = this.createCasts(thenScope, thenCasts, thenPart.getSourceInfo());
                this.check(thenPart);
                thenPart.setInitializer(stmt);
            }
            this.exitScope();
            elseScope = this.enterScope();
            if (elsePart != null) {
                stmt = this.createCasts(elseScope, elseCasts, elsePart.getSourceInfo());
                this.check(elsePart);
                elsePart.setInitializer(stmt);
            }
            this.exitScope();
            Variable[] vars = thenScope.intersect(elseScope);
            if (vars.length == 0) {
                node.setMergedVariables(vars);
            } else {
                if (TypeChecker.this.mExceptionGuardian && condition.isExceptionPossible()) {
                    for (int i = 0; i < vars.length; ++i) {
                        Variable v = vars[i];
                        Type t = v.getType();
                        if (!t.isNonNull()) continue;
                        v = (Variable)v.clone();
                        v.setType(t.toNullable());
                        vars[i] = v;
                    }
                }
                node.setMergedVariables(vars);
                if (thenPart == null) {
                    thenPart = new Block(node.getSourceInfo());
                    node.setThenPart(thenPart);
                }
                Statement fin = this.createConversions(thenScope, vars, thenPart.getSourceInfo());
                thenPart.setFinalizer(fin);
                if (elsePart == null) {
                    elsePart = new Block(node.getSourceInfo());
                    node.setElsePart(elsePart);
                }
                fin = this.createConversions(elseScope, vars, elsePart.getSourceInfo());
                elsePart.setFinalizer(fin);
                this.mScope.declareVariables(vars);
            }
            return null;
        }

        private Statement createCasts(Scope scope, Variable[] newVars, SourceInfo info) {
            if (newVars == null) {
                return null;
            }
            int length = newVars.length;
            if (length == 0) {
                return null;
            }
            ArrayList<AssignmentStatement> newStatements = new ArrayList<AssignmentStatement>(length);
            for (int i = 0; i < length; ++i) {
                VariableRef rvalue;
                VariableRef lvalue;
                block6: {
                    Variable newVar = newVars[i];
                    String name = newVar.getName();
                    Variable oldVar = scope.getDeclaredVariable(name);
                    if ((newVar = scope.declareVariable(newVar, true)) == oldVar) continue;
                    lvalue = new VariableRef(info, name);
                    scope.bindToVariable(lvalue);
                    lvalue.setVariable(newVar);
                    rvalue = new VariableRef(info, name);
                    scope.bindToVariable(rvalue);
                    rvalue.setVariable(oldVar);
                    try {
                        rvalue.convertTo(newVar.getType(), true);
                    }
                    catch (IllegalArgumentException e) {
                        if (TypeChecker.this.mErrorCount != 0) break block6;
                        throw e;
                    }
                }
                newStatements.add(new AssignmentStatement(info, lvalue, rvalue));
            }
            if (newStatements.size() == 0) {
                return null;
            }
            Statement[] stmts = new Statement[newStatements.size()];
            stmts = newStatements.toArray(stmts);
            return new StatementList(info, stmts);
        }

        private Statement createConversions(Scope scope, Variable[] newVars, SourceInfo info) {
            if (newVars == null) {
                return null;
            }
            int length = newVars.length;
            if (length == 0) {
                return null;
            }
            ArrayList<AssignmentStatement> newStatements = new ArrayList<AssignmentStatement>(length);
            for (int i = 0; i < length; ++i) {
                Variable newVar = newVars[i];
                String name = newVar.getName();
                Variable oldVar = scope.getDeclaredVariable(name);
                if ((newVar = scope.declareVariable(newVar)) == oldVar) continue;
                VariableRef lvalue = new VariableRef(info, name);
                scope.bindToVariable(lvalue);
                lvalue.setVariable(newVar);
                VariableRef rvalue = new VariableRef(info, name);
                scope.bindToVariable(rvalue);
                rvalue.setVariable(oldVar);
                rvalue.convertTo(newVar.getType(), false);
                newStatements.add(new AssignmentStatement(info, lvalue, rvalue));
            }
            if (newStatements.size() == 0) {
                return null;
            }
            Statement[] stmts = new Statement[newStatements.size()];
            stmts = newStatements.toArray(stmts);
            return new StatementList(info, stmts);
        }

        @Override
        public Object visit(SubstitutionStatement node) {
            if (!TypeChecker.this.mUnit.getParseTree().hasSubstitutionParam()) {
                TypeChecker.this.error("substitution.undeclared", node);
            }
            return null;
        }

        @Override
        public Object visit(ExpressionStatement node) {
            Expression expr = node.getExpression();
            if (expr instanceof CallExpression) {
                ((CallExpression)expr).setVoidPermitted(true);
            }
            this.check(expr);
            Type type = expr.getType();
            Compiler c = TypeChecker.this.mUnit.getCompiler();
            if (type != null && type.getNaturalClass() != Void.TYPE && c != null) {
                String name;
                Method[] methods = c.getRuntimeContextMethods();
                int cnt = MethodMatcher.match(methods, name = c.getRuntimeReceiver(), type);
                if (cnt < 1) {
                    TypeChecker.this.error("expressionstatement.receiver", expr.getType().getSimpleName(), node);
                } else {
                    Method receiver = methods[0];
                    node.setReceiverMethod(receiver);
                    expr.convertTo(new Type(receiver.getParameterTypes()[0], receiver.getGenericParameterTypes()[0]));
                }
            }
            return null;
        }

        @Override
        public Object visit(ReturnStatement node) {
            Type type;
            Expression expr = node.getExpression();
            if (expr != null) {
                this.check(expr);
                type = expr.getType();
            } else {
                type = Type.VOID_TYPE;
            }
            if (this.mReturnType == null) {
                this.mReturnType = type;
            } else {
                Type newType = this.mReturnType.getCompatibleType(type);
                if (newType == null) {
                    TypeChecker.this.error("returnstatement.type", type.getSimpleName(), this.mReturnType.getSimpleName(), node);
                }
                this.mReturnType = newType;
                if (expr != null) {
                    expr.convertTo(this.mReturnType);
                }
            }
            return null;
        }

        @Override
        public Object visit(Expression node) {
            return null;
        }

        @Override
        public Object visit(ParenExpression node) {
            Expression expr = node.getExpression();
            this.check(expr);
            return null;
        }

        @Override
        public Object visit(NewArrayExpression node) {
            ExpressionList list = node.getExpressionList();
            this.check(list);
            Expression[] exprs = list.getExpressions();
            if (node.isAssociative()) {
                if (exprs.length % 2 != 0) {
                    TypeChecker.this.error("newarrayexpression.associative", node);
                }
                Type elementType = this.newArrayElementType(exprs, 1, 2);
                elementType = elementType.toNonPrimitive().toNullable();
                Type arrayType = new Type(Map.class);
                try {
                    arrayType = arrayType.setArrayElementType(elementType);
                }
                catch (IntrospectionException e) {
                    TypeChecker.this.error(e.toString(), node);
                    return null;
                }
                node.setType(arrayType);
                for (int i = 0; i < exprs.length; i += 2) {
                    exprs[i].convertTo(Type.OBJECT_TYPE);
                }
            } else {
                Type elementType = this.newArrayElementType(exprs, 0, 1);
                Class<?> elementClass = elementType.getNaturalClass();
                Class<?> arrayClass = Array.newInstance(elementClass, 0).getClass();
                Type arrayType = new Type(arrayClass, new GenericArrayTypeImpl(elementType.getGenericClass()));
                if (elementType.isNonNull()) {
                    try {
                        arrayType = arrayType.setArrayElementType(elementType);
                    }
                    catch (IntrospectionException e) {
                        // empty catch block
                    }
                }
                node.setType(arrayType);
            }
            return null;
        }

        private Type newArrayElementType(Expression[] exprs, int start, int increment) {
            Type elementType = null;
            for (int i = start; i < exprs.length; i += increment) {
                Type type = exprs[i].getType();
                elementType = elementType == null ? type : elementType.getCompatibleType(type);
            }
            if (elementType == null) {
                elementType = Type.NULL_TYPE;
            }
            return elementType;
        }

        @Override
        public Object visit(FunctionCallExpression node) {
            if (!this.initialCallExpressionCheck(node)) {
                return null;
            }
            Expression[] exprs = node.getParams().getExpressions();
            int length = exprs.length;
            Type[] actualTypes = new Type[length];
            for (int i = 0; i < length; ++i) {
                actualTypes[i] = exprs[i].getType();
            }
            Block subParam = node.getSubstitutionParam();
            Compiler compiler = TypeChecker.this.mUnit.getCompiler();
            String name = node.getTarget().getName();
            name = name.replace('.', '$');
            Method m = null;
            Expression expr = node.getExpression();
            if (m == null) {
                if (subParam != null) {
                    Type[] types = new Type[length + 1];
                    System.arraycopy(actualTypes, 0, types, 0, length);
                    types[length] = new Type(Substitution.class);
                    actualTypes = types;
                }
                Method[] methods = new Method[]{};
                if (expr == null) {
                    methods = compiler.getRuntimeContextMethods();
                } else {
                    Type exprType = expr.getType();
                    if (exprType != null) {
                        methods = exprType.getObjectClass().getMethods();
                    }
                }
                int cnt = MethodMatcher.match(methods, name, actualTypes);
                if (cnt <= 0) {
                    TypeChecker.this.error("functioncallexpression.not.found", node);
                    return null;
                }
                m = methods[0];
            }
            node.setCalledMethod(m);
            for (int i = 0; i < length; ++i) {
                Type converted = MethodMatcher.getMethodParam(m, i, exprs[i].getType());
                exprs[i].convertTo(converted, false);
            }
            Class<?> retClass = m.getReturnType();
            java.lang.reflect.Type genericClass = m.getGenericReturnType();
            TypedElement te = m.getAnnotation(TypedElement.class);
            this.checkAccess(retClass, node);
            Type retType = retClass == Character.TYPE ? Type.NON_NULL_STRING_TYPE : (retClass == Character.class ? Type.STRING_TYPE : (te != null ? new Type(retClass, genericClass, te) : new Type(retClass, genericClass)));
            node.setType(retType);
            if (retClass == Void.TYPE && !node.isVoidPermitted()) {
                TypeChecker.this.error("functioncallexpression.function.void", node);
            }
            return null;
        }

        @Override
        public Object visit(TemplateCallExpression node) {
            Type retType;
            String name;
            if (!this.initialCallExpressionCheck(node)) {
                return null;
            }
            Expression[] exprs = node.getParams().getExpressions();
            int length = exprs.length;
            Type[] actualTypes = new Type[length];
            for (int i = 0; i < length; ++i) {
                actualTypes[i] = exprs[i].getType();
            }
            Block subParam = node.getSubstitutionParam();
            Compiler compiler = TypeChecker.this.mUnit.getCompiler();
            CompilationUnit unit = compiler.getCompilationUnit(name = node.getTarget().getName(), TypeChecker.this.mUnit);
            if (unit == null) {
                TypeChecker.this.error("templatecallexpression.not.found", node);
                return null;
            }
            Template tree = unit.getParseTree();
            Variable[] formalParams = tree.getParams();
            if (formalParams != null) {
                if (formalParams.length != length) {
                    TypeChecker.this.error("templatecallexpression.parameter.count", String.valueOf(formalParams.length), String.valueOf(length), node);
                    return null;
                }
                if (subParam != null && !tree.hasSubstitutionParam()) {
                    TypeChecker.this.error("templatecallexpression.substitution.no", tree.getName().getName(), subParam);
                    return null;
                }
                if (subParam == null && tree.hasSubstitutionParam()) {
                    TypeChecker.this.error("templatecallexpression.substitution.yes", tree.getName().getName(), node);
                }
                node.setCalledTemplate(unit);
                for (int i = 0; i < length; ++i) {
                    Type type = formalParams[i].getType();
                    if (type == null) {
                        TypeChecker.this.error("templatecallexpression.parameter.unknown", node);
                        return null;
                    }
                    int cost = type.convertableFrom(actualTypes[i]);
                    if (cost < 0) {
                        node.setCalledTemplate(null);
                        String msg1 = actualTypes[i].getFullName();
                        String msg2 = type.getFullName();
                        ClassLoader CL1 = actualTypes[i].getNaturalClass().getClassLoader();
                        ClassLoader CL2 = type.getNaturalClass().getClassLoader();
                        if (CL1 != CL2) {
                            msg1 = msg1 + "(" + CL1 + ")";
                            msg2 = msg2 + "(" + CL2 + ")";
                        }
                        TypeChecker.this.error("templatecallexpression.conversion", msg1, msg2, exprs[i]);
                        continue;
                    }
                    exprs[i].convertTo(type, false);
                }
            }
            if ((retType = tree.getReturnType()) == null) {
                retType = Type.VOID_TYPE;
            }
            node.setType(retType);
            if (Type.VOID_TYPE.equals(retType) && !node.isVoidPermitted()) {
                TypeChecker.this.error("templatecallexpression.template.void", node);
                return null;
            }
            return null;
        }

        private boolean initialCallExpressionCheck(CallExpression node) {
            Block subParam;
            Expression expr = node.getExpression();
            if (expr instanceof VariableRef) {
                String name = ((VariableRef)expr).getName();
                if (this.mScope.getDeclaredVariable(name) == null) {
                    Class<?> type = this.lookupType(name, 0, null);
                    if (type != null) {
                        if ((expr = this.checkForTypeExpression(expr)) == null) {
                            return false;
                        }
                        node.setExpression(expr);
                    } else {
                        Name target = node.getTarget();
                        String tname = name + '.' + target.getName();
                        expr = null;
                        node.setExpression(null);
                        node.setTarget(new Name(target.getSourceInfo(), tname));
                    }
                }
            } else if (expr instanceof Lookup) {
                if ((expr = this.checkForTypeExpression(expr)) == null) {
                    return false;
                }
                node.setExpression(expr);
            }
            if (expr != null) {
                this.check(expr);
            }
            ExpressionList params = node.getParams();
            this.check(params);
            Statement init = node.getInitializer();
            if (init != null) {
                this.check(init);
            }
            if ((subParam = node.getSubstitutionParam()) != null) {
                Scope subScope = this.enterScope();
                this.check(subParam);
                this.exitScope();
                Variable[] vars = subScope.promote();
                if (vars.length > 0) {
                    node.setInitializer(this.createConversions(this.mScope, vars, node.getSourceInfo()));
                    subParam.setFinalizer(this.createConversions(subScope, vars, subParam.getSourceInfo()));
                    for (int i = 0; i < vars.length; ++i) {
                        vars[i].setField(true);
                    }
                    this.mScope.declareVariables(vars);
                    if (TypeChecker.this.mErrorCount == 0) {
                        subScope.delete();
                        subScope = this.enterScope();
                        this.check(subParam);
                        this.exitScope();
                    }
                }
                VariableRef[] refs = subScope.getOutOfScopeVariableRefs();
                for (int i = 0; i < refs.length; ++i) {
                    refs[i].getVariable().setField(true);
                }
            }
            Expression[] exprs = params.getExpressions();
            int length = exprs.length;
            for (int i = 0; i < length; ++i) {
                if (exprs[i].getType() != null) continue;
                return false;
            }
            Compiler compiler = TypeChecker.this.mUnit.getCompiler();
            return compiler != null;
        }

        @Override
        public Object visit(VariableRef node) {
            if (!this.mScope.bindToVariable(node)) {
                TypeChecker.this.error("variableref.undefined", node.getName(), node);
            }
            return null;
        }

        protected Expression checkForTypeExpression(Expression expr) {
            if (expr instanceof VariableRef) {
                String name = ((VariableRef)expr).getName();
                if (this.mScope.getDeclaredVariable(name) == null) {
                    Class<?> type = this.lookupType(name, 0, null);
                    if (type != null) {
                        SourceInfo info = expr.getSourceInfo();
                        TypeName typeName = new TypeName(info, type.getName());
                        return new TypeExpression(info, typeName);
                    }
                    TypeChecker.this.error("variable.not.declared", expr);
                    return null;
                }
            } else if (expr instanceof Lookup) {
                Expression parent = expr;
                ArrayList<Lookup> lookups = new ArrayList<Lookup>(10);
                while (parent instanceof Lookup) {
                    lookups.add(0, (Lookup)parent);
                    parent = ((Lookup)parent).getExpression();
                }
                if (parent instanceof VariableRef) {
                    String name = ((VariableRef)parent).getName();
                    if (this.mScope.getDeclaredVariable(name) != null) {
                        return expr;
                    }
                    Class<?> type = this.lookupType(name, 0, null);
                    if (type != null) {
                        SourceInfo info = parent.getSourceInfo();
                        TypeName typeName = new TypeName(info, type.getName());
                        TypeExpression typeExpr = new TypeExpression(info, typeName);
                        ((Lookup)lookups.get(0)).setExpression(typeExpr);
                        return expr;
                    }
                    String fqName = name;
                    int size = lookups.size();
                    for (int i = 0; i < size; ++i) {
                        Lookup lookup = (Lookup)lookups.get(i);
                        String section = lookup.getLookupName().getName();
                        type = this.lookupType(fqName = fqName.concat(".".concat(section)), 0, null);
                        if (type == null) continue;
                        SourceInfo info = lookup.getSourceInfo();
                        TypeName typeName = new TypeName(info, type.getName());
                        TypeExpression typeExpr = new TypeExpression(info, typeName);
                        if (i + 1 < size) {
                            ((Lookup)lookups.get(i + 1)).setExpression(typeExpr);
                            return expr;
                        }
                        return typeExpr;
                    }
                    TypeChecker.this.error("variable.not.declared", expr);
                    return null;
                }
            }
            return expr;
        }

        @Override
        public Object visit(Lookup node) {
            Expression expr = this.checkForTypeExpression(node.getExpression());
            if (expr == null) {
                return null;
            }
            node.setExpression(expr);
            this.check(expr);
            Type type = expr.getType();
            String lookupName = node.getLookupName().getName();
            if (type != null && lookupName != null) {
                Map<String, PropertyDescriptor> properties;
                Class<?> clazz = type.getObjectClass();
                type = type.toNonPrimitive();
                expr.convertTo(type);
                if (expr instanceof TypeExpression) {
                    String property = node.getLookupName().getName();
                    Field field = null;
                    try {
                        field = clazz.getField(property);
                    }
                    catch (Exception exception) {
                        TypeChecker.this.error("property.not.found", node);
                        return true;
                    }
                    if (!Modifiers.isStatic((int)field.getModifiers())) {
                        TypeChecker.this.error("field.not.static", node);
                        return true;
                    }
                    node.setReadProperty(field);
                    node.setType(new Type(field.getType(), field.getGenericType()));
                    return null;
                }
                if ("length".equals(lookupName)) {
                    if (clazz == String.class) {
                        node.setType(Type.INT_TYPE);
                        try {
                            node.setReadMethod(clazz.getMethod("length", new Class[0]));
                            return null;
                        }
                        catch (NoSuchMethodException e) {
                            throw new LinkageError(e.toString());
                        }
                    }
                    if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
                        node.setType(Type.INT_TYPE);
                        try {
                            node.setReadMethod(clazz.getMethod("size", new Class[0]));
                            return null;
                        }
                        catch (NoSuchMethodException e) {
                            throw new LinkageError(e.toString());
                        }
                    }
                    if (clazz.isArray()) {
                        node.setType(Type.INT_TYPE);
                        return null;
                    }
                }
                try {
                    properties = BeanAnalyzer.getAllProperties(type.getGenericType());
                }
                catch (IntrospectionException e) {
                    TypeChecker.this.error(e.toString(), node);
                    return null;
                }
                PropertyDescriptor prop = properties.get(lookupName);
                if (prop == null) {
                    TypeChecker.this.error("lookup.undefined", lookupName, type.getSimpleName(), node.getLookupName());
                    return null;
                }
                Type nodeType = null;
                if (prop instanceof GenericPropertyDescriptor) {
                    nodeType = new Type(((GenericPropertyDescriptor)prop).getGenericPropertyType());
                }
                Method rmethod = null;
                if (prop != null) {
                    rmethod = prop.getReadMethod();
                    if (rmethod == null) {
                        TypeChecker.this.error("lookup.unreadable", lookupName, node.getLookupName());
                        return null;
                    }
                    Class<?> retClass = rmethod.getReturnType();
                    if (retClass == null) {
                        TypeChecker.this.error("lookup.array.only", lookupName, node.getLookupName());
                        return null;
                    }
                    if (nodeType == null) {
                        TypedElement te = null;
                        java.lang.reflect.Type ge = null;
                        if (rmethod != null) {
                            ge = rmethod.getGenericReturnType();
                            te = rmethod.getAnnotation(TypedElement.class);
                        }
                        nodeType = te != null ? new Type(retClass, ge, te) : new Type(retClass, ge);
                    }
                }
                Class<?> nodeClass = nodeType.getNaturalClass();
                Type genericType = Generics.findType(nodeType, type);
                if (genericType != null) {
                    nodeClass = nodeType.getObjectClass();
                    node.setType(Type.OBJECT_TYPE);
                }
                this.checkAccess(nodeClass, node.getLookupName());
                if (genericType == null) {
                    node.setType(nodeType);
                } else {
                    node.forceConversion(genericType, true);
                }
                if (nodeClass == Character.TYPE) {
                    node.convertTo(Type.NON_NULL_STRING_TYPE);
                } else if (nodeClass == Character.class) {
                    node.convertTo(Type.STRING_TYPE);
                }
                node.setReadMethod(rmethod);
            }
            return null;
        }

        @Override
        public Object visit(ArrayLookup node) {
            Expression expr = node.getExpression();
            Expression lookupIndex = node.getLookupIndex();
            this.check(expr);
            this.check(lookupIndex);
            Type type = expr.getType();
            Type lookupType = lookupIndex.getType();
            if (type != null && lookupType != null) {
                Method[] methods;
                Type elementType;
                type = type.toNonPrimitive();
                expr.convertTo(type);
                try {
                    elementType = type.getArrayElementType();
                }
                catch (IntrospectionException e) {
                    TypeChecker.this.error(e.toString(), node);
                    return null;
                }
                if (elementType == null) {
                    TypeChecker.this.error("arraylookup.unsupported", type.getSimpleName(), node.getLookupToken());
                    return null;
                }
                this.checkAccess(elementType.getObjectClass(), node);
                try {
                    methods = type.getArrayAccessMethods();
                }
                catch (IntrospectionException e) {
                    TypeChecker.this.error(e.toString(), node);
                    return null;
                }
                boolean good = false;
                if (methods.length == 0) {
                    Class<?> lookupClass;
                    if (type.getObjectClass().isArray() && Number.class.isAssignableFrom(lookupClass = lookupType.getObjectClass())) {
                        lookupIndex.convertTo(Type.INT_TYPE);
                        node.setType(elementType);
                        good = true;
                    }
                } else {
                    int count = MethodMatcher.match(methods, null, lookupType);
                    if (count >= 1) {
                        Method m = methods[0];
                        lookupType = new Type(m.getParameterTypes()[0], m.getGenericParameterTypes()[0]);
                        Type returnType = new Type(m.getReturnType(), m.getGenericReturnType());
                        Type genericType = Generics.findType(returnType, type);
                        node.setType(returnType);
                        if (genericType != null) {
                            node.forceConversion(genericType, true);
                        } else {
                            node.convertTo(elementType);
                        }
                        node.setReadMethod(m);
                        lookupIndex.convertTo(lookupType);
                        node.setReadMethod(m);
                        node.setType(new Type(m.getReturnType()));
                        node.convertTo(elementType);
                        good = true;
                    }
                }
                if (good) {
                    if (elementType.getObjectClass() == Character.class) {
                        node.convertTo(Type.STRING_TYPE);
                    }
                } else {
                    TypeChecker.this.error("arraylookup.unsupported.for", type.getSimpleName(), lookupType.getSimpleName(), lookupIndex);
                }
            }
            return null;
        }

        @Override
        public Object visit(NegateExpression node) {
            Expression expr = node.getExpression();
            this.check(expr);
            Type type = expr.getType();
            if (type == null) {
                node.setType(Type.INT_TYPE);
            } else if (Number.class.isAssignableFrom(type.getObjectClass())) {
                type = type.toPrimitive();
                expr.convertTo(type);
                node.setType(type);
            } else {
                TypeChecker.this.error("negateexpression.type", node);
            }
            return null;
        }

        @Override
        public Object visit(NotExpression node) {
            Expression expr = node.getExpression();
            this.check(expr);
            Type type = expr.getType();
            if (type == null) {
                node.setType(Type.BOOLEAN_TYPE);
            } else if (type.getObjectClass() == Boolean.class) {
                type = type.toPrimitive();
                expr.convertTo(type);
                node.setType(type);
            } else {
                TypeChecker.this.error("notexpression.type", node);
            }
            return null;
        }

        @Override
        public Object visit(ConcatenateExpression node) {
            Expression left = node.getLeftExpression();
            Expression right = node.getRightExpression();
            this.check(left);
            this.check(right);
            left.convertTo(Type.NON_NULL_STRING_TYPE, false);
            right.convertTo(Type.NON_NULL_STRING_TYPE, false);
            node.setType(Type.NON_NULL_STRING_TYPE);
            return null;
        }

        @Override
        public Object visit(ArithmeticExpression node) {
            Expression left = node.getLeftExpression();
            Expression right = node.getRightExpression();
            this.check(left);
            this.check(right);
            Type leftType = left.getType();
            Type rightType = right.getType();
            if (this.binaryTypeCheck(node, Number.class)) {
                Type type = leftType.getCompatibleType(rightType).toPrimitive();
                left.convertTo(type);
                right.convertTo(type);
                node.setType(type);
            }
            return null;
        }

        private boolean binaryTypeCheck(BinaryExpression expr, Class<?> clazz) {
            Expression left = expr.getLeftExpression();
            Expression right = expr.getRightExpression();
            Type leftType = left.getType();
            Type rightType = right.getType();
            if (leftType == null || rightType == null) {
                return false;
            }
            if (!clazz.isAssignableFrom(leftType.getObjectClass())) {
                if (!clazz.isAssignableFrom(rightType.getObjectClass())) {
                    String name = new Type(clazz).getSimpleName();
                    TypeChecker.this.error("binaryexpression.type.both", expr.getOperator().getImage(), name, expr);
                } else {
                    String name = new Type(clazz).getSimpleName();
                    TypeChecker.this.error("binaryexpression.type.left", expr.getOperator().getImage(), name, left);
                }
            } else if (!clazz.isAssignableFrom(rightType.getObjectClass())) {
                String name = new Type(clazz).getSimpleName();
                TypeChecker.this.error("binaryexpression.type.right", expr.getOperator().getImage(), name, right);
            } else {
                return true;
            }
            return false;
        }

        @Override
        public Object visit(RelationalExpression node) {
            node.setType(Type.BOOLEAN_TYPE);
            Token token = node.getOperator();
            int ID = token.getID();
            if (ID == 49) {
                return this.visitIsa(node);
            }
            Expression left = node.getLeftExpression();
            Expression right = node.getRightExpression();
            this.check(left);
            this.check(right);
            Type leftType = left.getType();
            Type rightType = right.getType();
            if (leftType != null && rightType != null) {
                Class<?> leftClass = leftType.getNaturalClass();
                Class<?> rightClass = rightType.getNaturalClass();
                Type type = ID == 24 || ID == 27 ? (String.class.isAssignableFrom(leftClass) ? leftType.toNullable() : (String.class.isAssignableFrom(rightClass) ? rightType.toNullable() : leftType.getCompatibleType(rightType))) : leftType.getCompatibleType(rightType);
                if (type == null) {
                    type = Type.NULL_TYPE;
                }
                Class<?> clazz = type.getObjectClass();
                if (type.hasPrimitivePeer() && leftType.isNonNull() && rightType.isNonNull() && (leftType.isPrimitive() || leftType.hasPrimitivePeer()) && (rightType.isPrimitive() || rightType.hasPrimitivePeer())) {
                    leftType = rightType = type.toPrimitive();
                } else if (leftType.isNonNull()) {
                    leftType = type.toNonNull();
                    rightType = rightType.isNonNull() ? leftType : type;
                } else {
                    leftType = type;
                    rightType = rightType.isNonNull() ? type.toNonNull() : type;
                }
                if (ID == 24 || ID == 27 || Comparable.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz)) {
                    left.convertTo(leftType, false);
                    right.convertTo(rightType, false);
                } else {
                    TypeChecker.this.error("relationalexpression.type.mismatch", token.getImage(), left.getType().getSimpleName(), right.getType().getSimpleName(), node);
                }
            }
            node.setType(Type.BOOLEAN_TYPE);
            return null;
        }

        private Object visitIsa(RelationalExpression node) {
            Token token = node.getOperator();
            Expression left = node.getLeftExpression();
            TypeName typeName = node.getIsaTypeName();
            this.check(left);
            this.check(typeName);
            if (!(left instanceof VariableRef)) {
                TypeChecker.this.error("relationalexpression.isa.left", token.getImage(), left);
            }
            Type leftType = left.getType();
            Type rightType = typeName.getType();
            if (leftType != null && rightType != null) {
                leftType = leftType.toNonPrimitive();
                left.convertTo(leftType);
                Class<?> leftClass = leftType.getObjectClass();
                Class<?> rightClass = rightType.getObjectClass();
                if (!rightClass.isAssignableFrom(leftClass) && !leftClass.isAssignableFrom(rightClass)) {
                    SourceDetailedInfo info = new SourceDetailedInfo(node.getSourceInfo(), typeName.getSourceInfo().getDetailPosition());
                    TypeChecker.this.error("relationalexpression.isa.impossible", leftType.getSimpleName(), rightType.getSimpleName(), info);
                }
            }
            return null;
        }

        @Override
        public Object visit(AndExpression node) {
            Expression left = node.getLeftExpression();
            Expression right = node.getRightExpression();
            this.check(left);
            this.check(right);
            Type type = Type.BOOLEAN_TYPE;
            if (this.binaryTypeCheck(node, Boolean.class)) {
                left.convertTo(type);
                right.convertTo(type);
            }
            node.setType(type);
            return null;
        }

        @Override
        public Object visit(OrExpression node) {
            Expression left = node.getLeftExpression();
            Expression right = node.getRightExpression();
            this.check(left);
            this.check(right);
            Type type = Type.BOOLEAN_TYPE;
            if (this.binaryTypeCheck(node, Boolean.class)) {
                left.convertTo(type);
                right.convertTo(type);
            }
            node.setType(type);
            return null;
        }

        @Override
        public Object visit(TernaryExpression node) {
            Expression condition = node.getCondition();
            Expression thenPart = node.getThenPart();
            Expression elsePart = node.getElsePart();
            this.check(condition);
            if (condition == thenPart) {
                this.check(elsePart);
            } else {
                this.check(thenPart);
                this.check(elsePart);
            }
            Type type = null;
            Type thenType = thenPart.getType();
            Type elseType = elsePart.getType();
            type = thenType == null ? elseType : (elseType == null ? thenType : thenType.getCompatibleType(elseType));
            node.setType(type);
            if (thenPart != null) {
                thenPart.convertTo(type);
            }
            if (elsePart != null) {
                elsePart.convertTo(type);
            }
            return null;
        }

        @Override
        public Object visit(CompareExpression node) {
            Expression left = node.getLeftExpression();
            Expression right = node.getRightExpression();
            this.check(left);
            this.check(right);
            Type ltype = left.getType();
            Type rtype = right.getType();
            if (ltype != null && rtype != null && ltype.convertableFrom(rtype) == -1) {
                TypeChecker.this.error("compare.not.convertible", node);
                return null;
            }
            Type compatible = null;
            if (ltype != null && rtype != null) {
                compatible = ltype.getCompatibleType(rtype);
                left.convertTo(compatible);
                right.convertTo(compatible);
            }
            node.setType(Type.INT_TYPE);
            return null;
        }

        @Override
        public Object visit(NoOpExpression node) {
            return null;
        }

        @Override
        public Object visit(TypeExpression node) {
            TypeName typeName = node.getTypeName();
            if (typeName != null) {
                this.check(typeName);
                node.setType(typeName.getType());
            }
            return null;
        }

        @Override
        public Object visit(SpreadExpression node) {
            Expression expr = node.getExpression();
            this.check(expr);
            Type elementType = null;
            Type exprType = expr.getType();
            try {
                elementType = exprType.getIterationElementType();
            }
            catch (IntrospectionException exception) {
                throw new IllegalStateException("unable to lookup spread array element type", exception);
            }
            if (elementType == null) {
                TypeChecker.this.error("spread.missing.type", node);
                return null;
            }
            Class<?> exprClass = exprType.getNaturalClass();
            if (!Collection.class.isAssignableFrom(exprClass) && !exprClass.isArray()) {
                TypeChecker.this.error("spread.not.array", node);
                return null;
            }
            Expression operation = node.getOperation();
            if (operation instanceof Lookup) {
                ((Lookup)operation).getExpression().setType(elementType);
            } else if (operation instanceof FunctionCallExpression) {
                ((FunctionCallExpression)operation).getExpression().setType(elementType);
            } else {
                TypeChecker.this.error("spread.operation.unsupported", node);
                return null;
            }
            this.check(operation);
            if (!exprClass.isArray()) {
                operation.convertTo(operation.getType().toNonPrimitive());
            }
            Type operationType = node.getOperation().getType();
            if (Collection.class.isAssignableFrom(exprClass)) {
                Class<ArrayList> listType = ArrayList.class;
                Type type = new Type(listType, new ParameterizedTypeImpl((java.lang.reflect.Type)((Object)listType), new java.lang.reflect.Type[]{operationType.getGenericClass()}));
                try {
                    type = type.setArrayElementType(operationType);
                }
                catch (IntrospectionException exception) {
                    throw new IllegalStateException("unable to set spread array element type", exception);
                }
                node.setType(type);
            } else if (exprClass.isArray()) {
                Type arrayType = new Type(Array.newInstance(operationType.getNaturalClass(), 0).getClass(), new GenericArrayTypeImpl(operationType.getGenericClass()));
                node.setType(arrayType);
            }
            return null;
        }

        @Override
        public Object visit(NullLiteral node) {
            return null;
        }

        @Override
        public Object visit(BooleanLiteral node) {
            return null;
        }

        @Override
        public Object visit(StringLiteral node) {
            return null;
        }

        @Override
        public Object visit(NumberLiteral node) {
            return null;
        }
    }
}

