/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.engine;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.teatrove.tea.engine.ContextCreationException;
import org.teatrove.tea.engine.ContextSource;
import org.teatrove.trove.util.ClassInjector;
import org.teatrove.trove.util.DelegateClassLoader;
import org.teatrove.trove.util.MergedClass;

public class MergedContextSource
implements ContextSource {
    private ClassInjector mInjector;
    private ContextSource[] mSources;
    private Class<?>[] mContextsInOrder;
    private boolean mProfilingEnabled = false;
    private Constructor<?> mConstr;

    public void init(ClassLoader loader, ContextSource[] contextSources, boolean profilingEnabled) throws Exception {
        this.init(loader, contextSources, null, profilingEnabled);
    }

    public void init(ClassLoader loader, ContextSource[] contextSources, String[] prefixes, boolean profilingEnabled) throws Exception {
        this.mSources = contextSources;
        int len = contextSources.length;
        ArrayList contextList = new ArrayList(len);
        ArrayList<ClassLoader> delegateList = new ArrayList<ClassLoader>(len);
        for (int j = 0; j < contextSources.length; ++j) {
            Class<?> type = contextSources[j].getContextType();
            if (type == null) continue;
            contextList.add(type);
            ClassLoader scout = type.getClassLoader();
            if (scout == null || delegateList.contains(scout)) continue;
            delegateList.add(scout);
        }
        this.mContextsInOrder = contextList.toArray(new Class[contextList.size()]);
        ClassLoader[] delegateLoaders = delegateList.toArray(new ClassLoader[delegateList.size()]);
        this.mInjector = new ClassInjector((ClassLoader)new DelegateClassLoader(loader, delegateLoaders));
        this.mProfilingEnabled = profilingEnabled;
        int observerMode = profilingEnabled ? 5 : 1;
        this.mConstr = MergedClass.getConstructor2((ClassInjector)this.mInjector, (Class[])this.mContextsInOrder, (String[])prefixes, (int)observerMode);
    }

    protected Class<?>[] getContextsInOrder() {
        return this.mContextsInOrder;
    }

    protected Constructor<?> getConstructor() {
        return this.mConstr;
    }

    protected boolean isProfilingEnabled() {
        return this.mProfilingEnabled;
    }

    @Override
    public Class<?> getContextType() {
        return this.mConstr.getDeclaringClass();
    }

    @Override
    public Object createContext(Object param) throws Exception {
        Class[] params;
        Class[] classArray = params = this.mConstr != null ? this.mConstr.getParameterTypes() : new Class[]{};
        if (params.length > 1 && MergedClass.InvocationEventObserver.class.equals((Object)params[1])) {
            return this.mConstr.newInstance(new MergingContextFactory(param), new MergedClass.InvocationEventObserver(){

                public void invokedEvent(String caller, String callee, long elapsedTime) {
                }

                public long currentTime() {
                    return 0L;
                }
            });
        }
        return this.mConstr.newInstance(new MergingContextFactory(param));
    }

    private class MergingContextFactory
    implements MergedClass.InstanceFactory {
        private final Object mContextParameter;

        MergingContextFactory(Object contextParam) {
            this.mContextParameter = contextParam;
        }

        public Object getInstance(int i) {
            try {
                return MergedContextSource.this.mSources[i].createContext(this.mContextParameter);
            }
            catch (Exception e) {
                throw new ContextCreationException(e);
            }
        }
    }
}

