/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.engine;

import java.lang.reflect.Constructor;
import org.teatrove.tea.runtime.Context;
import org.teatrove.tea.runtime.TemplateLoader;
import org.teatrove.trove.util.ClassInjector;
import org.teatrove.trove.util.MergedClass;

class TemplateAdapter
extends TemplateLoader {
    private final Class<?> mContextClass;
    private final ClassInjector mInjector;

    public TemplateAdapter(Class<?> contextClass, ClassInjector injector, String packagePrefix) {
        super((ClassLoader)injector, packagePrefix);
        this.mContextClass = contextClass;
        this.mInjector = injector;
    }

    @Override
    protected TemplateLoader.Template loadTemplate(String name) throws ClassNotFoundException, NoSuchMethodException, LinkageError {
        Class<?> templateContext;
        TemplateLoader.Template t = super.loadTemplate(name);
        if (t != null && !(templateContext = t.getContextType()).isAssignableFrom(this.mContextClass)) {
            if (!templateContext.isInterface()) {
                throw new NoSuchMethodException("Cannot adapt to context " + templateContext + " because it is not an interface.");
            }
            Constructor ctor = MergedClass.getConstructor((ClassInjector)this.mInjector, (Class[])new Class[]{this.mContextClass, templateContext});
            return new AdaptedTemplate(t, ctor);
        }
        return t;
    }

    private class AdaptedTemplate
    implements TemplateLoader.Template {
        private final TemplateLoader.Template mTemplate;
        private final Constructor<?> mContextConstructor;

        public AdaptedTemplate(TemplateLoader.Template t, Constructor<?> ctor) {
            this.mTemplate = t;
            this.mContextConstructor = ctor;
        }

        @Override
        public TemplateLoader getTemplateLoader() {
            return TemplateAdapter.this;
        }

        @Override
        public String getName() {
            return this.mTemplate.getName();
        }

        @Override
        public Class<?> getTemplateClass() {
            return this.mTemplate.getTemplateClass();
        }

        @Override
        public Class<?> getContextType() {
            return this.mContextConstructor.getDeclaringClass();
        }

        @Override
        public String[] getParameterNames() {
            return this.mTemplate.getParameterNames();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.mTemplate.getParameterTypes();
        }

        @Override
        public void execute(Context context, Object[] parameters) throws Exception {
            context = (Context)this.mContextConstructor.newInstance(context, null);
            this.mTemplate.execute(context, parameters);
        }

        @Override
        public String toString() {
            return ((Object)this.mTemplate).toString();
        }
    }
}

