/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teatrove.tea.engine.TemplateError;

public class TemplateCompilationResults
implements Serializable {
    private static final long serialVersionUID = 1L;
    boolean mReloadInProgress;
    Set<String> mReloaded;
    Map<String, List<TemplateError>> mErrors;

    public TemplateCompilationResults(Set<String> reloaded, Map<String, List<TemplateError>> errors) {
        this.mErrors = errors;
        this.mReloaded = reloaded;
    }

    public TemplateCompilationResults() {
        this.mReloadInProgress = true;
    }

    public boolean appendName(String name) {
        if (name == null) {
            return false;
        }
        return this.mReloaded.add(name);
    }

    public boolean appendNames(Collection<String> names) {
        if (names == null) {
            return false;
        }
        return this.mReloaded.addAll(names);
    }

    public boolean appendErrors(Map<String, List<TemplateError>> errors) {
        if (errors == null || errors.isEmpty()) {
            return false;
        }
        if (this.mErrors == null) {
            this.mErrors = new Hashtable<String, List<TemplateError>>();
        }
        for (String name : errors.keySet()) {
            List<TemplateError> templateErrors = this.mErrors.get(name);
            if (templateErrors == null) {
                templateErrors = new ArrayList<TemplateError>();
                this.mErrors.put(name, templateErrors);
            }
            List<TemplateError> newErrors = errors.get(name);
            templateErrors.addAll(newErrors);
        }
        return true;
    }

    public boolean appendError(String templateName, TemplateError error) {
        if (templateName == null || error == null) {
            return false;
        }
        List<TemplateError> templateErrors = this.mErrors.get(templateName);
        if (templateErrors == null) {
            templateErrors = new ArrayList<TemplateError>();
            this.mErrors.put(templateName, templateErrors);
        }
        return templateErrors.add(error);
    }

    public boolean appendErrors(String templateName, List<TemplateError> errors) {
        if (templateName == null || errors == null || errors.isEmpty()) {
            return false;
        }
        List<TemplateError> templateErrors = this.mErrors.get(templateName);
        if (templateErrors == null) {
            templateErrors = new ArrayList<TemplateError>();
            this.mErrors.put(templateName, templateErrors);
        }
        return templateErrors.addAll(errors);
    }

    public Set<String> getReloadedTemplateNames() {
        return this.mReloaded;
    }

    public Map<String, List<TemplateError>> getTemplateErrors() {
        return this.mErrors;
    }

    public List<TemplateError> getAllTemplateErrors() {
        if (this.mErrors == null || this.mErrors.isEmpty()) {
            return null;
        }
        ArrayList<TemplateError> errors = new ArrayList<TemplateError>();
        Iterator<List<TemplateError>> values = this.mErrors.values().iterator();
        while (values.hasNext()) {
            errors.addAll((Collection<TemplateError>)values.next());
        }
        return errors;
    }

    public boolean isSuccessful() {
        return this.mErrors == null || this.mErrors.size() == 0;
    }

    public void setAlreadyReloading(boolean inProgress) {
        this.mReloadInProgress = inProgress;
    }

    public boolean isAlreadyReloading() {
        return this.mReloadInProgress;
    }
}

