/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.engine;

import java.io.Serializable;
import java.util.Date;

public class TemplateError
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String mSourcePath;
    private Date mLastModifiedDate;
    private String mErrorMessage;
    private String mDetailedErrorMessage;
    private String mSourceInfoMessage;
    private String mSourceLine;
    private int mLineNumber;
    private String mUnderline;
    private int mErrorStartPos;
    private int mErrorEndPos;
    private int mDetailPos;
    private int mErrorFileStartPos;
    private int mErrorFileEndPos;

    public TemplateError() {
        this.mSourcePath = null;
        this.mLastModifiedDate = null;
        this.mErrorMessage = "";
        this.mDetailedErrorMessage = "";
        this.mSourceInfoMessage = "";
        this.mSourceLine = "";
        this.mUnderline = "";
        this.mLineNumber = 0;
        this.mErrorFileStartPos = 0;
        this.mErrorFileEndPos = 0;
        this.mErrorStartPos = 0;
        this.mErrorEndPos = 0;
        this.mDetailPos = 0;
    }

    public TemplateError(String sourcePath, Date lastModifiedDate, String errorMessage, String detailedErrorMessage, String sourceInfoMessage, String sourceLine, String underline, int lineNumber, int errorFileStartPos, int errorFileEndPos, int errorStartPos, int errorEndPos, int detailPos) {
        this.mSourcePath = sourcePath;
        this.mLastModifiedDate = lastModifiedDate;
        this.mErrorMessage = errorMessage;
        this.mDetailedErrorMessage = detailedErrorMessage;
        this.mSourceInfoMessage = sourceInfoMessage;
        this.mSourceLine = sourceLine;
        this.mUnderline = underline;
        this.mLineNumber = lineNumber;
        this.mErrorFileStartPos = errorFileStartPos;
        this.mErrorFileEndPos = errorFileEndPos;
        int length = sourceLine.length();
        this.mErrorStartPos = errorStartPos;
        if (this.mErrorStartPos > length) {
            this.mErrorStartPos = length - 1;
        }
        if ((this.mErrorEndPos = errorEndPos) > length) {
            this.mErrorEndPos = length - 1;
        }
        if ((this.mDetailPos = detailPos) > length) {
            this.mDetailPos = length - 1;
        }
    }

    public TemplateError(String message) {
        this.mSourcePath = null;
        this.mLastModifiedDate = null;
        this.mErrorMessage = message;
        this.mDetailedErrorMessage = message;
        this.mSourceInfoMessage = "custom error: no source involved";
        this.mSourceLine = "";
        this.mUnderline = "";
        this.mLineNumber = 0;
        this.mErrorFileStartPos = 0;
        this.mErrorFileEndPos = 0;
        this.mErrorStartPos = 0;
        this.mErrorEndPos = 0;
        this.mDetailPos = 0;
    }

    public String getSourcePath() {
        return this.mSourcePath;
    }

    public Date getLastModifiedDate() {
        return this.mLastModifiedDate;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public String getDetailedErrorMessage() {
        return this.mDetailedErrorMessage;
    }

    public String getSourceInfoMessage() {
        return this.mSourceInfoMessage;
    }

    public String getSourceLine() {
        return this.mSourceLine;
    }

    public String getUnderline() {
        return this.mUnderline;
    }

    public int getLineNumber() {
        return this.mLineNumber;
    }

    public int getErrorStartPos() {
        return this.mErrorStartPos;
    }

    public int getErrorEndPos() {
        return this.mErrorEndPos;
    }

    public int getErrorFileStartPos() {
        return this.mErrorFileStartPos;
    }

    public int getErrorFileEndPos() {
        return this.mErrorFileEndPos;
    }

    public String getLineStart() {
        try {
            return this.mSourceLine.substring(0, this.mErrorStartPos);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public String getErrorStart() {
        try {
            return this.mSourceLine.substring(this.mErrorStartPos, this.mDetailPos);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public String getDetail() {
        try {
            return this.mSourceLine.substring(this.mDetailPos, this.mDetailPos + 1);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public String getErrorEnd() {
        try {
            return this.mSourceLine.substring(this.mDetailPos + 1, this.mErrorEndPos + 1);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public String getLineEnd() {
        try {
            return this.mSourceLine.substring(this.mErrorEndPos + 1, this.mSourceLine.length());
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }
}

