/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.teatrove.tea.compiler.CompilationUnit;
import org.teatrove.tea.compiler.Compiler;
import org.teatrove.tea.compiler.ErrorEvent;
import org.teatrove.tea.compiler.ErrorListener;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.StatusEvent;
import org.teatrove.tea.compiler.StatusListener;
import org.teatrove.tea.compiler.TemplateRepository;
import org.teatrove.tea.engine.ContextSource;
import org.teatrove.tea.engine.ReloadLock;
import org.teatrove.tea.engine.Template;
import org.teatrove.tea.engine.TemplateAdapter;
import org.teatrove.tea.engine.TemplateCompilationResults;
import org.teatrove.tea.engine.TemplateError;
import org.teatrove.tea.engine.TemplateErrorListener;
import org.teatrove.tea.engine.TemplateSource;
import org.teatrove.tea.engine.TemplateSourceConfig;
import org.teatrove.tea.runtime.Context;
import org.teatrove.tea.runtime.TemplateLoader;
import org.teatrove.tea.util.FileCompiler;
import org.teatrove.tea.util.ResourceCompiler;
import org.teatrove.tea.util.StringCompiler;
import org.teatrove.trove.io.LinePositionReader;
import org.teatrove.trove.log.Log;
import org.teatrove.trove.util.ClassInjector;
import org.teatrove.trove.util.PropertyMap;

public class TemplateSourceImpl
implements TemplateSource {
    protected TemplateSourceConfig mConfig;
    protected Log mLog;
    protected PropertyMap mProperties;
    protected File mCompiledDir;
    private File[] mTemplateRootDirs;
    private String[] mTemplateResources;
    private String[] mTemplateStrings;
    private ReloadLock mReloading = new ReloadLock();
    private String[] mImports;
    protected Results mResults;
    protected Map<String, TemplateSourceFileInfo> mTemplateSourceFileInfo;
    protected boolean mLogCompileStatus = true;

    public static File createTemplateClassesDir(File tmpDir, String dirPath, Log log) {
        File destDir = null;
        if (dirPath != null && !dirPath.isEmpty()) {
            if (dirPath.startsWith("file:")) {
                destDir = new File(dirPath.substring(5));
            } else {
                destDir = new File(tmpDir, dirPath);
                try {
                    if (!destDir.getCanonicalPath().startsWith(tmpDir.getCanonicalPath().concat(File.separator))) {
                        throw new IllegalStateException("invalid template classes directory: " + dirPath);
                    }
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("invalid template classes directory: " + dirPath, ioe);
                }
            }
            if (!destDir.isDirectory() && !destDir.mkdir()) {
                log.warn("Could not create template classes directory: " + destDir.getAbsolutePath());
                destDir = null;
            }
            if (destDir != null && !destDir.canWrite()) {
                log.warn("Unable to write to template classes directory: " + destDir.getAbsolutePath());
                destDir = null;
            }
        }
        return destDir;
    }

    public static String[] chopString(String target, String delimiters) {
        if (target != null && target.length() != 0) {
            StringTokenizer st = new StringTokenizer(target, delimiters);
            String[] chopped = new String[st.countTokens()];
            int j = 0;
            while (st.hasMoreTokens()) {
                chopped[j] = st.nextToken().trim();
                ++j;
            }
            return chopped;
        }
        return null;
    }

    @Override
    public void init(TemplateSourceConfig config) {
        this.mConfig = config;
        this.mLog = config.getLog();
        this.mProperties = config.getProperties();
        this.mLog.info("initializing template source");
        this.mImports = this.parseImports(this.mProperties);
        this.mTemplateRootDirs = this.parseRootDirs(this.mProperties);
        this.mTemplateResources = TemplateSourceImpl.chopString(this.mProperties.getString("resource"), ";,");
        this.mCompiledDir = TemplateSourceImpl.createTemplateClassesDir(new File("."), this.mProperties.getString("classes"), this.mLog);
    }

    public String[] getImports() {
        return this.mImports;
    }

    public void setImports(String[] imports) {
        this.mImports = imports;
    }

    @Override
    public TemplateCompilationResults compileTemplates(ClassInjector injector, boolean all) throws Exception {
        return this.compileTemplates(injector, all, true, null);
    }

    @Override
    public TemplateCompilationResults compileTemplates(ClassInjector injector, boolean all, StatusListener listener) throws Exception {
        return this.compileTemplates(injector, all, true, listener);
    }

    @Override
    public TemplateCompilationResults compileTemplates(ClassInjector injector, boolean all, boolean recurse) throws Exception {
        return this.compileTemplates(injector, all, recurse, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemplateCompilationResults compileTemplates(ClassInjector injector, boolean all, boolean recurse, StatusListener listener) throws Exception {
        Object object = this.mReloading;
        synchronized (object) {
            if (this.mReloading.isReloading()) {
                return new TemplateCompilationResults();
            }
            this.mReloading.setReloading(true);
        }
        try {
            this.mResults = this.actuallyCompileTemplates(injector, all, recurse, listener);
            object = this.mResults.getTransientResults();
            return object;
        }
        finally {
            ReloadLock reloadLock = this.mReloading;
            synchronized (reloadLock) {
                this.mReloading.setReloading(false);
            }
        }
    }

    @Override
    public TemplateCompilationResults compileTemplates(ClassInjector injector, String[] selectedTemplates) throws Exception {
        return this.compileTemplates(injector, null, selectedTemplates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemplateCompilationResults compileTemplates(ClassInjector injector, StatusListener listener, String[] selectedTemplates) throws Exception {
        Object object = this.mReloading;
        synchronized (object) {
            if (this.mReloading.isReloading()) {
                return new TemplateCompilationResults();
            }
            this.mReloading.setReloading(true);
        }
        try {
            this.mResults = this.actuallyCompileTemplates(injector, listener, selectedTemplates);
            object = this.mResults.getTransientResults();
            return object;
        }
        finally {
            ReloadLock reloadLock = this.mReloading;
            synchronized (reloadLock) {
                this.mReloading.setReloading(false);
            }
        }
    }

    public TemplateCompilationResults checkTemplates(ClassInjector injector, boolean all, String[] selectedTemplates) throws Exception {
        TemplateCompilationResults results = new TemplateCompilationResults(new TreeSet<String>(), new TreeMap<String, List<TemplateError>>());
        if (null != this.mTemplateRootDirs && this.mTemplateRootDirs.length > 0) {
            String[] templates;
            if (injector == null) {
                injector = this.createClassInjector();
            }
            TemplateErrorListener errorListener = this.createErrorListener();
            String prefix = this.mConfig.getPackagePrefix();
            FileCompiler compiler = new FileCompiler(this.mTemplateRootDirs, prefix, this.mCompiledDir, injector);
            compiler.addImportedPackages(this.getImports());
            compiler.setClassLoader((ClassLoader)injector);
            compiler.setRuntimeContext(this.getContextSource().getContextType());
            compiler.setCodeGenerationEnabled(false);
            compiler.addErrorListener(errorListener);
            compiler.setForceCompile(all);
            if (selectedTemplates == null || selectedTemplates.length == 0) {
                templates = compiler.getAllTemplateNames();
            } else {
                templates = selectedTemplates;
                compiler.setForceCompile(true);
            }
            ArrayList<TemplateRepository.TemplateInfo> callerList = new ArrayList<TemplateRepository.TemplateInfo>();
            for (int i = 0; i < templates.length; ++i) {
                CompilationUnit unit = compiler.getCompilationUnit(templates[i], null);
                if (unit == null) {
                    this.mLog.warn("selected template not found: " + templates[i]);
                    continue;
                }
                if (!unit.shouldCompile() || results.getReloadedTemplateNames().contains(templates[i])) continue;
                compiler.getParseTree(unit);
                results.appendName(templates[i]);
                callerList.addAll(Arrays.asList(TemplateRepository.getInstance().getCallers(unit.getName())));
            }
            compiler.setForceCompile(true);
            for (TemplateRepository.TemplateInfo tInfo : callerList) {
                CompilationUnit callingUnit;
                String caller = tInfo.getShortName().replace('/', '.');
                if (results.getReloadedTemplateNames().contains(caller) || (callingUnit = compiler.getCompilationUnit(caller, null)) == null) continue;
                compiler.getParseTree(callingUnit);
            }
            results.appendErrors(errorListener.getTemplateErrors());
            errorListener.close();
        }
        return results;
    }

    @Override
    public ContextSource getContextSource() {
        return this.mConfig.getContextSource();
    }

    @Override
    public int getKnownTemplateCount() {
        Set<String> names;
        if (this.mResults == null || (names = this.mResults.getKnownTemplateNames()) == null) {
            return 0;
        }
        return names.size();
    }

    @Override
    public String[] getKnownTemplateNames() {
        Set<String> names;
        if (this.mResults == null || (names = this.mResults.getKnownTemplateNames()) == null) {
            return new String[0];
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public Date getTimeOfLastReload() {
        if (this.mResults == null) {
            return null;
        }
        return this.mResults.getLastReloadTime();
    }

    @Override
    public boolean isExceptionGuardianEnabled() {
        return this.mConfig.isExceptionGuardianEnabled();
    }

    @Override
    public TemplateLoader getTemplateLoader() {
        if (this.mResults != null) {
            return this.mResults.getLoader();
        }
        return null;
    }

    @Override
    public Template[] getLoadedTemplates() {
        Map<String, Template> templates;
        if (this.mResults != null && (templates = this.mResults.getWrappedTemplates()) != null) {
            return templates.values().toArray(new Template[templates.size()]);
        }
        return new Template[0];
    }

    @Override
    public Template getTemplate(String name) throws ClassNotFoundException, NoSuchMethodException {
        Template wrapped = null;
        try {
            Map<String, Template> wrappedTemplates = this.mResults.getWrappedTemplates();
            wrapped = wrappedTemplates.get(name);
            if (wrapped == null) {
                TemplateSourceFileInfo sourceFileInfo = null;
                File sourceFile = null;
                long lastModifiedTime = 0L;
                if (this.mTemplateSourceFileInfo != null) {
                    sourceFileInfo = this.mTemplateSourceFileInfo.get(name);
                }
                if (sourceFileInfo != null) {
                    sourceFile = sourceFileInfo.getSourceFile();
                    lastModifiedTime = sourceFileInfo.getLastModifiedTime();
                }
                wrapped = new TemplateImpl(this.getTemplateLoader().getTemplate(name), this, sourceFile, lastModifiedTime);
            }
            wrappedTemplates.put(name, wrapped);
        }
        catch (NullPointerException npe) {
            this.mLog.debug((Throwable)npe);
            throw new ClassNotFoundException("TemplateLoader not yet available");
        }
        return wrapped;
    }

    protected Results actuallyCompileTemplates(ClassInjector injector, boolean all) throws Exception {
        return this.actuallyCompileTemplates(injector, all, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Results actuallyCompileTemplates(ClassInjector injector, boolean all, StatusListener listener) throws Exception {
        TemplateErrorListener errorListener = this.createErrorListener();
        try {
            Results results = this.actuallyCompileTemplates(injector, all, true, errorListener, listener);
            return results;
        }
        finally {
            errorListener.close();
        }
    }

    protected Results actuallyCompileTemplates(ClassInjector injector, boolean all, boolean recurse) throws Exception {
        return this.actuallyCompileTemplates(injector, all, recurse, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Results actuallyCompileTemplates(ClassInjector injector, boolean all, boolean recurse, StatusListener listener) throws Exception {
        TemplateErrorListener errorListener = this.createErrorListener();
        try {
            Results results = this.actuallyCompileTemplates(injector, all, recurse, errorListener, listener, null);
            return results;
        }
        finally {
            errorListener.close();
        }
    }

    protected Results actuallyCompileTemplates(ClassInjector injector, boolean all, boolean recurse, TemplateErrorListener errorListener, StatusListener listener) throws Exception {
        return this.actuallyCompileTemplates(injector, all, recurse, errorListener, listener, null);
    }

    protected Results actuallyCompileTemplates(ClassInjector injector, String[] selectedTemplates) throws Exception {
        return this.actuallyCompileTemplates(injector, null, selectedTemplates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Results actuallyCompileTemplates(ClassInjector injector, StatusListener listener, String[] selectedTemplates) throws Exception {
        TemplateErrorListener errorListener = this.createErrorListener();
        try {
            Results results = this.actuallyCompileTemplates(injector, false, false, errorListener, listener, selectedTemplates);
            return results;
        }
        finally {
            errorListener.close();
        }
    }

    private Results actuallyCompileTemplates(ClassInjector injector, boolean all, boolean recurse, TemplateErrorListener errorListener, StatusListener listener, String[] selectedTemplates) throws Exception {
        List<String> names;
        TreeSet<String> reloadedTemplateNames = new TreeSet<String>();
        if (injector == null) {
            injector = this.createClassInjector();
        }
        TreeSet<String> knownTemplateNames = new TreeSet<String>();
        Date lastReloadTime = new Date();
        Class<?> type = this.mConfig.getContextSource().getContextType();
        boolean exceptionGuardian = this.mConfig.isExceptionGuardianEnabled();
        String prefix = this.mConfig.getPackagePrefix();
        if (this.mTemplateRootDirs != null && this.mTemplateRootDirs.length > 0) {
            FileCompiler fcomp = new FileCompiler(this.mTemplateRootDirs, prefix, this.mCompiledDir, injector);
            fcomp.addImportedPackages(this.getImports());
            fcomp.setClassLoader((ClassLoader)injector);
            fcomp.setRuntimeContext(type);
            fcomp.setExceptionGuardianEnabled(exceptionGuardian);
            fcomp.addErrorListener(errorListener);
            if (listener != null) {
                fcomp.addStatusListener(listener);
            }
            if (this.mLogCompileStatus) {
                fcomp.addStatusListener(new CompilerStatusLogger(Arrays.toString(this.mTemplateRootDirs)));
            }
            knownTemplateNames.addAll(Arrays.asList(fcomp.getAllTemplateNames()));
            if (null == selectedTemplates || selectedTemplates.length == 0) {
                fcomp.setForceCompile(all);
                reloadedTemplateNames.addAll(Arrays.asList(fcomp.compileAll(recurse)));
            } else {
                reloadedTemplateNames.addAll(Arrays.asList(fcomp.compile(selectedTemplates)));
            }
            this.mTemplateSourceFileInfo = this.createTemplateSourceFileInfo(knownTemplateNames);
        }
        if (this.mTemplateStrings != null && this.mTemplateStrings.length > 0) {
            names = Arrays.asList(this.compileFromStrings(type, injector, errorListener, prefix, this.mTemplateStrings, exceptionGuardian));
            reloadedTemplateNames.addAll(names);
            knownTemplateNames.addAll(names);
        }
        if (this.mTemplateResources != null && this.mTemplateResources.length > 0) {
            names = Arrays.asList(this.compileFromResourcePaths(type, injector, errorListener, prefix, this.mTemplateResources, exceptionGuardian));
            reloadedTemplateNames.addAll(names);
            knownTemplateNames.addAll(names);
        }
        return new Results(new TemplateCompilationResults(reloadedTemplateNames, errorListener.getTemplateErrors()), new TemplateAdapter(type, injector, this.mConfig.getPackagePrefix()), lastReloadTime, knownTemplateNames, new HashMap<String, Template>());
    }

    protected Set<String> getKnownTemplateNameSet() {
        return this.mResults.getKnownTemplateNames();
    }

    protected void setTemplateStrings(String[] sourceData) {
        this.mTemplateStrings = sourceData;
    }

    protected void setTemplateResources(String[] resourcePaths) {
        this.mTemplateResources = resourcePaths;
    }

    protected void setTemplateRootDirs(File[] rootDirs) {
        this.mTemplateRootDirs = rootDirs;
    }

    protected File[] getTemplateRootDirs() {
        return this.mTemplateRootDirs;
    }

    protected void setDestinationDirectory(File compiledDir) {
        this.mCompiledDir = compiledDir;
    }

    protected ClassInjector createClassInjector() throws Exception {
        return new ResolvingInjector(this.mConfig.getContextSource().getContextType().getClassLoader(), new File[]{this.mCompiledDir}, this.mConfig.getPackagePrefix(), false);
    }

    protected TemplateErrorListener createErrorListener() {
        return new ErrorRetriever();
    }

    private String[] parseImports(PropertyMap properties) {
        return TemplateSourceImpl.chopString(properties.getString("imports", ""), ";,");
    }

    private File[] parseRootDirs(PropertyMap properties) {
        String[] roots = TemplateSourceImpl.chopString(properties.getString("path"), ";,");
        File[] rootDirs = null;
        if (roots != null) {
            rootDirs = new File[roots.length];
            for (int j = 0; j < roots.length; ++j) {
                rootDirs[j] = new File(roots[j]);
            }
        }
        return rootDirs;
    }

    private File findSourceFile(String name) {
        String filename = name.replace('.', File.separatorChar) + ".tea";
        for (int i = 0; i < this.mTemplateRootDirs.length; ++i) {
            File file = new File(this.mTemplateRootDirs[i], filename);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private Map<String, TemplateSourceFileInfo> createTemplateSourceFileInfo(Set<String> templateNames) {
        if (templateNames.isEmpty()) {
            return null;
        }
        HashMap<String, TemplateSourceFileInfo> sourceFileInfo = new HashMap<String, TemplateSourceFileInfo>();
        for (String name : templateNames) {
            File sourceFile = this.findSourceFile(name);
            if (sourceFile == null) continue;
            long lastModifiedTime = sourceFile.lastModified();
            sourceFileInfo.put(name, new TemplateSourceFileInfo(name, sourceFile, lastModifiedTime));
        }
        return sourceFileInfo;
    }

    private String[] compileFromResourcePaths(Class<?> contextType, ClassInjector injector, ErrorListener errorListener, String packagePrefix, String[] resourcePaths, boolean guardian) throws Exception {
        ResourceCompiler rcomp = new ResourceCompiler(injector, packagePrefix);
        rcomp.addImportedPackages(this.getImports());
        rcomp.setClassLoader((ClassLoader)injector);
        rcomp.setRuntimeContext(contextType);
        rcomp.setExceptionGuardianEnabled(guardian);
        rcomp.addErrorListener(errorListener);
        if (this.mLogCompileStatus) {
            rcomp.addStatusListener(new CompilerStatusLogger(Arrays.toString(resourcePaths)));
        }
        String[] result = rcomp.compile(this.mTemplateResources);
        this.mLog.info(rcomp.getErrorCount() + " Resource compilation errors.");
        this.mLog.info(Integer.toString(result.length));
        for (int j = 0; j < result.length; ++j) {
            this.mLog.info(result[j]);
        }
        return result;
    }

    private String[] compileFromStrings(Class<?> contextType, ClassInjector injector, ErrorListener errorListener, String packagePrefix, String[] templateSourceStrings, boolean guardian) throws Exception {
        StringCompiler scomp = new StringCompiler(injector, packagePrefix);
        scomp.addImportedPackages(this.getImports());
        scomp.setClassLoader((ClassLoader)injector);
        scomp.setRuntimeContext(contextType);
        scomp.setExceptionGuardianEnabled(guardian);
        scomp.addErrorListener(errorListener);
        if (this.mLogCompileStatus) {
            scomp.addStatusListener(new CompilerStatusLogger("String sources"));
        }
        String[] templateNames = new String[this.mTemplateStrings.length];
        for (int j = 0; j < templateNames.length; ++j) {
            int index = this.mTemplateStrings[j].indexOf("template ") + "template ".length();
            templateNames[j] = this.mTemplateStrings[j].substring(index, this.mTemplateStrings[j].indexOf(40, index));
            scomp.setTemplateSource(templateNames[j], this.mTemplateStrings[j]);
        }
        String[] result = scomp.compile(templateNames);
        this.mLog.info(scomp.getErrorCount() + " String compilation errors.");
        this.mLog.info(Integer.toString(result.length));
        for (int j = 0; j < result.length; ++j) {
            this.mLog.info(result[j]);
        }
        return result;
    }

    @Override
    public Map<String, Boolean> listTouchedTemplates() throws Exception {
        HashMap<String, Boolean> touchedTemplateMap = new HashMap<String, Boolean>();
        if (this.mTemplateRootDirs != null && this.mTemplateRootDirs.length > 0) {
            ClassInjector injector = this.createClassInjector();
            Class<?> type = this.mConfig.getContextSource().getContextType();
            boolean exceptionGuardian = this.mConfig.isExceptionGuardianEnabled();
            String prefix = this.mConfig.getPackagePrefix();
            FileCompiler compiler = new FileCompiler(this.mTemplateRootDirs, prefix, this.mCompiledDir, injector);
            compiler.addImportedPackages(this.getImports());
            compiler.setClassLoader((ClassLoader)injector);
            compiler.setRuntimeContext(type);
            compiler.setExceptionGuardianEnabled(exceptionGuardian);
            compiler.setForceCompile(false);
            String[] tNames = compiler.getAllTemplateNames();
            for (int i = 0; i < tNames.length; ++i) {
                CompilationUnit unit = compiler.getCompilationUnit(tNames[i], null);
                if (!unit.shouldCompile()) continue;
                Boolean sigChanged = this.sourceSignatureChanged(unit.getName(), compiler);
                touchedTemplateMap.put(unit.getName(), sigChanged);
            }
        }
        return touchedTemplateMap;
    }

    protected boolean sourceSignatureChanged(String tName, Compiler compiler) throws IOException {
        TemplateRepository tRepo = TemplateRepository.getInstance();
        TemplateRepository.TemplateInfo templateInfo = tRepo.getTemplateInfo(tName);
        if (null == templateInfo) {
            return false;
        }
        CompilationUnit unit = compiler.getCompilationUnit(tName, null);
        if (unit == null) {
            return false;
        }
        return !unit.signatureEquals(tName, templateInfo.getParameterTypes(), templateInfo.getReturnType());
    }

    public boolean isLogCompileStatus() {
        return this.mLogCompileStatus;
    }

    public void setLogCompileStatus(boolean logCompileStatus) {
        this.mLogCompileStatus = logCompileStatus;
    }

    public class CompilerStatusLogger
    implements StatusListener {
        private String mSrc;

        public CompilerStatusLogger(String src) {
            this.mSrc = src;
        }

        @Override
        public void statusUpdate(StatusEvent e) {
            TemplateSourceImpl.this.mLog.debug("currently compiling " + e.getCurrentName() + " (" + (1 + e.getCurrent()) + " of " + e.getTotal() + ")");
        }
    }

    private class TemplateImpl
    implements Template {
        private TemplateLoader.Template mTemplate;
        private TemplateSource mSource;
        private File mSourceFile;
        private long mLastModifiedTime;

        protected TemplateImpl(TemplateLoader.Template template, TemplateSource source, File sourceFile, long lastModifiedTime) {
            this.mTemplate = template;
            this.mSource = source;
            this.mSourceFile = sourceFile;
            this.mLastModifiedTime = lastModifiedTime;
        }

        @Override
        public TemplateSource getTemplateSource() {
            return this.mSource;
        }

        @Override
        public File getSourceFile() {
            return this.mSourceFile;
        }

        @Override
        public long getLastModifiedTime() {
            return this.mLastModifiedTime;
        }

        @Override
        public TemplateLoader getTemplateLoader() {
            return this.mTemplate.getTemplateLoader();
        }

        @Override
        public String getName() {
            return this.mTemplate.getName();
        }

        @Override
        public Class<?> getTemplateClass() {
            return this.mTemplate.getTemplateClass();
        }

        @Override
        public Class<?> getContextType() {
            return this.mTemplate.getContextType();
        }

        @Override
        public String[] getParameterNames() {
            return this.mTemplate.getParameterNames();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.mTemplate.getParameterTypes();
        }

        @Override
        public void execute(Context context, Object[] parameters) throws Exception {
            if (context == null) {
                throw new Exception("cannot execute against a  null context");
            }
            this.mTemplate.execute(context, parameters);
        }
    }

    protected class TemplateSourceFileInfo {
        private String mName;
        private File mSourceFile;
        private long mLastModifiedTime;

        public TemplateSourceFileInfo(String name, File sourceFile, long lastModifiedTime) {
            this.mName = name;
            this.mSourceFile = sourceFile;
            this.mLastModifiedTime = lastModifiedTime;
        }

        public String getName() {
            return this.mName;
        }

        public File getSourceFile() {
            return this.mSourceFile;
        }

        public long getLastModifiedTime() {
            return this.mLastModifiedTime;
        }
    }

    protected class Results {
        private TemplateCompilationResults mTransient;
        private TemplateLoader mLoader;
        private Date mLastReloadTime;
        private Set<String> mKnownTemplateNames;
        private Map<String, Template> mWrappedTemplates;

        public Results(TemplateCompilationResults transientResults, TemplateLoader loader, Date lastReload, Set<String> known, Map<String, Template> wrapped) {
            this.mTransient = transientResults;
            this.mLastReloadTime = lastReload;
            this.mLoader = loader;
            this.mKnownTemplateNames = known;
            this.mWrappedTemplates = wrapped;
        }

        public TemplateCompilationResults getTransientResults() {
            return this.mTransient;
        }

        public TemplateLoader getLoader() {
            return this.mLoader;
        }

        public Date getLastReloadTime() {
            return this.mLastReloadTime;
        }

        public Map<String, Template> getWrappedTemplates() {
            return this.mWrappedTemplates;
        }

        public Set<String> getKnownTemplateNames() {
            return this.mKnownTemplateNames;
        }
    }

    protected class ErrorRetriever
    implements TemplateErrorListener {
        protected Map<String, List<TemplateError>> mTemplateErrors = new Hashtable<String, List<TemplateError>>();
        private LinePositionReader mOpenReader;
        private CompilationUnit mOpenUnit;

        protected ErrorRetriever() {
        }

        @Override
        public Map<String, List<TemplateError>> getTemplateErrors() {
            return this.mTemplateErrors;
        }

        @Override
        public void compileError(ErrorEvent event) {
            TemplateSourceImpl.this.mConfig.getLog().warn("Error in " + event.getDetailedErrorMessage());
            CompilationUnit unit = event.getCompilationUnit();
            if (unit == null) {
                return;
            }
            String templateName = unit.getName();
            List<TemplateError> errors = this.mTemplateErrors.get(templateName);
            if (errors == null) {
                errors = new ArrayList<TemplateError>();
                this.mTemplateErrors.put(templateName, errors);
            }
            String sourcePath = unit.getSourceFileName();
            if (unit instanceof FileCompiler.Unit) {
                sourcePath = ((FileCompiler.Unit)unit).getSourceFile().getAbsolutePath();
            } else if (unit instanceof FileCompiler.JarredUnit) {
                sourcePath = ((FileCompiler.JarredUnit)unit).getSourceUrl().toString();
            }
            TemplateError templateError = this.createTemplateError(sourcePath, event);
            if (templateError != null) {
                errors.add(templateError);
            }
        }

        protected TemplateError createTemplateError(String sourcePath, ErrorEvent event) {
            SourceInfo info = event.getSourceInfo();
            if (info == null) {
                return null;
            }
            CompilationUnit unit = event.getCompilationUnit();
            if (unit == null) {
                return null;
            }
            Date lastModifiedDate = new Date(new File(sourcePath).lastModified());
            String errorMessage = event.getErrorMessage();
            String detailedErrorMessage = event.getDetailedErrorMessage();
            String sourceInfoMessage = event.getSourceInfoMessage();
            int lineNumber = -1;
            int errorStartPos = -1;
            int errorEndPos = -1;
            int detailPos = -1;
            int linePos = -1;
            String lineStr = null;
            String underline = null;
            try {
                lineNumber = info.getLine();
                errorStartPos = info.getStartPosition();
                errorEndPos = info.getEndPosition();
                detailPos = info.getDetailPosition();
                if (this.mOpenReader == null || this.mOpenUnit != unit || this.mOpenReader.getLineNumber() >= lineNumber) {
                    if (this.mOpenReader != null) {
                        this.mOpenReader.close();
                    }
                    this.mOpenUnit = unit;
                    this.mOpenReader = new LinePositionReader((Reader)new BufferedReader(unit.getReader()));
                }
                this.mOpenReader.skipForwardToLine(lineNumber);
                linePos = this.mOpenReader.getNextPosition();
                lineStr = this.mOpenReader.readLine();
                lineStr = LinePositionReader.cleanWhitespace((String)lineStr);
                int indentSize = errorStartPos - linePos;
                String indent = LinePositionReader.createSequence((char)' ', (int)indentSize);
                int markerSize = errorEndPos - errorStartPos + 1;
                String marker = LinePositionReader.createSequence((char)'^', (int)markerSize);
                underline = indent + marker;
            }
            catch (IOException ex) {
                TemplateSourceImpl.this.mLog.error((Throwable)ex);
            }
            return new TemplateError(sourcePath, lastModifiedDate, errorMessage, detailedErrorMessage, sourceInfoMessage, lineStr, underline, lineNumber, errorStartPos, errorEndPos, errorStartPos - linePos, errorEndPos - linePos + 1, detailPos - linePos);
        }

        @Override
        public void close() {
            if (this.mOpenReader != null) {
                try {
                    this.mOpenReader.close();
                }
                catch (IOException e) {
                    TemplateSourceImpl.this.mConfig.getLog().error((Throwable)e);
                }
            }
            this.mOpenReader = null;
            this.mOpenUnit = null;
        }

        protected void finalize() {
            this.close();
        }
    }

    private class ResolvingInjector
    extends ClassInjector {
        public ResolvingInjector(ClassLoader cl, File[] classDirs, String pkg, boolean keepByteCode) {
            super(cl, classDirs, pkg, keepByteCode);
        }

        public Class<?> loadClass(String className) throws ClassNotFoundException {
            return this.loadClass(className, true);
        }
    }
}

