/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.io;

import java.io.IOException;
import java.io.Reader;
import org.teatrove.tea.io.PositionReader;

public class LinePositionReader
extends PositionReader {
    private int mLineNumber = 1;
    private int mPushback = -1;

    public LinePositionReader(Reader reader) {
        super(reader);
    }

    public int read() throws IOException {
        int c;
        if (this.mPushback >= 0) {
            c = this.mPushback;
            this.mPushback = -1;
        } else {
            c = super.read();
        }
        if (c == 10) {
            ++this.mLineNumber;
        } else if (c == 13) {
            int peek = super.read();
            if (peek != 10) {
                ++this.mLineNumber;
            }
            this.mPushback = peek;
        }
        return c;
    }

    public String readLine() throws IOException {
        int c;
        StringBuffer buf = new StringBuffer(80);
        int line = this.mLineNumber;
        while (line == this.mLineNumber && (c = this.read()) >= 0) {
            buf.append((char)c);
        }
        return buf.toString();
    }

    public int skipForwardToLine(int line) throws IOException {
        while (this.mLineNumber < line && this.read() >= 0) {
        }
        return this.mLineNumber;
    }

    public int getLineNumber() {
        return this.mLineNumber;
    }

    public static String cleanWhitespace(String str) {
        int length = str.length();
        StringBuffer buf = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) {
                buf.append(' ');
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String createSequence(char c, int length) {
        if (length < 0) {
            length = 1;
        }
        StringBuffer buf = new StringBuffer(length);
        while (length > 0) {
            buf.append(c);
            --length;
        }
        return buf.toString();
    }
}

