/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.io;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.teatrove.tea.io.EscapeReader;
import org.teatrove.tea.io.PositionReader;

public class TagReader
extends EscapeReader {
    private int mTagCount;
    private int[] mTagStarts;
    private String[] mTagEnds;
    private int[] mCodes;
    private char[] mMinibuf;

    private static int maxLength(String[] tags) {
        int max = 0;
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i].length() <= max) continue;
            max = tags[i].length();
        }
        return max;
    }

    public TagReader(Reader source, String[] tags, int[] codes) {
        super(source, TagReader.maxLength(tags));
        this.mTagCount = tags.length;
        this.mTagStarts = new int[this.mTagCount];
        this.mTagEnds = new String[this.mTagCount];
        this.mCodes = new int[this.mTagCount];
        for (int i = 0; i < this.mTagCount; ++i) {
            this.mTagStarts[i] = tags[i].charAt(0);
            this.mTagEnds[i] = tags[i].substring(1);
            this.mCodes[i] = codes[i];
        }
        this.mMinibuf = new char[TagReader.maxLength(tags)];
    }

    public int read() throws IOException {
        int c = this.mSource.read();
        if (c == -1 || !this.mEscapesEnabled) {
            return c;
        }
        for (int i = 0; i < this.mTagCount; ++i) {
            if (this.mTagStarts[i] != c) continue;
            int length = this.mTagEnds[i].length();
            this.mMinibuf[0] = (char)c;
            int len = this.mSource.read(this.mMinibuf, 0, length);
            if (len == length && new String(this.mMinibuf, 0, length).equals(this.mTagEnds[i])) {
                return this.mCodes[i];
            }
            if (len <= 0) continue;
            this.mSource.unread(len);
        }
        return c;
    }

    public static void main(String[] arg) throws Exception {
        Tester.test(arg);
    }

    private static class Tester {
        private Tester() {
        }

        public static void test(String[] arg) throws Exception {
            int c;
            String str = "This <%is a %> % > > % %% >> < % test.\n";
            System.out.println("\nOriginal: " + str);
            System.out.println("\nConverted:\n");
            StringReader reader = new StringReader(str);
            TagReader tr = new TagReader(reader, new String[]{"<%", "%>"}, new int[]{-2, -3});
            PositionReader pr = new PositionReader((Reader)((Object)tr));
            System.out.print(pr.getNextPosition() + "\t");
            while ((c = pr.read()) != -1) {
                System.out.println((char)c + "\t" + c);
                System.out.print(pr.getNextPosition() + "\t");
            }
        }
    }
}

