/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.io;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.teatrove.tea.io.EscapeReader;
import org.teatrove.tea.io.PushbackPositionReader;

public class UnicodeReader
extends EscapeReader {
    private char[] mMinibuf = new char[4];
    private boolean mEscaped;

    public UnicodeReader(Reader source) {
        super(source, 6);
    }

    public int read() throws IOException {
        int c = this.mSource.read();
        if (c != 92 || !this.mEscapesEnabled) {
            this.mEscaped = false;
            return c;
        }
        c = this.mSource.read();
        if (c == 92) {
            this.mEscaped = !this.mEscaped;
            this.mSource.unread();
            return 92;
        }
        if (c != 117) {
            this.mSource.unread();
            return 92;
        }
        if (this.mEscaped) {
            this.mEscaped = false;
            this.mSource.unread();
            return 92;
        }
        int len = this.mSource.read(this.mMinibuf, 0, 4);
        if (len == 4) {
            try {
                int val = Integer.valueOf(new String(this.mMinibuf, 0, 4), 16);
                return val;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (len >= 0) {
            this.mSource.unread(len + 1);
        }
        return 92;
    }

    public static void main(String[] arg) throws Exception {
        Tester.test(arg);
    }

    private static class Tester {
        private Tester() {
        }

        public static void test(String[] arg) throws Exception {
            int c;
            String str = "This is \\u0061 test.\nThis is \\u00612 test.\nThis is \\u0061\\u0061 test.\nThis is \\u061 test.\nThis is \\\\u0061 test.\nThis is \\a test.\n";
            System.out.println("\nOriginal:\n");
            Object reader = new StringReader(str);
            while ((c = ((Reader)reader).read()) >= 0) {
                System.out.print((char)c);
            }
            System.out.println("\nConverted:\n");
            reader = new StringReader(str);
            reader = new UnicodeReader((Reader)reader);
            while ((c = ((Reader)reader).read()) != -1) {
                System.out.print((char)c);
            }
            System.out.println("\nUnread test 1:\n");
            reader = new StringReader(str);
            PushbackPositionReader pr = new PushbackPositionReader((Reader)((Object)new UnicodeReader((Reader)reader)), 1);
            while ((c = pr.read()) != -1) {
                pr.unread();
                c = pr.read();
                System.out.print((char)c);
            }
            System.out.println("\nUnread test 2:\n");
            reader = new StringReader(str);
            pr = new PushbackPositionReader((Reader)((Object)new UnicodeReader((Reader)reader)), 2);
            int i = 0;
            while ((c = pr.read()) != -1) {
                if (i++ % 5 == 0) {
                    c = pr.read();
                    pr.unread();
                    pr.unread();
                    c = pr.read();
                }
                System.out.print((char)c);
            }
            System.out.println("\nUnread position test:\n");
            reader = new StringReader(str);
            pr = new PushbackPositionReader((Reader)((Object)new UnicodeReader((Reader)reader)), 2);
            System.out.print(pr.getNextPosition() + "\t");
            i = 0;
            while ((c = pr.read()) != -1) {
                if (i++ % 5 == 0) {
                    c = pr.read();
                    pr.unread();
                    pr.unread();
                    c = pr.read();
                }
                System.out.println((char)c);
                System.out.print(pr.getNextPosition() + "\t");
            }
        }
    }
}

