/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.teatrove.tea.log.TeaLogEvent;
import org.teatrove.tea.log.TeaLogListener;
import org.teatrove.trove.log.Log;
import org.teatrove.trove.log.LogEvent;
import org.teatrove.trove.log.LogListener;

public class TeaLog
extends Log {
    private static final long serialVersionUID = 1L;
    private final String TEA_EXCEPTION = ".tea:";

    public TeaLog(Log parent) {
        super(parent.getName(), parent);
    }

    public synchronized void info(Throwable t) {
        TeaStackTraceLine[] lines = this.getTeaStackTraceLines(t);
        if (lines == null) {
            super.info(t);
        } else if (this.isEnabled() && this.isInfoEnabled()) {
            this.dispatchLogTeaStackTrace(new TeaLogEvent(this, 2, lines));
        }
    }

    public synchronized void error(Throwable t) {
        TeaStackTraceLine[] lines = this.getTeaStackTraceLines(t);
        if (lines == null) {
            super.error(t);
        } else if (this.isEnabled() && this.isErrorEnabled()) {
            this.dispatchLogTeaStackTrace(new TeaLogEvent(this, 4, lines));
        }
    }

    public synchronized void warn(Throwable t) {
        TeaStackTraceLine[] lines = this.getTeaStackTraceLines(t);
        if (lines == null) {
            super.warn(t);
        } else if (this.isEnabled() && this.isWarnEnabled()) {
            this.dispatchLogTeaStackTrace(new TeaLogEvent(this, 3, lines));
        }
    }

    public synchronized void debug(Throwable t) {
        TeaStackTraceLine[] lines = this.getTeaStackTraceLines(t);
        if (lines == null) {
            super.debug(t);
        } else if (this.isEnabled() && this.isDebugEnabled()) {
            this.dispatchLogTeaStackTrace(new TeaLogEvent(this, 1, lines));
        }
    }

    private void dispatchLogTeaStackTrace(TeaLogEvent e) {
        int size = this.mListeners.size();
        try {
            for (int i = 0; i < size; ++i) {
                LogListener listener = (LogListener)this.mListeners.get(i);
                if (listener instanceof TeaLogListener) {
                    ((TeaLogListener)listener).logTeaStackTrace(e);
                    continue;
                }
                e.setMessage(this.printTeaStackTraceLines(e.getLines()));
                listener.logMessage((LogEvent)e);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private String printTeaStackTraceLines(TeaStackTraceLine[] lines) {
        String result = "";
        for (int line = 0; line < lines.length; ++line) {
            if (line > 0) {
                result = result + '\n';
            }
            result = result + lines[line].toString();
        }
        return result;
    }

    private TeaStackTraceLine[] getTeaStackTraceLines(Throwable t) {
        boolean isTeaException;
        StringWriter stackTraceGrabber = new StringWriter();
        t.printStackTrace(new PrintWriter(stackTraceGrabber));
        String stackTrace = stackTraceGrabber.toString();
        int extensionIndex = stackTrace.lastIndexOf(".tea:");
        boolean bl = isTeaException = extensionIndex != -1;
        if (isTeaException) {
            int endIndex = stackTrace.indexOf(10, extensionIndex);
            int endRIndex = stackTrace.indexOf(13, extensionIndex);
            if (endRIndex > -1 && endRIndex < endIndex) {
                endIndex = endRIndex;
            }
            if (endIndex <= 0) {
                endIndex = stackTrace.length();
            }
            stackTrace = stackTrace.substring(0, endIndex);
            ArrayList<TeaStackTraceLine> teaStackTraceLines = new ArrayList<TeaStackTraceLine>();
            StringTokenizer tokenizer = new StringTokenizer(stackTrace, "\n");
            while (tokenizer.hasMoreElements()) {
                String line = (String)tokenizer.nextElement();
                if (line.indexOf(".tea:") != -1) {
                    String tempLine = line;
                    int bracket = tempLine.indexOf(40);
                    tempLine = tempLine.substring(bracket + 1);
                    bracket = tempLine.indexOf(41);
                    tempLine = tempLine.substring(0, bracket);
                    int colonIndex = tempLine.indexOf(58);
                    String templateName = null;
                    Integer lineNumber = null;
                    if (colonIndex >= 0) {
                        templateName = tempLine.substring(0, colonIndex);
                        lineNumber = new Integer(tempLine.substring(colonIndex + 1));
                    } else {
                        templateName = tempLine;
                        lineNumber = null;
                    }
                    teaStackTraceLines.add(new TeaStackTraceLine(templateName, lineNumber, line));
                    continue;
                }
                teaStackTraceLines.add(new TeaStackTraceLine(null, null, line));
            }
            return teaStackTraceLines.toArray(new TeaStackTraceLine[teaStackTraceLines.size()]);
        }
        return null;
    }

    public class TeaStackTraceLine {
        private String mTemplateName;
        private Integer mLineNumber;
        private String mLine;

        public TeaStackTraceLine(String templateName, Integer lineNumber, String line) {
            this.mTemplateName = templateName;
            this.mLineNumber = lineNumber;
            this.mLine = line;
        }

        public String getLine() {
            return this.mLine;
        }

        public Integer getLineNumber() {
            return this.mLineNumber;
        }

        public String getTemplateName() {
            return this.mTemplateName;
        }

        public String toString() {
            if (this.mLineNumber != null) {
                return "\tat " + (this.mLineNumber != null ? "line " + this.mLineNumber + " of " : "unknown line of ") + "template " + this.mTemplateName;
            }
            return this.mLine;
        }
    }
}

