/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import java.lang.reflect.Method;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Token;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.NodeVisitor;
import org.teatrove.tea.parsetree.NullSafe;

public class ArrayLookup
extends Expression
implements NullSafe {
    private static final long serialVersionUID = 1L;
    private Expression mExpr;
    private Token mToken;
    private Expression mLookupIndex;
    private Method mMethod;
    private boolean mNullSafe;

    public ArrayLookup(SourceInfo info, Expression expr, Token lookupToken, Expression lookupIndex) {
        super(info);
        this.mExpr = expr;
        this.mToken = lookupToken;
        this.mLookupIndex = lookupIndex;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public Object clone() {
        ArrayLookup al = (ArrayLookup)super.clone();
        al.mExpr = (Expression)this.mExpr.clone();
        al.mLookupIndex = (Expression)this.mLookupIndex.clone();
        return al;
    }

    @Override
    public boolean isExceptionPossible() {
        return true;
    }

    public Expression getExpression() {
        return this.mExpr;
    }

    public Token getLookupToken() {
        return this.mToken;
    }

    public Expression getLookupIndex() {
        return this.mLookupIndex;
    }

    public Method getReadMethod() {
        return this.mMethod;
    }

    public void setExpression(Expression expr) {
        this.mExpr = expr;
    }

    public void setLookupIndex(Expression lookupIndex) {
        this.mLookupIndex = lookupIndex;
    }

    public void setReadMethod(Method m) {
        this.mMethod = m;
    }

    @Override
    public boolean isNullSafe() {
        return this.mNullSafe;
    }

    @Override
    public void setNullSafe(boolean nullSafe) {
        this.mNullSafe = nullSafe;
    }
}

