/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Token;
import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.Expression;

public abstract class BinaryExpression
extends Expression {
    private static final long serialVersionUID = 1L;
    private Token mOperator;
    private Expression mLeft;
    private Expression mRight;

    public BinaryExpression(SourceInfo info, Token operator, Expression left, Expression right) {
        super(info);
        this.mOperator = operator;
        this.mLeft = left;
        this.mRight = right;
    }

    @Override
    public Object clone() {
        BinaryExpression be = (BinaryExpression)super.clone();
        be.mLeft = (Expression)this.mLeft.clone();
        be.mRight = (Expression)this.mRight.clone();
        return be;
    }

    @Override
    public boolean isExceptionPossible() {
        Type type;
        if (this.mLeft != null) {
            if (this.mLeft.isExceptionPossible()) {
                return true;
            }
            type = this.mLeft.getType();
            if (type != null && type.isNullable()) {
                return true;
            }
        }
        if (this.mRight != null) {
            if (this.mRight.isExceptionPossible()) {
                return true;
            }
            type = this.mRight.getType();
            if (type != null && type.isNullable()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setType(Type type) {
        super.setType(type.toNonNull());
    }

    public Token getOperator() {
        return this.mOperator;
    }

    public Expression getLeftExpression() {
        return this.mLeft;
    }

    public Expression getRightExpression() {
        return this.mRight;
    }

    public void setLeftExpression(Expression left) {
        this.mLeft = left;
    }

    public void setRightExpression(Expression right) {
        this.mRight = right;
    }
}

