/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.parsetree.NodeVisitor;
import org.teatrove.tea.parsetree.Statement;
import org.teatrove.tea.parsetree.StatementList;

public class Block
extends StatementList {
    private static final long serialVersionUID = 1L;
    private Statement mInitializer;
    private Statement mFinalizer;

    public Block(SourceInfo info, Statement[] statements) {
        super(info, statements);
    }

    public Block(SourceInfo info) {
        super(info, new Statement[0]);
    }

    public Block(Statement stmt) {
        super(stmt.getSourceInfo(), new Statement[]{stmt});
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public Object clone() {
        Block b = (Block)super.clone();
        if (this.mInitializer != null) {
            b.mInitializer = (Statement)this.mInitializer.clone();
        }
        if (this.mFinalizer != null) {
            b.mFinalizer = (Statement)this.mFinalizer.clone();
        }
        return b;
    }

    public Statement getInitializer() {
        return this.mInitializer;
    }

    public Statement getFinalizer() {
        return this.mFinalizer;
    }

    public void setInitializer(Statement initializer) {
        this.mInitializer = initializer;
    }

    public void setFinalizer(Statement finalizer) {
        this.mFinalizer = finalizer;
    }
}

