/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.parsetree.Block;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.ExpressionList;
import org.teatrove.tea.parsetree.Name;
import org.teatrove.tea.parsetree.NullSafe;
import org.teatrove.tea.parsetree.Statement;

public abstract class CallExpression
extends Expression
implements NullSafe {
    private static final long serialVersionUID = 1L;
    private Expression mExpression;
    private Name mTarget;
    private ExpressionList mParams;
    private Statement mInitializer;
    private Block mSubParam;
    private boolean mVoidPermitted;
    private boolean mNullSafe;

    public CallExpression(SourceInfo info, Expression expression, Name target, ExpressionList params, Block subParam) {
        super(info);
        this.mExpression = expression;
        this.mTarget = target;
        this.mParams = params;
        this.mSubParam = subParam;
    }

    @Override
    public Object clone() {
        CallExpression ce = (CallExpression)super.clone();
        ce.mParams = (ExpressionList)this.mParams.clone();
        if (this.mInitializer != null) {
            ce.mInitializer = (Statement)this.mInitializer.clone();
        }
        if (this.mSubParam != null) {
            ce.mSubParam = (Block)this.mSubParam.clone();
        }
        return ce;
    }

    @Override
    public boolean isExceptionPossible() {
        return true;
    }

    public Name getTarget() {
        return this.mTarget;
    }

    public void setTarget(Name target) {
        this.mTarget = target;
    }

    public Expression getExpression() {
        return this.mExpression;
    }

    public void setExpression(Expression expression) {
        this.mExpression = expression;
    }

    public ExpressionList getParams() {
        return this.mParams;
    }

    public Statement getInitializer() {
        return this.mInitializer;
    }

    public Block getSubstitutionParam() {
        return this.mSubParam;
    }

    public boolean isVoidPermitted() {
        return this.mVoidPermitted;
    }

    public void setParams(ExpressionList params) {
        this.mParams = params;
    }

    public void setInitializer(Statement stmt) {
        this.mInitializer = stmt;
    }

    public void setSubstitutionParam(Block subParam) {
        this.mSubParam = subParam;
    }

    public void setVoidPermitted(boolean b) {
        this.mVoidPermitted = b;
    }

    @Override
    public boolean isNullSafe() {
        return this.mNullSafe;
    }

    @Override
    public void setNullSafe(boolean nullSafe) {
        this.mNullSafe = nullSafe;
    }
}

