/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.parsetree.NodeVisitor;
import org.teatrove.tea.parsetree.Statement;

public class ExceptionGuardStatement
extends Statement {
    private static final long serialVersionUID = 1L;
    private Statement mGuarded;
    private Statement mReplacement;

    public ExceptionGuardStatement(Statement guarded, Statement replacement) {
        this(guarded.getSourceInfo(), guarded, replacement);
    }

    public ExceptionGuardStatement(SourceInfo info, Statement guarded, Statement replacement) {
        super(info);
        this.mGuarded = guarded;
        this.mReplacement = replacement;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public Object clone() {
        ExceptionGuardStatement egs = (ExceptionGuardStatement)super.clone();
        egs.mGuarded = (Statement)this.mGuarded.clone();
        if (this.mReplacement != null) {
            egs.mReplacement = (Statement)this.mReplacement.clone();
        }
        return egs;
    }

    @Override
    public boolean isReturn() {
        return this.mGuarded != null && this.mGuarded.isReturn() && this.mReplacement != null && this.mReplacement.isReturn();
    }

    @Override
    public boolean isBreak() {
        return this.mGuarded != null && this.mGuarded.isBreak() && this.mReplacement != null && this.mReplacement.isBreak();
    }

    public Statement getGuarded() {
        return this.mGuarded;
    }

    public Statement getReplacement() {
        return this.mReplacement;
    }

    public void setGuarded(Statement guarded) {
        this.mGuarded = guarded;
    }

    public void setReplacement(Statement replacement) {
        this.mReplacement = replacement;
    }
}

