/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.Node;
import org.teatrove.tea.parsetree.NodeVisitor;

public class Expression
extends Node {
    private static final long serialVersionUID = 1L;
    private LinkedList<Conversion> mConversions = new LinkedList();
    private boolean mExceptionPossible;

    public Expression(SourceInfo info) {
        super(info);
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public Object clone() {
        Expression e = (Expression)super.clone();
        e.mConversions = (LinkedList)this.mConversions.clone();
        return e;
    }

    public boolean isExceptionPossible() {
        return this.mExceptionPossible;
    }

    public Type getType() {
        if (this.mConversions.isEmpty()) {
            return null;
        }
        return this.mConversions.getLast().getToType();
    }

    public Type getInitialType() {
        if (this.mConversions.isEmpty()) {
            return null;
        }
        return this.mConversions.getFirst().getToType();
    }

    public final void convertTo(Type toType) {
        this.convertTo(toType, true);
    }

    public void convertTo(Type toType, boolean preferCast) {
        Class<?> toObj;
        Class<?> fromObj;
        Type fromType = this.getType();
        Type actual = Type.preserveType(fromType, toType);
        if (actual.equals(fromType)) {
            return;
        }
        boolean legal = false;
        if (!preferCast && fromType == Type.NULL_TYPE) {
            preferCast = true;
        }
        if (fromType == null) {
            legal = true;
        } else if (fromType.isPrimitive()) {
            if (actual.isPrimitive()) {
                if (actual.getNaturalClass() != Void.TYPE) {
                    legal = true;
                }
            } else {
                fromObj = fromType.getObjectClass();
                toObj = actual.getObjectClass();
                if (toObj.isAssignableFrom(fromObj)) {
                    legal = true;
                    if (fromObj != toObj) {
                        actual = fromType.toNonPrimitive();
                    }
                } else if (Number.class.isAssignableFrom(fromObj) && actual.hasPrimitivePeer()) {
                    if (Number.class.isAssignableFrom(toObj)) {
                        legal = true;
                        this.convertTo(actual.toPrimitive());
                    } else if (Character.class.isAssignableFrom(toObj)) {
                        legal = true;
                        this.convertTo(new Type(Character.TYPE));
                    }
                }
            }
        } else if (actual.isPrimitive()) {
            if (fromType.hasPrimitivePeer()) {
                Type fromPrim;
                legal = true;
                if (fromType.isNullable()) {
                    this.mExceptionPossible = true;
                }
                if ((fromPrim = fromType.toPrimitive()).getNaturalClass() != actual.getNaturalClass()) {
                    this.convertTo(fromPrim);
                }
            } else {
                fromObj = fromType.getObjectClass();
                toObj = actual.getObjectClass();
                if (Number.class.isAssignableFrom(fromObj) && Number.class.isAssignableFrom(toObj)) {
                    legal = true;
                    if (fromType.isNullable()) {
                        this.mExceptionPossible = true;
                    }
                } else if (preferCast) {
                    legal = true;
                    this.convertTo(actual.toNonPrimitive(), true);
                }
            }
        } else {
            fromObj = fromType.getObjectClass();
            if (fromObj.equals(toObj = actual.getObjectClass())) {
                legal = true;
                if (fromType.isNonNull() || !actual.isNonNull()) {
                    return;
                }
            } else if (fromObj.isAssignableFrom(toObj)) {
                if (preferCast) {
                    legal = true;
                }
            } else if (toObj.isAssignableFrom(fromObj)) {
                legal = true;
                if (fromType.isNonNull() || !actual.isNonNull()) {
                    return;
                }
            } else if (Number.class.isAssignableFrom(fromObj) && Number.class.isAssignableFrom(toObj) && actual.hasPrimitivePeer()) {
                legal = true;
                if (fromType.isNonNull()) {
                    this.convertTo(actual.toPrimitive(), true);
                }
            } else if (fromObj.getComponentType() != null && toObj.getComponentType() != null && actual.convertableFrom(fromType) >= 0) {
                legal = true;
                if (fromType.isNullable()) {
                    this.mExceptionPossible = true;
                }
            }
        }
        if (!legal && actual.getNaturalClass().isAssignableFrom(String.class)) {
            legal = true;
            if (actual.isNonNull()) {
                this.addConversion(Type.NON_NULL_STRING_TYPE, false);
            } else {
                this.addConversion(Type.STRING_TYPE, false);
            }
        }
        if (!(legal || preferCast || fromType.isPrimitive() || actual.isPrimitive())) {
            fromObj = fromType.getObjectClass();
            if (fromObj.isAssignableFrom(toObj = actual.getObjectClass())) {
                legal = true;
            } else if (toObj.isAssignableFrom(fromObj)) {
                legal = true;
            }
        }
        if (!legal) {
            throw new IllegalArgumentException("Can't convert " + fromType + " to " + toType);
        }
        this.addConversion(actual, preferCast);
    }

    public void forceConversion(Type toType, boolean preferCast) {
        Type fromType = this.getType();
        Type convType = Type.preserveType(fromType, toType);
        this.mConversions.add(new Conversion(fromType, convType, preferCast));
    }

    private void addConversion(Type toType, boolean preferCast) {
        Type fromType = this.getType();
        Type convType = Type.preserveType(fromType, toType);
        if (!convType.equals(fromType)) {
            this.mConversions.add(new Conversion(fromType, convType, preferCast));
        }
    }

    public LinkedList<Conversion> getConversionChain() {
        return this.reduce(this.mConversions);
    }

    public void setType(Type type) {
        Type actual = Type.preserveType(this.getType(), type);
        this.mConversions.clear();
        this.mExceptionPossible = false;
        if (actual != null) {
            this.mConversions.add(new Conversion(null, actual, true));
        }
    }

    public void setInitialType(Type type) {
        Type initial = this.getInitialType();
        Type actual = Type.preserveType(initial, type);
        if (actual != null && !actual.equals(initial)) {
            if (initial == null) {
                this.setType(actual);
            } else {
                Iterator it = this.mConversions.iterator();
                this.mConversions = new LinkedList();
                this.mConversions.add(new Conversion(null, actual, true));
                while (it.hasNext()) {
                    Conversion conv = (Conversion)it.next();
                    this.convertTo(conv.getToType(), conv.isCastPreferred());
                }
            }
        }
    }

    public boolean isValueKnown() {
        return false;
    }

    public Object getValue() {
        return null;
    }

    private LinkedList<Conversion> reduce(LinkedList<Conversion> conversions) {
        block0: while (true) {
            ListIterator fromIterator = conversions.listIterator();
            while (fromIterator.hasNext()) {
                int fromIndex = fromIterator.nextIndex();
                Type from = ((Conversion)fromIterator.next()).getToType();
                ListIterator<Conversion> toIterator = conversions.listIterator(fromIndex + 1);
                while (toIterator.hasNext()) {
                    int toIndex = toIterator.nextIndex();
                    Type to = toIterator.next().getToType();
                    if (!from.equals(to)) continue;
                    conversions.subList(fromIndex + 1, toIndex + 1).clear();
                    continue block0;
                }
            }
            break;
        }
        ListIterator<Conversion> it = conversions.listIterator();
        while (it.hasNext()) {
            Type type = ((Conversion)it.next()).getToType();
            while (type.isPrimitive() && it.hasNext()) {
                Type nextType = ((Conversion)it.next()).getToType();
                if (type.toNonPrimitive().equals(nextType) && it.hasNext()) {
                    Type thirdType = ((Conversion)it.next()).getToType();
                    if (thirdType.getNaturalClass() == String.class) {
                        it.previous();
                        it.remove();
                        it.previous();
                        it.remove();
                        it.add(new Conversion(type, thirdType, false));
                        continue;
                    }
                    type = thirdType;
                    continue;
                }
                type = nextType;
            }
        }
        return conversions;
    }

    public static class Conversion {
        private Type mFromType;
        private Type mToType;
        private boolean mPreferCast;

        Conversion(Type fromType, Type toType, boolean preferCast) {
            this.mFromType = fromType;
            this.mToType = toType;
            if (this.mToType == null) {
                throw new NullPointerException("Cannot convert to null");
            }
            this.mPreferCast = preferCast;
        }

        public Type getFromType() {
            return this.mFromType;
        }

        public Type getToType() {
            return this.mToType;
        }

        public boolean isCastPreferred() {
            return this.mPreferCast;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Conversion)) {
                return false;
            }
            Conversion conv = (Conversion)other;
            if (this.mFromType == null ? conv.mFromType != null : !this.mFromType.equals(conv.mFromType)) {
                return false;
            }
            return this.mToType.equals(conv.mToType) && this.mPreferCast == conv.mPreferCast;
        }

        public String toString() {
            if (this.mFromType == null) {
                return "Convert to " + this.mToType.getFullName();
            }
            return "Convert from " + this.mFromType.getFullName() + " to " + this.mToType.getFullName();
        }
    }
}

