/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.parsetree.Block;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.NodeVisitor;
import org.teatrove.tea.parsetree.Statement;
import org.teatrove.tea.parsetree.VariableRef;

public class ForeachStatement
extends Statement {
    private static final long serialVersionUID = 1L;
    private VariableRef mLoopVar;
    private Expression mRange;
    private Expression mEndRange;
    private boolean mReverse;
    private Statement mInitializer;
    private Block mBody;

    public ForeachStatement(SourceInfo info, VariableRef loopVar, Expression range, Expression endRange, boolean reverse, Block body) {
        super(info);
        this.mLoopVar = loopVar;
        this.mRange = range;
        this.mEndRange = endRange;
        this.mReverse = reverse;
        this.mBody = body;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public Object clone() {
        ForeachStatement fs = (ForeachStatement)super.clone();
        fs.mLoopVar = (VariableRef)this.mLoopVar.clone();
        fs.mRange = (Expression)this.mRange.clone();
        fs.mEndRange = (Expression)this.mEndRange.clone();
        if (this.mInitializer != null) {
            fs.mInitializer = (Statement)this.mInitializer.clone();
        }
        fs.mBody = (Block)this.mBody.clone();
        return fs;
    }

    public VariableRef getLoopVariable() {
        return this.mLoopVar;
    }

    public Expression getRange() {
        return this.mRange;
    }

    public Expression getEndRange() {
        return this.mEndRange;
    }

    public boolean isReverse() {
        return this.mReverse;
    }

    public Statement getInitializer() {
        return this.mInitializer;
    }

    public Block getBody() {
        return this.mBody;
    }

    public void setRange(Expression range) {
        this.mRange = range;
    }

    public void setEndRange(Expression endRange) {
        this.mEndRange = endRange;
    }

    public void setInitializer(Statement stmt) {
        this.mInitializer = stmt;
    }

    public void setBody(Block body) {
        this.mBody = body;
    }
}

