/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.parsetree.Block;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.NodeVisitor;
import org.teatrove.tea.parsetree.Statement;
import org.teatrove.tea.parsetree.Variable;

public class IfStatement
extends Statement {
    private static final long serialVersionUID = 1L;
    private Expression mCondition;
    private Block mThenPart;
    private Block mElsePart;
    private Variable[] mMergedVariables;

    public IfStatement(SourceInfo info, Expression condition, Block thenPart) {
        this(info, condition, thenPart, null);
    }

    public IfStatement(SourceInfo info, Expression condition, Block thenPart, Block elsePart) {
        super(info);
        this.mCondition = condition;
        this.mThenPart = thenPart;
        this.mElsePart = elsePart;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public Object clone() {
        IfStatement is = (IfStatement)super.clone();
        is.mCondition = (Expression)this.mCondition.clone();
        if (this.mThenPart != null) {
            is.mThenPart = (Block)this.mThenPart.clone();
        }
        if (this.mElsePart != null) {
            is.mElsePart = (Block)this.mElsePart.clone();
        }
        return is;
    }

    @Override
    public boolean isReturn() {
        return this.mThenPart != null && this.mThenPart.isReturn() && this.mElsePart != null && this.mElsePart.isReturn();
    }

    @Override
    public boolean isBreak() {
        return this.mThenPart != null && this.mThenPart.isBreak() && this.mElsePart != null && this.mElsePart.isBreak();
    }

    public Expression getCondition() {
        return this.mCondition;
    }

    public Block getThenPart() {
        return this.mThenPart;
    }

    public Block getElsePart() {
        return this.mElsePart;
    }

    public void setCondition(Expression condition) {
        this.mCondition = condition;
    }

    public void setThenPart(Block block) {
        this.mThenPart = block;
    }

    public void setElsePart(Block block) {
        this.mElsePart = block;
    }

    public Variable[] getMergedVariables() {
        return this.mMergedVariables;
    }

    public void setMergedVariables(Variable[] vars) {
        this.mMergedVariables = vars;
    }
}

