/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Token;
import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.Name;
import org.teatrove.tea.parsetree.NodeVisitor;
import org.teatrove.tea.parsetree.NullSafe;

public class Lookup
extends Expression
implements NullSafe {
    private static final long serialVersionUID = 1L;
    private Expression mExpr;
    private Token mDot;
    private Name mLookupName;
    private Method mMethod;
    private Field mProperty;
    private boolean mNullSafe;

    public Lookup(SourceInfo info, Expression expr, Token dot, Name lookupName) {
        super(info);
        this.mExpr = expr;
        this.mDot = dot;
        this.mLookupName = lookupName;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public Object clone() {
        Lookup lookup = (Lookup)super.clone();
        lookup.mExpr = (Expression)this.mExpr.clone();
        return lookup;
    }

    @Override
    public boolean isExceptionPossible() {
        if (super.isExceptionPossible()) {
            return true;
        }
        if (this.mExpr != null) {
            Type type;
            if (this.mExpr.isExceptionPossible()) {
                return true;
            }
            if (!this.mNullSafe && (type = this.mExpr.getType()) != null && type.isNullable()) {
                return true;
            }
        }
        return this.mMethod != null;
    }

    public Expression getExpression() {
        return this.mExpr;
    }

    public Token getDot() {
        return this.mDot;
    }

    public Name getLookupName() {
        return this.mLookupName;
    }

    public void setExpression(Expression expr) {
        this.mExpr = expr;
    }

    public Method getReadMethod() {
        return this.mMethod;
    }

    public void setReadMethod(Method m) {
        this.mMethod = m;
    }

    public Field getReadProperty() {
        return this.mProperty;
    }

    public void setReadProperty(Field f) {
        this.mProperty = f;
    }

    @Override
    public boolean isNullSafe() {
        return this.mNullSafe;
    }

    @Override
    public void setNullSafe(boolean nullSafe) {
        this.mNullSafe = nullSafe;
    }
}

