/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import java.beans.IntrospectionException;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.ExpressionList;
import org.teatrove.tea.parsetree.NodeVisitor;

public class NewArrayExpression
extends Expression {
    private static final long serialVersionUID = 1L;
    private ExpressionList mList;
    private boolean mAssociative;

    public NewArrayExpression(SourceInfo info, ExpressionList list, boolean associative) {
        super(info);
        this.mList = list;
        this.mAssociative = associative;
    }

    @Override
    public Object clone() {
        NewArrayExpression nae = (NewArrayExpression)super.clone();
        nae.mList = (ExpressionList)this.mList.clone();
        return nae;
    }

    @Override
    public boolean isExceptionPossible() {
        if (this.mList != null) {
            Expression[] exprs = this.mList.getExpressions();
            for (int i = 0; i < exprs.length; ++i) {
                if (!exprs[i].isExceptionPossible()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public void convertTo(Type toType, boolean preferCast) {
        Type elementType;
        super.convertTo(toType, preferCast);
        if (String.class.isAssignableFrom(toType.getNaturalClass())) {
            return;
        }
        try {
            elementType = toType.getArrayElementType();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e.toString());
        }
        if (elementType != null) {
            int increment;
            int index;
            super.setType(toType);
            Expression[] exprs = this.getExpressionList().getExpressions();
            if (this.isAssociative()) {
                index = 1;
                increment = 2;
            } else {
                index = 0;
                increment = 1;
            }
            while (index < exprs.length) {
                if (exprs[index].getType() != Type.NULL_TYPE) {
                    exprs[index].convertTo(elementType, preferCast);
                }
                index += increment;
            }
        }
    }

    @Override
    public void setType(Type type) {
        super.setType(null);
        if (type != null) {
            this.convertTo(type.toNonNull(), false);
        }
    }

    public ExpressionList getExpressionList() {
        return this.mList;
    }

    public boolean isAssociative() {
        return this.mAssociative;
    }

    public void setExpressionList(ExpressionList list) {
        this.mList = list;
    }

    public boolean isAllConstant() {
        Expression[] exprs = this.mList.getExpressions();
        for (int i = 0; i < exprs.length; ++i) {
            NewArrayExpression nae;
            Expression expr = exprs[i];
            if (!(expr instanceof NewArrayExpression ? !(nae = (NewArrayExpression)expr).isAllConstant() : !expr.isValueKnown())) continue;
            return false;
        }
        return true;
    }
}

