/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.Logical;
import org.teatrove.tea.parsetree.NodeVisitor;

public class NotExpression
extends Expression
implements Logical {
    private static final long serialVersionUID = 1L;
    private Expression mExpr;

    public NotExpression(SourceInfo info, Expression expr) {
        super(info);
        this.mExpr = expr;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public Object clone() {
        NotExpression ne = (NotExpression)super.clone();
        ne.mExpr = (Expression)this.mExpr.clone();
        return ne;
    }

    @Override
    public boolean isExceptionPossible() {
        if (this.mExpr != null) {
            if (this.mExpr.isExceptionPossible()) {
                return true;
            }
            Type type = this.mExpr.getType();
            if (type != null && type.isNullable()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void convertTo(Type type, boolean preferCast) {
        Class<?> clazz = type.getObjectClass();
        if (Boolean.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz)) {
            this.setType(type);
        } else {
            super.convertTo(type, preferCast);
        }
    }

    @Override
    public void setType(Type type) {
        super.setType(type.toNonNull());
    }

    public Expression getExpression() {
        return this.mExpr;
    }

    public void setExpression(Expression expr) {
        this.mExpr = expr;
    }
}

