/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.Literal;
import org.teatrove.tea.parsetree.NodeVisitor;

public class NumberLiteral
extends Literal {
    private static final long serialVersionUID = 1L;
    private Number mValue;

    public NumberLiteral(SourceInfo info, Number value) {
        super(info);
        if (value == null) {
            throw new IllegalArgumentException("NumberLiterals cannot be null");
        }
        this.mValue = value;
        super.setType(new Type(value.getClass()).toPrimitive());
    }

    public NumberLiteral(SourceInfo info, int value) {
        this(info, new Integer(value));
    }

    public NumberLiteral(SourceInfo info, float value) {
        this(info, new Float(value));
    }

    public NumberLiteral(SourceInfo info, long value) {
        this(info, new Long(value));
    }

    public NumberLiteral(SourceInfo info, double value) {
        this(info, new Double(value));
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public void convertTo(Type type, boolean preferCast) {
        if (Number.class.isAssignableFrom(type.getObjectClass())) {
            if (type.isPrimitive()) {
                super.setType(type);
            } else {
                super.setType(type.toPrimitive());
                super.convertTo(type.toNonNull(), preferCast);
            }
        } else {
            super.convertTo(type, preferCast);
        }
    }

    @Override
    public void setType(Type type) {
        super.setType(type);
        if (this.isValueKnown()) {
            super.setType(this.getType().toNonNull());
        }
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public boolean isValueKnown() {
        Type type = this.getType();
        if (type != null) {
            Class<Number> clazz = type.getObjectClass();
            return Number.class.isAssignableFrom(clazz) || clazz.isAssignableFrom(Number.class);
        }
        return false;
    }
}

