/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Token;
import org.teatrove.tea.parsetree.BinaryLogicalExpression;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.NodeVisitor;
import org.teatrove.tea.parsetree.TypeName;

public class RelationalExpression
extends BinaryLogicalExpression {
    private static final long serialVersionUID = 1L;
    private TypeName mTypeName;

    public RelationalExpression(SourceInfo info, Token operator, Expression left, Expression right) {
        super(info, operator, left, right);
    }

    public RelationalExpression(SourceInfo info, Token operator, Expression left, TypeName typeName) {
        super(info, operator, left, null);
        this.mTypeName = typeName;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isExceptionPossible() {
        int id = this.getOperator().getID();
        if (id != 24 && id != 27 && id != 49) {
            return super.isExceptionPossible();
        }
        Expression left = this.getLeftExpression();
        Expression right = this.getLeftExpression();
        return left != null && left.isExceptionPossible() || right != null && right.isExceptionPossible();
    }

    @Override
    public Expression getRightExpression() {
        return super.getRightExpression();
    }

    public TypeName getIsaTypeName() {
        return this.mTypeName;
    }
}

