/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.NodeVisitor;

public class SpreadExpression
extends Expression {
    private static final long serialVersionUID = 1L;
    private Expression mExpr;
    private Expression mOperation;

    public SpreadExpression(SourceInfo info, Expression expr, Expression operation) {
        super(info);
        this.mExpr = expr;
        this.mOperation = operation;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public Object clone() {
        SpreadExpression spread = (SpreadExpression)super.clone();
        spread.mExpr = (Expression)this.mExpr.clone();
        spread.mOperation = (Expression)this.mOperation.clone();
        return spread;
    }

    @Override
    public boolean isExceptionPossible() {
        if (super.isExceptionPossible()) {
            return true;
        }
        if (this.mExpr != null && this.mExpr.isExceptionPossible()) {
            return true;
        }
        return this.mOperation != null && this.mOperation.isExceptionPossible();
    }

    public Expression getExpression() {
        return this.mExpr;
    }

    public Expression getOperation() {
        return this.mOperation;
    }

    public void setExpression(Expression expr) {
        this.mExpr = expr;
    }

    public void setOperation(Expression operation) {
        this.mOperation = operation;
    }
}

