/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.parsetree.NodeVisitor;
import org.teatrove.tea.parsetree.Statement;

public class StatementList
extends Statement {
    private static final long serialVersionUID = 1L;
    private Statement[] mStatements;

    public StatementList(SourceInfo info, Statement[] statements) {
        super(info);
        this.mStatements = statements;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public Object clone() {
        StatementList sl = (StatementList)super.clone();
        int length = this.mStatements.length;
        Statement[] newStatements = new Statement[length];
        for (int i = 0; i < length; ++i) {
            newStatements[i] = (Statement)this.mStatements[i].clone();
        }
        sl.mStatements = newStatements;
        return sl;
    }

    @Override
    public boolean isReturn() {
        if (this.mStatements != null) {
            for (int i = 0; i < this.mStatements.length; ++i) {
                if (!this.mStatements[i].isReturn()) continue;
                return true;
            }
        }
        return false;
    }

    public Statement[] getStatements() {
        return this.mStatements;
    }

    public void setStatements(Statement[] stmts) {
        this.mStatements = stmts;
    }
}

