/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.Literal;
import org.teatrove.tea.parsetree.NodeVisitor;

public class StringLiteral
extends Literal {
    private static final long serialVersionUID = 1L;
    private String mValue;

    public StringLiteral(SourceInfo info, String value) {
        super(info);
        if (value == null) {
            throw new IllegalArgumentException("StringLiterals cannot be null");
        }
        this.mValue = value;
        this.setType(Type.NON_NULL_STRING_TYPE);
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public void setType(Type type) {
        super.setType(type.toNonNull());
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    public boolean equals(Object another) {
        if (another instanceof StringLiteral) {
            return this.mValue.equals(((StringLiteral)another).mValue);
        }
        return false;
    }
}

