/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.Directive;
import org.teatrove.tea.parsetree.Name;
import org.teatrove.tea.parsetree.Node;
import org.teatrove.tea.parsetree.NodeVisitor;
import org.teatrove.tea.parsetree.Returnable;
import org.teatrove.tea.parsetree.Statement;
import org.teatrove.tea.parsetree.Variable;

public class Template
extends Node
implements Returnable {
    private static final long serialVersionUID = 1L;
    private Name mName;
    private Variable[] mParams;
    private boolean mSubParam;
    private Statement mStatement;
    private Type mType;
    private List<Directive> mDirectiveList;
    private Map<String, Object> mProperties = new HashMap<String, Object>();

    public Template() {
        super(null);
    }

    public Template(SourceInfo info, Name name, Variable[] params, boolean subParam, Statement statement, List<Directive> directiveList) {
        super(info);
        this.mName = name;
        this.mParams = params;
        this.mSubParam = subParam;
        this.mStatement = statement;
        this.mDirectiveList = directiveList;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public Object clone() {
        Template t = (Template)super.clone();
        int length = this.mParams.length;
        Variable[] newParams = new Variable[length];
        for (int i = 0; i < length; ++i) {
            newParams[i] = (Variable)this.mParams[i].clone();
        }
        t.mParams = newParams;
        t.mStatement = (Statement)this.mStatement.clone();
        if (this.mDirectiveList != null) {
            t.mDirectiveList = new ArrayList<Directive>();
            for (Directive directive : this.mDirectiveList) {
                t.mDirectiveList.add((Directive)directive.clone());
            }
        }
        return t;
    }

    public Name getName() {
        return this.mName;
    }

    public void setName(Name name) {
        this.mName = name;
    }

    public Variable[] getParams() {
        return this.mParams;
    }

    public void setParams(Variable[] params) {
        this.mParams = params;
    }

    public Object getProperty(String propertyName) {
        return this.mProperties.get(propertyName);
    }

    public void setProperty(String propertyName, Object value) {
        this.mProperties.put(propertyName, value);
    }

    public boolean hasSubstitutionParam() {
        return this.mSubParam;
    }

    public Statement getStatement() {
        return this.mStatement;
    }

    public void setStatement(Statement stmt) {
        this.mStatement = stmt;
    }

    public List<Directive> getDirectives() {
        return this.mDirectiveList;
    }

    @Override
    public Type getReturnType() {
        return this.mType;
    }

    @Override
    public void setReturnType(Type type) {
        this.mType = type;
    }
}

