/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.AndExpression;
import org.teatrove.tea.parsetree.ArithmeticExpression;
import org.teatrove.tea.parsetree.ArrayLookup;
import org.teatrove.tea.parsetree.AssignmentStatement;
import org.teatrove.tea.parsetree.BinaryExpression;
import org.teatrove.tea.parsetree.Block;
import org.teatrove.tea.parsetree.BooleanLiteral;
import org.teatrove.tea.parsetree.BreakStatement;
import org.teatrove.tea.parsetree.CallExpression;
import org.teatrove.tea.parsetree.CompareExpression;
import org.teatrove.tea.parsetree.ConcatenateExpression;
import org.teatrove.tea.parsetree.ContinueStatement;
import org.teatrove.tea.parsetree.ExceptionGuardStatement;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.ExpressionList;
import org.teatrove.tea.parsetree.ExpressionStatement;
import org.teatrove.tea.parsetree.ForeachStatement;
import org.teatrove.tea.parsetree.FunctionCallExpression;
import org.teatrove.tea.parsetree.IfStatement;
import org.teatrove.tea.parsetree.ImportDirective;
import org.teatrove.tea.parsetree.Lookup;
import org.teatrove.tea.parsetree.Name;
import org.teatrove.tea.parsetree.NegateExpression;
import org.teatrove.tea.parsetree.NewArrayExpression;
import org.teatrove.tea.parsetree.NoOpExpression;
import org.teatrove.tea.parsetree.NodeVisitor;
import org.teatrove.tea.parsetree.NotExpression;
import org.teatrove.tea.parsetree.NullLiteral;
import org.teatrove.tea.parsetree.NumberLiteral;
import org.teatrove.tea.parsetree.OrExpression;
import org.teatrove.tea.parsetree.ParenExpression;
import org.teatrove.tea.parsetree.RelationalExpression;
import org.teatrove.tea.parsetree.ReturnStatement;
import org.teatrove.tea.parsetree.SpreadExpression;
import org.teatrove.tea.parsetree.Statement;
import org.teatrove.tea.parsetree.StatementList;
import org.teatrove.tea.parsetree.StringLiteral;
import org.teatrove.tea.parsetree.SubstitutionStatement;
import org.teatrove.tea.parsetree.Template;
import org.teatrove.tea.parsetree.TemplateCallExpression;
import org.teatrove.tea.parsetree.TernaryExpression;
import org.teatrove.tea.parsetree.TypeExpression;
import org.teatrove.tea.parsetree.TypeName;
import org.teatrove.tea.parsetree.Variable;
import org.teatrove.tea.parsetree.VariableRef;

public abstract class TreeMutator
implements NodeVisitor {
    @Override
    public Object visit(Template node) {
        Statement stmt;
        node.getName().accept(this);
        Variable[] params = node.getParams();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                params[i] = (Variable)params[i].accept(this);
            }
        }
        if ((stmt = node.getStatement()) != null) {
            node.setStatement((Statement)stmt.accept(this));
        }
        return node;
    }

    @Override
    public Object visit(Name node) {
        return node;
    }

    @Override
    public Object visit(TypeName node) {
        return node;
    }

    @Override
    public Object visit(Variable node) {
        node.getTypeName().accept(this);
        return node;
    }

    @Override
    public Object visit(ExpressionList node) {
        Expression[] exprs = node.getExpressions();
        for (int i = 0; i < exprs.length; ++i) {
            exprs[i] = this.visitExpression(exprs[i]);
        }
        return node;
    }

    @Override
    public Object visit(Statement node) {
        return node;
    }

    @Override
    public Object visit(ImportDirective node) {
        return node;
    }

    @Override
    public Object visit(StatementList node) {
        Statement[] stmts = node.getStatements();
        if (stmts != null) {
            for (int i = 0; i < stmts.length; ++i) {
                stmts[i] = (Statement)stmts[i].accept(this);
            }
        }
        return node;
    }

    @Override
    public Object visit(Block node) {
        Statement init = node.getInitializer();
        if (init != null) {
            node.setInitializer((Statement)init.accept(this));
        }
        this.visit((StatementList)node);
        Statement fin = node.getFinalizer();
        if (fin != null) {
            node.setFinalizer((Statement)fin.accept(this));
        }
        return node;
    }

    @Override
    public Object visit(AssignmentStatement node) {
        node.getLValue().accept(this);
        node.setRValue(this.visitExpression(node.getRValue()));
        return node;
    }

    @Override
    public Object visit(BreakStatement node) {
        return node;
    }

    @Override
    public Object visit(ContinueStatement node) {
        return node;
    }

    @Override
    public Object visit(ForeachStatement node) {
        Block body;
        Statement init;
        node.getLoopVariable().accept(this);
        node.setRange(this.visitExpression(node.getRange()));
        Expression endRange = node.getEndRange();
        if (endRange != null) {
            node.setEndRange(this.visitExpression(endRange));
        }
        if ((init = node.getInitializer()) != null) {
            node.setInitializer((Statement)init.accept(this));
        }
        if ((body = node.getBody()) != null) {
            node.setBody(this.visitBlock(body));
        }
        return node;
    }

    @Override
    public Object visit(IfStatement node) {
        node.setCondition(this.visitExpression(node.getCondition()));
        Block block = node.getThenPart();
        if (block != null) {
            node.setThenPart(this.visitBlock(block));
        }
        if ((block = node.getElsePart()) != null) {
            node.setElsePart(this.visitBlock(block));
        }
        return node;
    }

    @Override
    public Object visit(SubstitutionStatement node) {
        return node;
    }

    @Override
    public Object visit(ExpressionStatement node) {
        node.setExpression(this.visitExpression(node.getExpression()));
        return node;
    }

    @Override
    public Object visit(ReturnStatement node) {
        Expression expr = node.getExpression();
        if (expr != null) {
            node.setExpression(this.visitExpression(node.getExpression()));
        }
        return node;
    }

    @Override
    public Object visit(ExceptionGuardStatement node) {
        node.setGuarded((Statement)node.getGuarded().accept(this));
        Statement stmt = node.getReplacement();
        if (stmt != null) {
            node.setReplacement((Statement)stmt.accept(this));
        }
        return node;
    }

    @Override
    public Object visit(Expression node) {
        return node;
    }

    @Override
    public Object visit(ParenExpression node) {
        node.setExpression(this.visitExpression(node.getExpression()));
        return node;
    }

    @Override
    public Object visit(NewArrayExpression node) {
        node.setExpressionList((ExpressionList)node.getExpressionList().accept(this));
        return node;
    }

    @Override
    public Object visit(FunctionCallExpression node) {
        return this.visit((CallExpression)node);
    }

    @Override
    public Object visit(TemplateCallExpression node) {
        return this.visit((CallExpression)node);
    }

    private Object visit(CallExpression node) {
        Block subParam;
        Expression expr = node.getExpression();
        if (expr != null) {
            node.setExpression((Expression)expr.accept(this));
        }
        node.setParams((ExpressionList)node.getParams().accept(this));
        Statement init = node.getInitializer();
        if (init != null) {
            node.setInitializer((Statement)init.accept(this));
        }
        if ((subParam = node.getSubstitutionParam()) != null) {
            node.setSubstitutionParam(this.visitBlock(subParam));
        }
        return node;
    }

    @Override
    public Object visit(VariableRef node) {
        Variable v = node.getVariable();
        if (v != null) {
            node.setVariable((Variable)v.accept(this));
        }
        return node;
    }

    @Override
    public Object visit(Lookup node) {
        node.setExpression(this.visitExpression(node.getExpression()));
        return node;
    }

    @Override
    public Object visit(ArrayLookup node) {
        node.setExpression(this.visitExpression(node.getExpression()));
        node.setLookupIndex(this.visitExpression(node.getLookupIndex()));
        return node;
    }

    @Override
    public Object visit(NegateExpression node) {
        node.setExpression(this.visitExpression(node.getExpression()));
        return node;
    }

    @Override
    public Object visit(NotExpression node) {
        node.setExpression(this.visitExpression(node.getExpression()));
        return node;
    }

    private Object visit(BinaryExpression node) {
        node.setLeftExpression(this.visitExpression(node.getLeftExpression()));
        node.setRightExpression(this.visitExpression(node.getRightExpression()));
        return node;
    }

    @Override
    public Object visit(ConcatenateExpression node) {
        return this.visit((BinaryExpression)node);
    }

    @Override
    public Object visit(ArithmeticExpression node) {
        return this.visit((BinaryExpression)node);
    }

    @Override
    public Object visit(RelationalExpression node) {
        if (node.getIsaTypeName() != null) {
            node.setLeftExpression(this.visitExpression(node.getLeftExpression()));
            node.getIsaTypeName().accept(this);
            return node;
        }
        return this.visit((BinaryExpression)node);
    }

    @Override
    public Object visit(AndExpression node) {
        return this.visit((BinaryExpression)node);
    }

    @Override
    public Object visit(OrExpression node) {
        return this.visit((BinaryExpression)node);
    }

    @Override
    public Object visit(TernaryExpression node) {
        node.setCondition(this.visitExpression(node.getCondition()));
        Expression block = node.getThenPart();
        if (block != null) {
            node.setThenPart(this.visitExpression(block));
        }
        if ((block = node.getElsePart()) != null) {
            node.setElsePart(this.visitExpression(block));
        }
        return node;
    }

    @Override
    public Object visit(CompareExpression node) {
        node.setLeftExpression((Expression)node.getLeftExpression().accept(this));
        node.setRightExpression((Expression)node.getRightExpression().accept(this));
        return node;
    }

    @Override
    public Object visit(NoOpExpression node) {
        return node;
    }

    @Override
    public Object visit(SpreadExpression node) {
        node.setExpression((Expression)node.getExpression().accept(this));
        node.setOperation((Expression)node.getOperation().accept(this));
        return node;
    }

    @Override
    public Object visit(TypeExpression node) {
        node.setTypeName((TypeName)node.getTypeName().accept(this));
        return node;
    }

    @Override
    public Object visit(NullLiteral node) {
        return node;
    }

    @Override
    public Object visit(BooleanLiteral node) {
        return node;
    }

    @Override
    public Object visit(StringLiteral node) {
        return node;
    }

    @Override
    public Object visit(NumberLiteral node) {
        return node;
    }

    protected Expression visitExpression(Expression expr) {
        Type newType;
        if (expr == null) {
            return null;
        }
        Expression newExpr = (Expression)expr.accept(this);
        if (!(expr == newExpr || (newType = newExpr.getType()) != null && newType.equals(expr.getType()))) {
            for (Expression.Conversion conv : expr.getConversionChain()) {
                newExpr.convertTo(conv.getToType(), conv.isCastPreferred());
            }
        }
        return newExpr;
    }

    protected Block visitBlock(Block block) {
        if (block == null) {
            return null;
        }
        Statement stmt = (Statement)block.accept(this);
        if (stmt instanceof Block) {
            return (Block)stmt;
        }
        if (stmt != null) {
            return new Block(stmt);
        }
        return new Block(block.getSourceInfo());
    }
}

