/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import org.teatrove.tea.parsetree.AndExpression;
import org.teatrove.tea.parsetree.ArithmeticExpression;
import org.teatrove.tea.parsetree.ArrayLookup;
import org.teatrove.tea.parsetree.AssignmentStatement;
import org.teatrove.tea.parsetree.BinaryExpression;
import org.teatrove.tea.parsetree.Block;
import org.teatrove.tea.parsetree.BooleanLiteral;
import org.teatrove.tea.parsetree.BreakStatement;
import org.teatrove.tea.parsetree.CallExpression;
import org.teatrove.tea.parsetree.CompareExpression;
import org.teatrove.tea.parsetree.ConcatenateExpression;
import org.teatrove.tea.parsetree.ContinueStatement;
import org.teatrove.tea.parsetree.ExceptionGuardStatement;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.ExpressionList;
import org.teatrove.tea.parsetree.ExpressionStatement;
import org.teatrove.tea.parsetree.ForeachStatement;
import org.teatrove.tea.parsetree.FunctionCallExpression;
import org.teatrove.tea.parsetree.IfStatement;
import org.teatrove.tea.parsetree.ImportDirective;
import org.teatrove.tea.parsetree.Lookup;
import org.teatrove.tea.parsetree.Name;
import org.teatrove.tea.parsetree.NegateExpression;
import org.teatrove.tea.parsetree.NewArrayExpression;
import org.teatrove.tea.parsetree.NoOpExpression;
import org.teatrove.tea.parsetree.NodeVisitor;
import org.teatrove.tea.parsetree.NotExpression;
import org.teatrove.tea.parsetree.NullLiteral;
import org.teatrove.tea.parsetree.NumberLiteral;
import org.teatrove.tea.parsetree.OrExpression;
import org.teatrove.tea.parsetree.ParenExpression;
import org.teatrove.tea.parsetree.RelationalExpression;
import org.teatrove.tea.parsetree.ReturnStatement;
import org.teatrove.tea.parsetree.SpreadExpression;
import org.teatrove.tea.parsetree.Statement;
import org.teatrove.tea.parsetree.StatementList;
import org.teatrove.tea.parsetree.StringLiteral;
import org.teatrove.tea.parsetree.SubstitutionStatement;
import org.teatrove.tea.parsetree.Template;
import org.teatrove.tea.parsetree.TemplateCallExpression;
import org.teatrove.tea.parsetree.TernaryExpression;
import org.teatrove.tea.parsetree.TypeExpression;
import org.teatrove.tea.parsetree.TypeName;
import org.teatrove.tea.parsetree.Variable;
import org.teatrove.tea.parsetree.VariableRef;

public abstract class TreeWalker
implements NodeVisitor {
    @Override
    public Object visit(Template node) {
        Statement stmt;
        node.getName().accept(this);
        Variable[] params = node.getParams();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                params[i].accept(this);
            }
        }
        if ((stmt = node.getStatement()) != null) {
            stmt.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(Name node) {
        return null;
    }

    @Override
    public Object visit(TypeName node) {
        return null;
    }

    @Override
    public Object visit(Variable node) {
        node.getTypeName().accept(this);
        return null;
    }

    @Override
    public Object visit(ExpressionList node) {
        Expression[] exprs = node.getExpressions();
        for (int i = 0; i < exprs.length; ++i) {
            exprs[i].accept(this);
        }
        return null;
    }

    @Override
    public Object visit(Statement node) {
        return null;
    }

    @Override
    public Object visit(ImportDirective node) {
        return null;
    }

    @Override
    public Object visit(StatementList node) {
        Statement[] stmts = node.getStatements();
        if (stmts != null) {
            for (int i = 0; i < stmts.length; ++i) {
                stmts[i].accept(this);
            }
        }
        return null;
    }

    @Override
    public Object visit(Block node) {
        Statement init = node.getInitializer();
        if (init != null) {
            init.accept(this);
        }
        this.visit((StatementList)node);
        Statement fin = node.getFinalizer();
        if (fin != null) {
            fin.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(AssignmentStatement node) {
        node.getLValue().accept(this);
        node.getRValue().accept(this);
        return null;
    }

    @Override
    public Object visit(BreakStatement node) {
        return null;
    }

    @Override
    public Object visit(ContinueStatement node) {
        return null;
    }

    @Override
    public Object visit(ForeachStatement node) {
        Block body;
        Statement init;
        node.getLoopVariable().accept(this);
        node.getRange().accept(this);
        Expression endRange = node.getEndRange();
        if (endRange != null) {
            endRange.accept(this);
        }
        if ((init = node.getInitializer()) != null) {
            init.accept(this);
        }
        if ((body = node.getBody()) != null) {
            body.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(IfStatement node) {
        node.getCondition().accept(this);
        Block block = node.getThenPart();
        if (block != null) {
            block.accept(this);
        }
        if ((block = node.getElsePart()) != null) {
            block.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(SubstitutionStatement node) {
        return null;
    }

    @Override
    public Object visit(ExpressionStatement node) {
        node.getExpression().accept(this);
        return null;
    }

    @Override
    public Object visit(ReturnStatement node) {
        Expression expr = node.getExpression();
        if (expr != null) {
            expr.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(ExceptionGuardStatement node) {
        Statement stmt = node.getGuarded();
        if (stmt != null) {
            stmt.accept(this);
        }
        if ((stmt = node.getReplacement()) != null) {
            stmt.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(Expression node) {
        return null;
    }

    @Override
    public Object visit(ParenExpression node) {
        node.getExpression().accept(this);
        return null;
    }

    @Override
    public Object visit(NewArrayExpression node) {
        node.getExpressionList().accept(this);
        return null;
    }

    @Override
    public Object visit(FunctionCallExpression node) {
        return this.visit((CallExpression)node);
    }

    @Override
    public Object visit(TemplateCallExpression node) {
        return this.visit((CallExpression)node);
    }

    private Object visit(CallExpression node) {
        Block subParam;
        Expression expr = node.getExpression();
        if (expr != null) {
            expr.accept(this);
        }
        node.getParams().accept(this);
        Statement init = node.getInitializer();
        if (init != null) {
            init.accept(this);
        }
        if ((subParam = node.getSubstitutionParam()) != null) {
            subParam.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(VariableRef node) {
        Variable v = node.getVariable();
        if (v != null) {
            v.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(Lookup node) {
        node.getExpression().accept(this);
        return null;
    }

    @Override
    public Object visit(ArrayLookup node) {
        node.getExpression().accept(this);
        node.getLookupIndex().accept(this);
        return null;
    }

    @Override
    public Object visit(NegateExpression node) {
        node.getExpression().accept(this);
        return null;
    }

    @Override
    public Object visit(NotExpression node) {
        node.getExpression().accept(this);
        return null;
    }

    private Object visit(BinaryExpression node) {
        node.getLeftExpression().accept(this);
        node.getRightExpression().accept(this);
        return null;
    }

    @Override
    public Object visit(ConcatenateExpression node) {
        return this.visit((BinaryExpression)node);
    }

    @Override
    public Object visit(ArithmeticExpression node) {
        return this.visit((BinaryExpression)node);
    }

    @Override
    public Object visit(RelationalExpression node) {
        if (node.getIsaTypeName() != null) {
            node.getLeftExpression().accept(this);
            node.getIsaTypeName().accept(this);
            return null;
        }
        return this.visit((BinaryExpression)node);
    }

    @Override
    public Object visit(AndExpression node) {
        return this.visit((BinaryExpression)node);
    }

    @Override
    public Object visit(OrExpression node) {
        return this.visit((BinaryExpression)node);
    }

    @Override
    public Object visit(TernaryExpression node) {
        node.getCondition().accept(this);
        Expression block = node.getThenPart();
        if (block != null) {
            block.accept(this);
        }
        if ((block = node.getElsePart()) != null) {
            block.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(CompareExpression node) {
        node.getLeftExpression().accept(this);
        node.getRightExpression().accept(this);
        return null;
    }

    @Override
    public Object visit(NoOpExpression node) {
        return null;
    }

    @Override
    public Object visit(TypeExpression node) {
        node.getTypeName().accept(this);
        return null;
    }

    @Override
    public Object visit(SpreadExpression node) {
        node.getExpression().accept(this);
        node.getOperation().accept(this);
        return null;
    }

    @Override
    public Object visit(NullLiteral node) {
        return null;
    }

    @Override
    public Object visit(BooleanLiteral node) {
        return null;
    }

    @Override
    public Object visit(StringLiteral node) {
        return null;
    }

    @Override
    public Object visit(NumberLiteral node) {
        return null;
    }
}

