/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.Name;
import org.teatrove.tea.parsetree.NodeVisitor;

public class TypeName
extends Name {
    private static final long serialVersionUID = 1L;
    private int mDimensions;
    private Type mType;
    private TypeName[] mGenericTypes;

    public TypeName(SourceInfo info, String name) {
        super(info, name);
    }

    public TypeName(SourceInfo info, String name, TypeName[] genericTypes) {
        super(info, name);
        this.mGenericTypes = genericTypes;
    }

    public TypeName(SourceInfo info, String name, int dimensions) {
        super(info, name);
        this.mDimensions = dimensions;
    }

    public TypeName(SourceInfo info, String name, TypeName[] genericTypes, int dimensions) {
        super(info, name);
        this.mGenericTypes = genericTypes;
        this.mDimensions = dimensions;
    }

    public TypeName(SourceInfo info, Name name) {
        super(info, name.getName());
    }

    public TypeName(SourceInfo info, Name name, TypeName[] genericTypes) {
        super(info, name.getName());
        this.mGenericTypes = genericTypes;
    }

    public TypeName(SourceInfo info, Name name, int dimensions) {
        super(info, name.getName());
        this.mDimensions = dimensions;
    }

    public TypeName(SourceInfo info, Name name, TypeName[] genericTypes, int dimensions) {
        super(info, name.getName());
        this.mDimensions = dimensions;
        this.mGenericTypes = genericTypes;
    }

    public TypeName(SourceInfo info, Type type) {
        super(info, type == null ? "" : type.getNaturalClass().getName());
        this.mType = type;
        this.mDimensions = -1;
    }

    public TypeName(SourceInfo info, TypeName[] genericTypes, Type type) {
        super(info, type == null ? "" : type.getNaturalClass().getName());
        this.mType = type;
        this.mDimensions = -1;
        this.mGenericTypes = genericTypes;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    public TypeName[] getGenericTypes() {
        return this.mGenericTypes;
    }

    public int getDimensions() {
        if (this.mDimensions < 0 && this.mType != null) {
            Class<?> clazz = this.mType.getNaturalClass();
            int dim = 0;
            while (clazz.isArray()) {
                ++dim;
                clazz = clazz.getComponentType();
            }
            this.mDimensions = dim;
        }
        return this.mDimensions;
    }

    public Type getType() {
        return this.mType;
    }

    public void setType(Type type) {
        this.mType = type;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.getDimensions();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TypeName && super.equals(other)) {
            boolean valid = false;
            valid = this.mType == null ? null == ((TypeName)other).getType() : this.mType.equals(((TypeName)other).getType());
            if (!valid) {
                return false;
            }
            TypeName[] genericTypes = ((TypeName)other).getGenericTypes();
            if (this.mGenericTypes == null) {
                valid = null == genericTypes;
            } else if (genericTypes == null) {
                valid = false;
            } else if (genericTypes.length != this.mGenericTypes.length) {
                valid = false;
            } else {
                valid = true;
                for (int i = 0; i < genericTypes.length && (valid = this.mGenericTypes[i].equals(genericTypes[i])); ++i) {
                }
            }
            return valid;
        }
        return false;
    }
}

