/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.parsetree;

import java.lang.reflect.ParameterizedType;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.Node;
import org.teatrove.tea.parsetree.NodeVisitor;
import org.teatrove.tea.parsetree.TypeName;
import org.teatrove.trove.generics.GenericType;

public class Variable
extends Node {
    private static final long serialVersionUID = 1L;
    private String mName;
    private TypeName mTypeName;
    private Type mType;
    private boolean mField;
    private boolean mStatic;
    private boolean mTransient;
    private boolean mStaticallyTyped;

    public Variable(SourceInfo info, String name, TypeName typeName) {
        super(info);
        this.mName = name;
        this.mTypeName = typeName;
        this.mStaticallyTyped = false;
    }

    public Variable(SourceInfo info, String name, TypeName typeName, boolean staticallyTyped) {
        super(info);
        this.mName = name;
        this.mTypeName = typeName;
        this.mStaticallyTyped = staticallyTyped;
    }

    public Variable(SourceInfo info, String name, Type type) {
        super(info);
        this.mName = name;
        this.mTypeName = this.createTypeName(info, type);
        this.mType = type;
    }

    public Variable(SourceInfo info, String name, Type type, boolean staticallyTyped) {
        super(info);
        this.mName = name;
        this.mTypeName = this.createTypeName(info, type);
        this.mType = type;
        this.mStaticallyTyped = staticallyTyped;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visit(this);
    }

    public TypeName getTypeName() {
        return this.mTypeName;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public Type getType() {
        return this.mType;
    }

    public void setType(Type type) {
        this.mType = Type.preserveType(this.mType, type);
        this.mTypeName = this.mTypeName == null ? this.createTypeName(this.getSourceInfo(), type) : this.createTypeName(this.mTypeName.getSourceInfo(), type);
    }

    public boolean isField() {
        return this.mField;
    }

    public boolean isStaticallyTyped() {
        return this.mStaticallyTyped;
    }

    public boolean isStatic() {
        return this.mStatic;
    }

    public boolean isTransient() {
        return this.mTransient;
    }

    public void setField(boolean b) {
        this.mField = b;
        if (!b) {
            this.mStatic = false;
        }
    }

    public void setStatic(boolean b) {
        this.mStatic = b;
        if (b) {
            this.mField = true;
        }
    }

    public void setTransient(boolean b) {
        this.mTransient = b;
    }

    public int hashCode() {
        return this.mName.hashCode() + this.mTypeName.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Variable) {
            Variable v = (Variable)other;
            return this.mName.equals(v.mName) && this.mTypeName.equals(v.mTypeName);
        }
        return false;
    }

    private TypeName createTypeName(SourceInfo info, Type type) {
        TypeName[] genericTypes = null;
        if (type.getGenericClass() instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type.getGenericClass();
            genericTypes = new TypeName[ptype.getActualTypeArguments().length];
            for (int i = 0; i < ptype.getActualTypeArguments().length; ++i) {
                java.lang.reflect.Type gtype = ptype.getActualTypeArguments()[i];
                genericTypes[i] = this.createTypeName(this.getSourceInfo(), new Type(new GenericType(gtype)));
            }
        }
        return new TypeName(info, genericTypes, type);
    }

    @Override
    public String toString() {
        String className = Object.class.getName();
        Type type = this.getType();
        if (type != null) {
            className = type.getClassName();
        } else {
            TypeName typeName = this.getTypeName();
            type = typeName.getType();
            if (type != null) {
                className = type.getClassName();
            } else {
                String name = typeName.getName();
                if (name != null) {
                    className = name;
                }
            }
        }
        return "Variable(" + className + " " + this.getName() + ")";
    }
}

