/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.runtime;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.teatrove.tea.runtime.UtilityContext;
import org.teatrove.trove.util.BeanComparator;
import org.teatrove.trove.util.DecimalFormat;
import org.teatrove.trove.util.Pair;
import org.teatrove.trove.util.StringReplacer;

public abstract class DefaultContext
extends Writer
implements UtilityContext {
    private static final String DEFAULT_NULL_FORMAT = "null";
    private static final String[] INT_VALUES = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99"};
    private static final int FIRST_INT_VALUE = 0;
    private static final int LAST_INT_VALUE = 99;
    private static Map<Locale, Locale> cLocaleCache = Collections.synchronizedMap(new HashMap(7));
    private static Map<Object, DecimalFormat> cDecimalFormatCache = Collections.synchronizedMap(new HashMap(47));
    private Locale mLocale;
    private String mNullFormat = "null";
    private DecimalFormat mDecimalFormat;
    private DateTimeFormatter mDateTimeFormatter;
    private DateTimeZone mDateTimeZone;
    private String mDateTimePattern;

    @Override
    public void write(int c) throws IOException {
        try {
            this.print(String.valueOf((char)c));
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IOException(e.toString());
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        try {
            if (cbuf == null) {
                this.print(this.mNullFormat);
            } else {
                this.print(new String(cbuf, off, len));
            }
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IOException(e.toString());
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public abstract void print(Object var1) throws Exception;

    @Override
    public void print(Date date) throws Exception {
        if (date == null) {
            this.write(this.mNullFormat);
        } else {
            if (this.mDateTimeFormatter == null) {
                this.dateFormat(null);
            }
            this.mDateTimeFormatter.printTo((Writer)this, date.getTime());
        }
    }

    @Override
    public void print(ReadableInstant instant) throws Exception {
        if (instant == null) {
            this.write(this.mNullFormat);
        } else {
            if (this.mDateTimeFormatter == null) {
                this.dateFormat(null);
            }
            this.mDateTimeFormatter.printTo((Writer)this, instant.getMillis());
        }
    }

    @Override
    public void print(Number n) throws Exception {
        this.print(this.toString(n));
    }

    @Override
    public void print(int n) throws Exception {
        this.print(this.toString(n));
    }

    @Override
    public void print(float n) throws Exception {
        this.print(this.toString(n));
    }

    @Override
    public void print(long n) throws Exception {
        this.print(this.toString(n));
    }

    @Override
    public void print(double n) throws Exception {
        this.print(this.toString(n));
    }

    @Override
    public String toString(Object obj) {
        if (obj == null) {
            return this.mNullFormat;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Date) {
            return this.toString((Date)obj);
        }
        if (obj instanceof Number) {
            return this.toString((Number)obj);
        }
        if (obj instanceof ReadableInstant) {
            return this.toString((ReadableInstant)obj);
        }
        String str = obj.toString();
        return str == null ? this.mNullFormat : str;
    }

    @Override
    public String toString(String str) {
        return str == null ? this.mNullFormat : str;
    }

    @Override
    public String toString(Date date) {
        if (date == null) {
            return this.mNullFormat;
        }
        if (this.mDateTimeFormatter == null) {
            this.dateFormat(null);
        }
        return this.mDateTimeFormatter.print(date.getTime());
    }

    @Override
    public String toString(ReadableInstant instant) {
        if (instant == null) {
            return this.mNullFormat;
        }
        if (this.mDateTimeFormatter == null) {
            this.dateFormat(null);
        }
        return this.mDateTimeFormatter.print(instant.getMillis());
    }

    @Override
    public String toString(Number n) {
        if (n == null) {
            return this.mNullFormat;
        }
        if (this.mDecimalFormat == null) {
            if (n instanceof Integer) {
                return this.toString((Integer)n);
            }
            if (n instanceof Long) {
                return this.toString((Long)n);
            }
            return n.toString();
        }
        if (n instanceof Integer) {
            return this.mDecimalFormat.format(n.intValue());
        }
        if (n instanceof Double) {
            return this.mDecimalFormat.format(n.doubleValue());
        }
        if (n instanceof Float) {
            return this.mDecimalFormat.format(n.floatValue());
        }
        if (n instanceof Long) {
            return this.mDecimalFormat.format(n.longValue());
        }
        return this.mDecimalFormat.format(n.doubleValue());
    }

    @Override
    public String toString(int n) {
        if (this.mDecimalFormat == null) {
            if (n <= 99 && n >= 0) {
                return INT_VALUES[n];
            }
            return Integer.toString(n);
        }
        return this.mDecimalFormat.format(n);
    }

    @Override
    public String toString(float n) {
        return this.mDecimalFormat == null ? Float.toString(n) : this.mDecimalFormat.format(n);
    }

    @Override
    public String toString(long n) {
        if (this.mDecimalFormat == null) {
            if (n <= 99L && n >= 0L) {
                return INT_VALUES[(int)n];
            }
            return Long.toString(n);
        }
        return this.mDecimalFormat.format(n);
    }

    @Override
    public String toString(double n) {
        return this.mDecimalFormat == null ? Double.toString(n) : this.mDecimalFormat.format(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            this.mLocale = null;
            this.mDateTimeFormatter = null;
            this.mDecimalFormat = null;
        } else {
            Map<Locale, Locale> map = cLocaleCache;
            synchronized (map) {
                Locale cached = cLocaleCache.get(locale);
                if (cached == null) {
                    cLocaleCache.put(locale, locale);
                } else {
                    locale = cached;
                }
            }
            this.mLocale = locale;
            this.dateFormat(null);
            this.numberFormat(null);
        }
    }

    @Override
    public void setLocale(String language, String country) {
        this.setLocale(new Locale(language, country));
    }

    @Override
    public void setLocale(String language, String country, String variant) {
        this.setLocale(new Locale(language, country, variant));
    }

    @Override
    public Locale getLocale() {
        return this.mLocale;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return Locale.getAvailableLocales();
    }

    @Override
    public void nullFormat(String format) {
        this.mNullFormat = format == null ? DEFAULT_NULL_FORMAT : format;
    }

    @Override
    public String getNullFormat() {
        return this.mNullFormat;
    }

    @Override
    public void dateFormat(String format) {
        this.dateFormat(format, null);
    }

    @Override
    public void dateFormat(String format, String timeZoneID) {
        DateTimeZone zone = timeZoneID != null ? DateTimeZone.forID((String)timeZoneID) : DateTimeZone.getDefault();
        this.mDateTimeZone = zone;
        if (format == null) {
            format = DateTimeFormat.patternForStyle((String)"LL", (Locale)this.mLocale);
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format).withZone(zone);
        if (this.mLocale != null) {
            formatter = formatter.withLocale(this.mLocale);
        }
        this.mDateTimeFormatter = formatter;
        this.mDateTimePattern = format;
    }

    @Override
    public String getDateFormat() {
        if (this.mDateTimeFormatter == null) {
            this.dateFormat(null);
        }
        return this.mDateTimePattern;
    }

    @Override
    public String getDateFormatTimeZone() {
        DateTimeZone zone;
        if (this.mDateTimeFormatter == null) {
            this.dateFormat(null);
        }
        return (zone = this.mDateTimeZone) == null ? null : zone.getID();
    }

    @Override
    public TimeZone[] getAvailableTimeZones() {
        String[] IDs = TimeZone.getAvailableIDs();
        TimeZone[] zones = new TimeZone[IDs.length];
        int i = zones.length;
        while (--i >= 0) {
            zones[i] = TimeZone.getTimeZone(IDs[i]);
        }
        return zones;
    }

    @Override
    public void numberFormat(String format) {
        this.numberFormat(format, null, null);
    }

    @Override
    public void numberFormat(String format, String infinity, String NaN) {
        if (format == null && infinity == null && NaN == null) {
            this.mDecimalFormat = this.mLocale == null ? null : DecimalFormat.getInstance((Locale)this.mLocale);
            return;
        }
        String key = format;
        if (this.mLocale != null) {
            key = new Pair((Object)key, (Object)this.mLocale);
        }
        if (infinity != null || NaN != null) {
            key = new Pair((Object)key, (Object)infinity);
            key = new Pair((Object)key, (Object)NaN);
        }
        if ((this.mDecimalFormat = cDecimalFormatCache.get(key)) == null) {
            this.mDecimalFormat = DecimalFormat.getInstance((String)format, (Locale)this.mLocale);
            if (infinity != null) {
                this.mDecimalFormat = this.mDecimalFormat.setInfinity(infinity);
            }
            if (NaN != null) {
                this.mDecimalFormat = this.mDecimalFormat.setNaN(NaN);
            }
            cDecimalFormatCache.put(key, this.mDecimalFormat);
        }
    }

    @Override
    public String getNumberFormat() {
        return this.mDecimalFormat == null ? null : this.mDecimalFormat.getPattern();
    }

    @Override
    public String getNumberFormatInfinity() {
        return this.mDecimalFormat == null ? null : this.mDecimalFormat.getInfinity();
    }

    @Override
    public String getNumberFormatNaN() {
        return this.mDecimalFormat == null ? null : this.mDecimalFormat.getNaN();
    }

    @Override
    public Date currentDate() {
        return new Date();
    }

    @Override
    public DateTime currentDateTime() {
        return new DateTime();
    }

    @Override
    public boolean startsWith(String str, String prefix) {
        return str == null || prefix == null ? str == prefix : str.startsWith(prefix);
    }

    @Override
    public boolean endsWith(String str, String suffix) {
        return str == null || suffix == null ? str == suffix : str.endsWith(suffix);
    }

    @Override
    public int[] find(String str, String search) {
        return this.find(str, search, 0);
    }

    @Override
    public int[] find(String str, String search, int fromIndex) {
        int[] newArray;
        if (str == null || search == null) {
            return new int[0];
        }
        int[] indices = new int[10];
        int size = 0;
        int index = fromIndex;
        while ((index = str.indexOf(search, index)) >= 0) {
            if (size >= indices.length) {
                newArray = new int[indices.length * 2];
                System.arraycopy(indices, 0, newArray, 0, indices.length);
                indices = newArray;
            }
            indices[size++] = index;
            index += search.length();
        }
        if (size < indices.length) {
            newArray = new int[size];
            System.arraycopy(indices, 0, newArray, 0, size);
            indices = newArray;
        }
        return indices;
    }

    @Override
    public int findFirst(String str, String search) {
        return str == null || search == null ? -1 : str.indexOf(search);
    }

    @Override
    public int findFirst(String str, String search, int fromIndex) {
        return str == null || search == null ? -1 : str.indexOf(search, fromIndex);
    }

    @Override
    public int findLast(String str, String search) {
        return str == null || search == null ? -1 : str.lastIndexOf(search);
    }

    @Override
    public int findLast(String str, String search, int fromIndex) {
        return str == null || search == null ? -1 : str.lastIndexOf(search, fromIndex);
    }

    @Override
    public String substring(String str, int startIndex) {
        return str == null ? null : str.substring(startIndex);
    }

    @Override
    public String substring(String str, int startIndex, int endIndex) {
        return str == null ? null : str.substring(startIndex, endIndex);
    }

    @Override
    public String toLowerCase(String str) {
        return str == null ? null : str.toLowerCase();
    }

    @Override
    public String toUpperCase(String str) {
        return str == null ? null : str.toUpperCase();
    }

    @Override
    public String trim(String str) {
        return str == null ? null : str.trim();
    }

    @Override
    public String trimLeading(String str) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) <= ' ') continue;
            return str.substring(i);
        }
        return "";
    }

    @Override
    public String trimTrailing(String str) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        for (int i = length - 1; i >= 0; --i) {
            if (str.charAt(i) <= ' ') continue;
            return str.substring(0, i + 1);
        }
        return "";
    }

    @Override
    public String shortOrdinal(Long n) {
        return n == null ? null : this.shortOrdinal((long)n);
    }

    @Override
    public String shortOrdinal(long n) {
        String str = Long.toString(n);
        if (n < 0L) {
            n = -n;
        }
        if ((n %= 100L) >= 10L && n <= 20L) {
            str = str + "th";
        } else {
            if (n > 20L) {
                n %= 10L;
            }
            switch ((int)n) {
                case 1: {
                    str = str + "st";
                    break;
                }
                case 2: {
                    str = str + "nd";
                    break;
                }
                case 3: {
                    str = str + "rd";
                    break;
                }
                default: {
                    str = str + "th";
                }
            }
        }
        return str;
    }

    @Override
    public String ordinal(Long n) {
        return n == null ? null : this.ordinal((long)n);
    }

    @Override
    public String ordinal(long n) {
        if (n == 0L) {
            return "zeroth";
        }
        StringBuffer buf = new StringBuffer(20);
        if (n < 0L) {
            buf.append("negative ");
            n = -n;
        }
        n = DefaultContext.cardinalGroup(buf, n, 1000000000000000000L, "quintillion");
        n = DefaultContext.cardinalGroup(buf, n, 1000000000000000L, "quadrillion");
        n = DefaultContext.cardinalGroup(buf, n, 1000000000000L, "trillion");
        n = DefaultContext.cardinalGroup(buf, n, 1000000000L, "billion");
        n = DefaultContext.cardinalGroup(buf, n, 1000000L, "million");
        if ((n = DefaultContext.cardinalGroup(buf, n, 1000L, "thousand")) == 0L) {
            buf.append("th");
        } else {
            DefaultContext.cardinal999(buf, n, true);
        }
        return buf.toString();
    }

    @Override
    public String cardinal(Long n) {
        return n == null ? null : this.cardinal((long)n);
    }

    @Override
    public String cardinal(long n) {
        if (n == 0L) {
            return "zero";
        }
        StringBuffer buf = new StringBuffer(20);
        if (n < 0L) {
            buf.append("negative ");
            n = -n;
        }
        n = DefaultContext.cardinalGroup(buf, n, 1000000000000000000L, "quintillion");
        n = DefaultContext.cardinalGroup(buf, n, 1000000000000000L, "quadrillion");
        n = DefaultContext.cardinalGroup(buf, n, 1000000000000L, "trillion");
        n = DefaultContext.cardinalGroup(buf, n, 1000000000L, "billion");
        n = DefaultContext.cardinalGroup(buf, n, 1000000L, "million");
        n = DefaultContext.cardinalGroup(buf, n, 1000L, "thousand");
        DefaultContext.cardinal999(buf, n, false);
        return buf.toString();
    }

    private static long cardinalGroup(StringBuffer buf, long n, long threshold, String groupName) {
        if (n >= threshold) {
            DefaultContext.cardinal999(buf, n / threshold, false);
            buf.append(' ');
            buf.append(groupName);
            if ((n %= threshold) >= 100L) {
                buf.append(", ");
            } else if (n != 0L) {
                buf.append(" and ");
            }
        }
        return n;
    }

    private static void cardinal999(StringBuffer buf, long n, boolean ordinal) {
        if ((n = DefaultContext.cardinalGroup(buf, n, 100L, "hundred")) == 0L) {
            if (ordinal) {
                buf.append("th");
            }
            return;
        }
        if (n >= 20L) {
            switch ((int)n / 10) {
                case 2: {
                    buf.append("twen");
                    break;
                }
                case 3: {
                    buf.append("thir");
                    break;
                }
                case 4: {
                    buf.append("for");
                    break;
                }
                case 5: {
                    buf.append("fif");
                    break;
                }
                case 6: {
                    buf.append("six");
                    break;
                }
                case 7: {
                    buf.append("seven");
                    break;
                }
                case 8: {
                    buf.append("eigh");
                    break;
                }
                case 9: {
                    buf.append("nine");
                }
            }
            if ((n %= 10L) != 0L) {
                buf.append("ty-");
            } else if (!ordinal) {
                buf.append("ty");
            } else {
                buf.append("tieth");
            }
        }
        switch ((int)n) {
            case 1: {
                if (!ordinal) {
                    buf.append("one");
                    break;
                }
                buf.append("first");
                break;
            }
            case 2: {
                if (!ordinal) {
                    buf.append("two");
                    break;
                }
                buf.append("second");
                break;
            }
            case 3: {
                if (!ordinal) {
                    buf.append("three");
                    break;
                }
                buf.append("third");
                break;
            }
            case 4: {
                if (!ordinal) {
                    buf.append("four");
                    break;
                }
                buf.append("fourth");
                break;
            }
            case 5: {
                if (!ordinal) {
                    buf.append("five");
                    break;
                }
                buf.append("fifth");
                break;
            }
            case 6: {
                if (!ordinal) {
                    buf.append("six");
                    break;
                }
                buf.append("sixth");
                break;
            }
            case 7: {
                if (!ordinal) {
                    buf.append("seven");
                    break;
                }
                buf.append("seventh");
                break;
            }
            case 8: {
                if (!ordinal) {
                    buf.append("eight");
                    break;
                }
                buf.append("eighth");
                break;
            }
            case 9: {
                if (!ordinal) {
                    buf.append("nine");
                    break;
                }
                buf.append("ninth");
                break;
            }
            case 10: {
                if (!ordinal) {
                    buf.append("ten");
                    break;
                }
                buf.append("tenth");
                break;
            }
            case 11: {
                if (!ordinal) {
                    buf.append("eleven");
                    break;
                }
                buf.append("eleventh");
                break;
            }
            case 12: {
                if (!ordinal) {
                    buf.append("twelve");
                    break;
                }
                buf.append("twelfth");
                break;
            }
            case 13: {
                buf.append("thirteen");
                if (!ordinal) break;
                buf.append("th");
                break;
            }
            case 14: {
                buf.append("fourteen");
                if (!ordinal) break;
                buf.append("th");
                break;
            }
            case 15: {
                buf.append("fifteen");
                if (!ordinal) break;
                buf.append("th");
                break;
            }
            case 16: {
                buf.append("sixteen");
                if (!ordinal) break;
                buf.append("th");
                break;
            }
            case 17: {
                buf.append("seventeen");
                if (!ordinal) break;
                buf.append("th");
                break;
            }
            case 18: {
                buf.append("eighteen");
                if (!ordinal) break;
                buf.append("th");
                break;
            }
            case 19: {
                buf.append("nineteen");
                if (!ordinal) break;
                buf.append("th");
            }
        }
    }

    @Override
    public String replace(String source, String pattern, String replacement) {
        return this.replace(source, pattern, replacement, 0);
    }

    @Override
    public String replace(String source, String pattern, String replacement, int fromIndex) {
        if (replacement == null) {
            replacement = this.toString(replacement);
        }
        return StringReplacer.replace((String)source, (String)pattern, (String)replacement, (int)fromIndex);
    }

    @Override
    public <K, V> String replace(String source, Map<K, V> patternReplacements) {
        if (source == null) {
            return null;
        }
        int mapSize = patternReplacements.size();
        String[] patterns = new String[mapSize];
        String[] replacements = new String[mapSize];
        Iterator<Map.Entry<K, V>> it = patternReplacements.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<K, V> entry = it.next();
            patterns[i] = this.toString(entry.getKey());
            replacements[i] = this.toString(entry.getValue());
            ++i;
        }
        return StringReplacer.replace((String)source, (String[])patterns, (String[])replacements);
    }

    @Override
    public String replaceFirst(String source, String pattern, String replacement) {
        if (replacement == null) {
            replacement = this.toString(replacement);
        }
        return StringReplacer.replaceFirst((String)source, (String)pattern, (String)replacement);
    }

    @Override
    public String replaceFirst(String source, String pattern, String replacement, int fromIndex) {
        if (replacement == null) {
            replacement = this.toString(replacement);
        }
        return StringReplacer.replaceFirst((String)source, (String)pattern, (String)replacement, (int)fromIndex);
    }

    @Override
    public String replaceLast(String source, String pattern, String replacement) {
        if (replacement == null) {
            replacement = this.toString(replacement);
        }
        return StringReplacer.replaceLast((String)source, (String)pattern, (String)replacement);
    }

    @Override
    public String replaceLast(String source, String pattern, String replacement, int fromIndex) {
        if (replacement == null) {
            replacement = this.toString(replacement);
        }
        return StringReplacer.replaceLast((String)source, (String)pattern, (String)replacement, (int)fromIndex);
    }

    @Override
    public boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    @Override
    public void sort(Object[] array, String onColumn, boolean reverse) {
        Class objClass = DefaultContext.getObjectClass(array);
        if (objClass != null) {
            DefaultContext.sort(array, objClass, onColumn, reverse);
        }
    }

    @Override
    public void sort(Object[] array, String[] onColumns, boolean[] reverse) {
        Class arrayType = DefaultContext.getObjectClass(array);
        if (arrayType != null) {
            DefaultContext.sort(array, arrayType, onColumns, reverse);
        }
    }

    @Override
    public void sort(String[] array, boolean reverse, boolean ignoreCase) {
        StringComparator comparator = new StringComparator(reverse, ignoreCase);
        Arrays.sort(array, comparator);
    }

    @Override
    public void sort(Object[] array, boolean sortAscending) {
        Class arrayType = DefaultContext.getObjectClass(array);
        if (arrayType != null) {
            Comparator<String> comparator = null;
            if (arrayType == String.class) {
                comparator = new StringComparator(sortAscending, false);
            } else if (Comparable.class.isAssignableFrom(arrayType)) {
                comparator = new GenericComparator(sortAscending);
            }
            if (comparator != null) {
                Arrays.sort(array, comparator);
            } else {
                System.err.println("Sorting arrays of type " + arrayType.getName() + " is not supported, " + "must implement Comparable.");
            }
        } else {
            System.err.println("Could not determine type of array to sort.");
        }
    }

    @Override
    public void sortAscending(Object[] array) {
        Arrays.sort(array);
    }

    @Override
    public void sortAscending(int[] array) {
        Arrays.sort(array);
    }

    @Override
    public void sortAscending(double[] array) {
        Arrays.sort(array);
    }

    @Override
    public void sortAscending(float[] array) {
        Arrays.sort(array);
    }

    @Override
    public void sortAscending(byte[] array) {
        Arrays.sort(array);
    }

    @Override
    public void sortAscending(short[] array) {
        Arrays.sort(array);
    }

    @Override
    public void sortAscending(long[] array) {
        Arrays.sort(array);
    }

    private static void sort(Object[] array, Class arrayType, String onColumn, boolean reverse) {
        BeanComparator comparator = BeanComparator.forClass((Class)arrayType);
        if (onColumn != null && !onColumn.equals("")) {
            comparator = comparator.orderBy(onColumn);
        }
        if (reverse) {
            comparator = comparator.reverse();
        }
        Arrays.sort(array, comparator);
    }

    private static void sort(Object[] array, Class arrayType, String[] onColumns, boolean[] reverse) {
        BeanComparator comparator = BeanComparator.forClass((Class)arrayType);
        for (int i = 0; i < onColumns.length; ++i) {
            comparator = comparator.orderBy(onColumns[i]);
            if (!reverse[i]) continue;
            comparator = comparator.reverse();
        }
        Arrays.sort(array, comparator);
    }

    @Override
    public String[] split(String str, String regex) {
        return str.split(regex);
    }

    @Override
    public StringBuilder createStringBuilder() {
        return new StringBuilder();
    }

    @Override
    public StringBuilder createStringBuilder(int size) {
        return new StringBuilder(size);
    }

    @Override
    public void append(StringBuilder buffer, Object value) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        buffer.append(value);
    }

    @Override
    public void prepend(StringBuilder buffer, Object value) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        buffer.insert(0, value);
    }

    @Override
    public void insert(StringBuilder buffer, Object value, int index) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        buffer.insert(index, value);
    }

    @Override
    public String toString(StringBuilder buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        return buffer.toString();
    }

    private static Class getObjectClass(Object[] array) {
        Class<?> result = null;
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) continue;
                result = array[i].getClass();
                break;
            }
        }
        return result;
    }

    public static class StringComparator
    implements Comparator<String> {
        protected boolean sortAscending = true;
        protected boolean ignoreCase = true;

        public StringComparator(boolean sortAscending, boolean ignoreCase) {
            this.sortAscending = sortAscending;
            this.ignoreCase = ignoreCase;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(String s1, String s2) {
            if (s1 != null) {
                if (s2 != null) {
                    int flag = 0;
                    flag = this.ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
                    if (flag > 0) {
                        if (!this.sortAscending) return -1;
                        return 1;
                    }
                    if (flag >= 0) return 0;
                    if (!this.sortAscending) return 1;
                    return -1;
                }
                if (!this.sortAscending) return -1;
                return 1;
            }
            if (s2 == null) return 0;
            if (!this.sortAscending) return 1;
            return -1;
        }
    }

    public static class GenericComparator
    implements Comparator<Comparable> {
        protected boolean sortAscending = true;

        public GenericComparator(boolean sortAscending) {
            this.sortAscending = sortAscending;
        }

        @Override
        public int compare(Comparable k1, Comparable k2) {
            if (k1 != null) {
                if (k2 != null) {
                    int result = k1.compareTo(k2);
                    return this.sortAscending ? result : -result;
                }
                return this.sortAscending ? 1 : -1;
            }
            if (k2 != null) {
                return this.sortAscending ? -1 : 1;
            }
            return 0;
        }
    }
}

