/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.teatrove.tea.runtime.Context;

public class TemplateLoader {
    private ClassLoader mBaseLoader;
    private String mPackagePrefix;
    private Map<String, Template> mTemplates;

    public TemplateLoader() {
        this(null);
    }

    public TemplateLoader(String packagePrefix) {
        this.init(this.getClass().getClassLoader(), packagePrefix);
    }

    public TemplateLoader(ClassLoader baseLoader, String packagePrefix) {
        this.init(baseLoader, packagePrefix);
    }

    private void init(ClassLoader baseLoader, String packagePrefix) {
        this.mBaseLoader = baseLoader;
        if (packagePrefix == null) {
            packagePrefix = "";
        } else if (!packagePrefix.endsWith(".")) {
            packagePrefix = packagePrefix + '.';
        }
        this.mPackagePrefix = packagePrefix.trim();
        this.mTemplates = new HashMap<String, Template>();
    }

    public final synchronized Template getTemplate(String name) throws ClassNotFoundException, NoSuchMethodException, LinkageError {
        Template template = this.mTemplates.get(name);
        if (template == null) {
            template = this.loadTemplate(name);
            this.mTemplates.put(name, template);
        }
        return template;
    }

    public final synchronized Template[] getLoadedTemplates() {
        return this.mTemplates.values().toArray(new Template[this.mTemplates.size()]);
    }

    protected Template loadTemplate(String name) throws ClassNotFoundException, NoSuchMethodException, LinkageError {
        return new TemplateImpl(name, this.mBaseLoader.loadClass(this.mPackagePrefix + name));
    }

    private class TemplateImpl
    implements Template {
        private String mName;
        private Class<?> mClass;
        private transient Method mExecuteMethod;
        private transient Class<?> mReturnType;
        private transient String[] mParameterNames;
        private transient Class<?>[] mParameterTypes;

        private TemplateImpl(String name, Class<?> clazz) throws NoSuchMethodException {
            this.mName = name;
            this.mClass = clazz;
            this.doReflection();
        }

        @Override
        public TemplateLoader getTemplateLoader() {
            return TemplateLoader.this;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public Class<?> getTemplateClass() {
            return this.mClass;
        }

        @Override
        public Class<?> getContextType() {
            return this.mExecuteMethod.getParameterTypes()[0];
        }

        @Override
        public String[] getParameterNames() {
            return (String[])this.mParameterNames.clone();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return (Class[])this.mParameterTypes.clone();
        }

        @Override
        public void execute(Context context, Object[] parameters) throws Exception {
            int length = parameters.length;
            Object[] args = new Object[1 + length];
            args[0] = context;
            for (int i = 0; i < length; ++i) {
                args[i + 1] = parameters[i];
            }
            try {
                Object ret = this.mExecuteMethod.invoke(null, args);
                if (this.mReturnType != Void.TYPE) {
                    context.print(ret);
                }
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw e;
            }
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(80);
            buf.append("template ");
            buf.append(this.getName());
            buf.append('(');
            buf.append(this.getContextType().getName());
            String[] paramNames = this.getParameterNames();
            Class<?>[] paramTypes = this.getParameterTypes();
            int length = paramTypes.length;
            for (int i = 0; i < length; ++i) {
                buf.append(", ");
                buf.append(paramTypes[i].getName());
                if (paramNames[i] == null) continue;
                buf.append(' ');
                buf.append(paramNames[i]);
            }
            buf.append(')');
            return buf.toString();
        }

        private void doReflection() throws NoSuchMethodException {
            Method[] methods = this.getTemplateClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getName().equals("execute") || !Modifier.isStatic(m.getModifiers())) continue;
                this.mExecuteMethod = m;
                break;
            }
            if (this.mExecuteMethod == null) {
                throw new NoSuchMethodException("No execute method found in class for template \"" + this.getName() + "\"");
            }
            this.mReturnType = this.mExecuteMethod.getReturnType();
            Class<?>[] methodParams = this.mExecuteMethod.getParameterTypes();
            if (methodParams.length == 0 || !Context.class.isAssignableFrom(methodParams[0])) {
                throw new NoSuchMethodException("Execute method does not accept a context for template \"" + this.getName() + "\"");
            }
            int length = methodParams.length - 1;
            this.mParameterNames = new String[length];
            this.mParameterTypes = new Class[length];
            for (int i = 0; i < length; ++i) {
                this.mParameterTypes[i] = methodParams[i + 1];
            }
            try {
                Method namesMethod = this.getTemplateClass().getMethod("getTemplateParameterNames", new Class[0]);
                String[] names = (String[])namesMethod.invoke(null, new Object[0]);
                if (names != null) {
                    for (int i = 0; i < length; ++i) {
                        this.mParameterNames[i] = names[i];
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static interface Template {
        public TemplateLoader getTemplateLoader();

        public String getName();

        public Class<?> getTemplateClass();

        public Class<?> getContextType();

        public String[] getParameterNames();

        public Class<?>[] getParameterTypes();

        public void execute(Context var1, Object[] var2) throws Exception;

        public String toString();
    }
}

