/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.runtime;

import org.teatrove.trove.util.IntegerFactory;

public class WrapperTypeConversionUtil {
    public static Number convert(Number from, Class<?> toType) {
        if (toType == Integer.class || toType == Integer.TYPE) {
            return WrapperTypeConversionUtil.toInteger(from);
        }
        if (toType == Double.class || toType == Double.TYPE) {
            return WrapperTypeConversionUtil.toDouble(from);
        }
        if (toType == Long.class || toType == Long.TYPE) {
            return WrapperTypeConversionUtil.toLong(from);
        }
        if (toType == Short.class || toType == Short.TYPE) {
            return WrapperTypeConversionUtil.toShort(from);
        }
        if (toType == Float.class || toType == Float.TYPE) {
            return WrapperTypeConversionUtil.toFloat(from);
        }
        if (toType == Byte.class || toType == Byte.TYPE) {
            return WrapperTypeConversionUtil.toByte(from);
        }
        return from;
    }

    public static Integer toInteger(Number value) {
        return value != null ? IntegerFactory.toInteger((int)value.intValue()) : null;
    }

    public static Integer toInteger(Boolean value) {
        return value != null ? IntegerFactory.toInteger((int)(value != false ? 1 : 0)) : null;
    }

    public static Integer toInteger(Character value) {
        return value != null ? IntegerFactory.toInteger((int)value.charValue()) : null;
    }

    public static Integer toInteger(String value) {
        try {
            return value != null ? IntegerFactory.toInteger((int)Integer.parseInt(value)) : null;
        }
        catch (NumberFormatException nx) {
            return null;
        }
    }

    public static Double toDouble(Number value) {
        return value != null ? new Double(value.doubleValue()) : null;
    }

    public static Long toLong(Number value) {
        return value != null ? new Long(value.longValue()) : null;
    }

    public static Short toShort(Number value) {
        return value != null ? new Short(value.shortValue()) : null;
    }

    public static Float toFloat(Number value) {
        return value != null ? new Float(value.floatValue()) : null;
    }

    public static Byte toByte(Number value) {
        return value != null ? new Byte(value.byteValue()) : null;
    }
}

