/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.teatrove.tea.compiler.CompilationUnit;
import org.teatrove.tea.compiler.Compiler;
import org.teatrove.tea.compiler.TemplateRepository;
import org.teatrove.tea.parsetree.Template;
import org.teatrove.trove.io.DualOutput;
import org.teatrove.trove.util.ClassInjector;

public abstract class AbstractCompiler
extends Compiler {
    protected String mRootPackage;
    protected File mRootDestDir;
    protected ClassInjector mInjector;
    protected String mEncoding;
    protected boolean mForce;
    protected long mPrecompiledTolerance;

    public AbstractCompiler(ClassInjector injector) {
        this(injector, null);
    }

    public AbstractCompiler(ClassInjector injector, String rootPackage) {
        this(injector, rootPackage, (Map<String, Template>)null);
    }

    public AbstractCompiler(ClassInjector injector, String rootPackage, Map<String, Template> parseTreeMap) {
        this(injector, rootPackage, null, null, parseTreeMap);
    }

    public AbstractCompiler(ClassInjector injector, String rootPackage, File rootDestDir) {
        this(injector, rootPackage, rootDestDir, null);
    }

    public AbstractCompiler(ClassInjector injector, String rootPackage, File rootDestDir, String encoding) {
        this(injector, rootPackage, rootDestDir, encoding, null);
    }

    public AbstractCompiler(ClassInjector injector, String rootPackage, File rootDestDir, String encoding, Map<String, Template> parseTreeMap) {
        this(injector, rootPackage, rootDestDir, encoding, 0L, parseTreeMap);
    }

    public AbstractCompiler(ClassInjector injector, String rootPackage, File rootDestDir, String encoding, long precompiledTolerance, Map<String, Template> parseTreeMap) {
        super(parseTreeMap == null ? Collections.synchronizedMap(new HashMap()) : parseTreeMap);
        this.mInjector = injector;
        this.mRootPackage = rootPackage;
        this.mRootDestDir = rootDestDir;
        this.mInjector = injector;
        this.mEncoding = encoding;
        this.mPrecompiledTolerance = precompiledTolerance;
        if (this.mRootDestDir != null && !this.mRootDestDir.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory: " + rootDestDir);
        }
        if (!TemplateRepository.isInitialized()) {
            TemplateRepository.init(rootDestDir, rootPackage);
        }
    }

    public void setForceCompile(boolean force) {
        this.mForce = force;
    }

    public String getRootPackage() {
        return this.mRootPackage;
    }

    @Override
    public String[] compile(String[] names) throws IOException {
        if (!TemplateRepository.isInitialized()) {
            return super.compile(names);
        }
        String[] compNames = super.compile(names);
        ArrayList<String> compList = new ArrayList<String>(Arrays.asList(compNames));
        TemplateRepository rep = TemplateRepository.getInstance();
        String[] callers = rep.getCallersNeedingRecompile(compNames, this);
        if (callers.length > 0) {
            compList.addAll(Arrays.asList(super.compile(callers)));
        }
        String[] compiled = compList.toArray(new String[compList.size()]);
        try {
            rep.update(compiled);
        }
        catch (Exception e) {
            System.err.println("Unable to update repository");
            e.printStackTrace(System.err);
        }
        return compiled;
    }

    public String[] compileAll() throws IOException {
        return this.compile(this.getAllTemplateNames());
    }

    public abstract String[] getAllTemplateNames() throws IOException;

    public abstract class AbstractUnit
    extends CompilationUnit {
        protected String mSourceFilePath;
        protected String mSourceFileName;
        protected String mDotPath;
        protected File mDestDir;
        protected File mDestFile;

        protected AbstractUnit(String name, Compiler compiler) {
            super(name, compiler);
            this.mDotPath = name;
            String slashPath = name.replace('.', '/');
            if (slashPath.endsWith("/")) {
                slashPath = slashPath.substring(0, slashPath.length() - 1);
            }
            if (AbstractCompiler.this.mRootDestDir != null) {
                this.mDestDir = slashPath.lastIndexOf(47) >= 0 ? new File(AbstractCompiler.this.mRootDestDir, slashPath.substring(0, slashPath.lastIndexOf(47))) : AbstractCompiler.this.mRootDestDir;
                this.mDestDir.mkdirs();
                this.mDestFile = new File(this.mDestDir, slashPath.substring(slashPath.lastIndexOf(47) + 1) + ".class");
            }
            this.mSourceFilePath = slashPath;
            this.mSourceFileName = slashPath.concat(".tea");
        }

        @Override
        public String getTargetPackage() {
            return AbstractCompiler.this.mRootPackage;
        }

        @Override
        public String getSourceFileName() {
            return this.mSourceFileName;
        }

        @Override
        public Reader getReader() throws IOException {
            InputStreamReader reader = null;
            InputStream in = this.getTemplateSource(this.mDotPath);
            reader = AbstractCompiler.this.mEncoding == null ? new InputStreamReader(in) : new InputStreamReader(in, AbstractCompiler.this.mEncoding);
            return reader;
        }

        @Override
        public boolean shouldCompile() {
            return AbstractCompiler.this.mForce || this.shouldCompile(this.getDestinationLastModified());
        }

        protected boolean shouldCompile(long timestamp) {
            if (AbstractCompiler.this.mForce || this.mDestFile != null && !this.mDestFile.exists()) {
                return true;
            }
            long lastModified = this.getLastModified();
            return timestamp <= 0L || lastModified <= 0L || !this.gteq(timestamp, lastModified, AbstractCompiler.this.mPrecompiledTolerance);
        }

        protected abstract long getLastModified();

        protected long getDestinationLastModified() {
            if (this.mDestFile != null && this.mDestFile.exists()) {
                return this.mDestFile.lastModified();
            }
            return 0L;
        }

        private boolean gteq(long a, long b, long tolerance) {
            return a >= b - tolerance;
        }

        public File getDestinationFile() {
            return this.mDestFile;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            FileOutputStream out1 = null;
            OutputStream out2 = null;
            if (this.mDestDir != null) {
                if (!this.mDestDir.exists()) {
                    this.mDestDir.mkdirs();
                }
                out1 = new FileOutputStream(this.mDestFile);
            }
            if (AbstractCompiler.this.mInjector != null) {
                String className = this.getName();
                String pack = this.getTargetPackage();
                if (pack != null && pack.length() > 0) {
                    className = pack + '.' + className;
                }
                out2 = AbstractCompiler.this.mInjector.getStream(className);
            }
            Object out = out1 != null ? (out2 != null ? new DualOutput((OutputStream)out1, out2) : out1) : (out2 != null ? out2 : new OutputStream(){

                @Override
                public void write(int b) {
                }

                @Override
                public void write(byte[] b, int off, int len) {
                }
            });
            return new BufferedOutputStream((OutputStream)out);
        }

        @Override
        public void resetOutputStream() {
            if (this.mDestFile != null) {
                this.mDestFile.delete();
            }
            if (AbstractCompiler.this.mInjector != null) {
                AbstractCompiler.this.mInjector.resetStream(this.getClassName());
            }
        }

        protected String getClassName() {
            return this.getClassName(null);
        }

        protected String getClassName(String innerClass) {
            String className = this.getName();
            String pack = this.getTargetPackage();
            if (pack != null && pack.length() > 0) {
                className = pack + '.' + className;
            }
            if (innerClass != null) {
                className = className + '$' + innerClass;
            }
            return className;
        }

        protected abstract InputStream getTemplateSource(String var1) throws IOException;
    }
}

