/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.teatrove.tea.util.KeyedPropertyDescriptor;
import org.teatrove.trove.generics.GenericType;
import org.teatrove.trove.util.IdentityMap;

public class BeanAnalyzer {
    public static final String LENGTH_PROPERTY_NAME = "length";
    public static final String KEYED_PROPERTY_NAME = "[]";
    public static final String ELEMENT_TYPE_FIELD_NAME = "ELEMENT_TYPE";
    private static Map<GenericType, Map<String, PropertyDescriptor>> cPropertiesCache;

    private static Map<GenericType, Map<String, PropertyDescriptor>> createPropertiesCache() {
        return Collections.synchronizedMap(new IdentityMap(32768));
    }

    public static void main(String[] args) throws Exception {
        Map<String, PropertyDescriptor> map = BeanAnalyzer.getAllProperties(new GenericType(Class.forName(args[0])));
        for (String key : map.keySet()) {
            PropertyDescriptor desc = map.get(key);
            System.out.println(key + " = " + desc);
        }
    }

    public static Map<String, PropertyDescriptor> getAllProperties(GenericType root) throws IntrospectionException {
        Map<String, PropertyDescriptor> properties = cPropertiesCache.get(root);
        if (properties == null) {
            GenericType rootType = root.getRootType();
            if (rootType == null) {
                rootType = root;
            }
            properties = Collections.unmodifiableMap(BeanAnalyzer.createProperties(rootType, root));
            cPropertiesCache.put(root, properties);
        }
        return properties;
    }

    private static Map<String, PropertyDescriptor> createProperties(GenericType root, GenericType type) throws IntrospectionException {
        Method readMethod;
        int i;
        BeanInfo info;
        HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
        Class clazz = type.getRawType().getType();
        if (clazz == null || clazz.isPrimitive()) {
            return properties;
        }
        try {
            info = Introspector.getBeanInfo(clazz);
        }
        catch (LinkageError e) {
            throw new IntrospectionException(e.toString());
        }
        if (info != null) {
            PropertyDescriptor[] pdArray = info.getPropertyDescriptors();
            int length = pdArray.length;
            for (i = 0; i < length; ++i) {
                PropertyDescriptor desc = pdArray[i];
                if (desc.getPropertyType() == null) continue;
                properties.put(desc.getName(), desc);
            }
        }
        if (clazz.isInterface()) {
            properties.putAll(BeanAnalyzer.getAllProperties(new GenericType(Object.class)));
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        Type[] generics = clazz.getGenericInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            properties.putAll(BeanAnalyzer.getAllProperties(new GenericType(interfaces[i], generics[i])));
        }
        if (clazz.isArray()) {
            ArrayLengthProperty property = new ArrayLengthProperty(clazz);
            properties.put(LENGTH_PROPERTY_NAME, property);
        }
        if (String.class.isAssignableFrom(clazz)) {
            try {
                readMethod = String.class.getMethod(LENGTH_PROPERTY_NAME, new Class[0]);
                PropertyDescriptor property = new PropertyDescriptor(LENGTH_PROPERTY_NAME, readMethod, null);
                properties.put(LENGTH_PROPERTY_NAME, property);
            }
            catch (NoSuchMethodException e) {
                throw new LinkageError(e.toString());
            }
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            try {
                readMethod = Collection.class.getMethod("size", new Class[0]);
                PropertyDescriptor property = new PropertyDescriptor(LENGTH_PROPERTY_NAME, readMethod, null);
                properties.put(LENGTH_PROPERTY_NAME, property);
            }
            catch (NoSuchMethodException e) {
                throw new LinkageError(e.toString());
            }
        }
        if (Map.class.isAssignableFrom(clazz)) {
            try {
                readMethod = Map.class.getMethod("size", new Class[0]);
                PropertyDescriptor property = new PropertyDescriptor(LENGTH_PROPERTY_NAME, readMethod, null);
                properties.put(LENGTH_PROPERTY_NAME, property);
            }
            catch (NoSuchMethodException e) {
                throw new LinkageError(e.toString());
            }
        }
        KeyedPropertyDescriptor keyed = new KeyedPropertyDescriptor();
        ArrayList<Method> keyedMethods = new ArrayList<Method>();
        if (type.isArray()) {
            keyed.setKeyedPropertyType(type.getComponentType());
            keyedMethods.add(null);
        }
        Method[] methods = clazz.getMethods();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Class<?>[] params;
            Class<?> ret;
            Method m = methods[i2];
            if (!Modifier.isPublic(m.getModifiers()) || !"get".equals(m.getName()) || (ret = m.getReturnType()) == null || ret == Void.TYPE || (params = m.getParameterTypes()).length != 1) continue;
            GenericType retType = new GenericType(root, m.getReturnType(), m.getGenericReturnType());
            keyed.setKeyedPropertyType(retType);
            keyedMethods.add(m);
        }
        if (keyedMethods.size() == 0) {
            if (Vector.class.isAssignableFrom(clazz)) {
                try {
                    Method m = Vector.class.getMethod("elementAt", Integer.TYPE);
                    keyed.setKeyedPropertyType(new GenericType(root, m.getReturnType(), m.getGenericReturnType()));
                    keyedMethods.add(m);
                }
                catch (NoSuchMethodException e) {
                    throw new LinkageError(e.toString());
                }
            }
            if (String.class.isAssignableFrom(clazz)) {
                try {
                    Method m = String.class.getMethod("charAt", Integer.TYPE);
                    keyed.setKeyedPropertyType(new GenericType(root, m.getReturnType(), m.getGenericReturnType()));
                    keyedMethods.add(m);
                }
                catch (NoSuchMethodException e) {
                    throw new LinkageError(e.toString());
                }
            }
        }
        if (keyedMethods.size() > 0) {
            try {
                Field field = clazz.getField(ELEMENT_TYPE_FIELD_NAME);
                if (field.getType() == Class.class && Modifier.isStatic(field.getModifiers())) {
                    Class elementType = (Class)field.get(null);
                    if (keyed.getKeyedPropertyType().getRawType().getType().isAssignableFrom(elementType)) {
                        keyed.setKeyedPropertyType(new GenericType(elementType));
                    }
                }
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            properties.put(KEYED_PROPERTY_NAME, keyed);
            int size = keyedMethods.size();
            keyed.setKeyedReadMethods(keyedMethods.toArray(new Method[size]));
        }
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String propertyName = (String)it.next();
            if (propertyName.indexOf(36) < 0) continue;
            it.remove();
        }
        return properties;
    }

    static {
        Introspector.setBeanInfoSearchPath(new String[0]);
        cPropertiesCache = BeanAnalyzer.createPropertiesCache();
    }

    private static class ArrayLengthProperty
    extends PropertyDescriptor {
        public ArrayLengthProperty(Class<?> clazz) throws IntrospectionException {
            super(BeanAnalyzer.LENGTH_PROPERTY_NAME, clazz, null, null);
        }

        @Override
        public Class<?> getPropertyType() {
            return Integer.TYPE;
        }
    }
}

