/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.teatrove.tea.compiler.CompilationUnit;
import org.teatrove.tea.compiler.Compiler;
import org.teatrove.tea.compiler.ErrorEvent;
import org.teatrove.tea.compiler.ErrorListener;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.runtime.DefaultContext;
import org.teatrove.tea.runtime.UtilityContext;
import org.teatrove.tea.util.FileCompiler;

public class CallRetrofitter {
    public static void main(String[] args) throws Exception {
        int changeCount;
        if (args == null || args.length == 0) {
            CallRetrofitter.usage();
            return;
        }
        Class context = null;
        String encoding = null;
        File rootDir = null;
        ArrayList<String> templates = new ArrayList<String>(args.length);
        try {
            boolean parsingOptions = true;
            int i = 0;
            while (i < args.length) {
                String arg;
                if ((arg = args[i++]).startsWith("-") && parsingOptions) {
                    if (arg.equals("-context") && context == null) {
                        context = Class.forName(args[i++]);
                        continue;
                    }
                    if (arg.equals("-encoding") && encoding == null) {
                        encoding = args[i++];
                        continue;
                    }
                } else {
                    if (parsingOptions) {
                        parsingOptions = false;
                        rootDir = new File(arg);
                        continue;
                    }
                    arg = arg.replace('/', '.');
                    arg = arg.replace(File.separatorChar, '.');
                    while (arg.startsWith(".")) {
                        arg = arg.substring(1);
                    }
                    while (arg.endsWith(".")) {
                        arg = arg.substring(0, arg.length() - 1);
                    }
                    templates.add(arg);
                    continue;
                }
                CallRetrofitter.usage();
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            CallRetrofitter.usage();
            return;
        }
        if (rootDir == null) {
            CallRetrofitter.usage();
            return;
        }
        if (context == null) {
            context = UtilityContext.class;
        }
        int totalChangeCount = 0;
        do {
            String[] names;
            FileCompiler compiler = new FileCompiler(rootDir, null, null, null, encoding);
            compiler.setRuntimeContext(context);
            compiler.setForceCompile(true);
            compiler.setCodeGenerationEnabled(false);
            Retrofitter retrofitter = new Retrofitter(compiler, encoding);
            compiler.addErrorListener(retrofitter);
            if (templates.size() == 0) {
                names = compiler.compileAll(true);
            } else {
                names = templates.toArray(new String[templates.size()]);
                names = compiler.compile(names);
            }
            retrofitter.applyChanges();
            changeCount = retrofitter.getChangeCount();
            int errorCount = compiler.getErrorCount() - changeCount;
            String msg = String.valueOf(errorCount) + " error";
            if (errorCount != 1) {
                msg = msg + 's';
            }
            System.out.println(msg);
            System.out.println("Total changes made: " + (totalChangeCount += changeCount));
        } while (changeCount > 0);
    }

    private static void usage() {
        String usageDetail = " -context <class>     Specify a runtime context class to compile against.\n -encoding <encoding> Specify character encoding used by source files.\n";
        System.out.print("\nUsage: ");
        System.out.print("java ");
        System.out.print(CallRetrofitter.class.getName());
        System.out.println(" {options} <template root directory> {templates}");
        System.out.println();
        System.out.println("where {options} includes:");
        System.out.println(usageDetail);
    }

    private static class Retrofitter
    extends DefaultContext
    implements ErrorListener {
        private Compiler mCompiler;
        private String mEncoding;
        private Map<File, List<ErrorEvent>> mChanges;
        private int mChangeCount;

        private Retrofitter(Compiler c, String encoding) {
            this.mCompiler = c;
            this.mEncoding = encoding;
            this.mChanges = new TreeMap<File, List<ErrorEvent>>();
        }

        @Override
        public void compileError(ErrorEvent e) {
            if ("Can't find function".equalsIgnoreCase(e.getErrorMessage())) {
                File sourceFile = ((FileCompiler.Unit)e.getCompilationUnit()).getSourceFile();
                List<ErrorEvent> errorEvents = this.mChanges.get(sourceFile);
                if (errorEvents == null) {
                    errorEvents = new ArrayList<ErrorEvent>();
                    this.mChanges.put(sourceFile, errorEvents);
                }
                errorEvents.add(e);
            }
        }

        public int getChangeCount() {
            return this.mChangeCount;
        }

        public void applyChanges() throws IOException {
            for (Map.Entry<File, List<ErrorEvent>> entry : this.mChanges.entrySet()) {
                this.applyChanges(entry.getKey(), entry.getValue());
            }
            this.mChanges = null;
        }

        private void applyChanges(File sourceFile, List<ErrorEvent> errorEvents) throws IOException {
            int c;
            RandomAccessFile raf = new RandomAccessFile(sourceFile, "r");
            HashMap<String, String> replacements = new HashMap<String, String>();
            for (ErrorEvent event : errorEvents) {
                String templateName;
                boolean templateExists;
                SourceInfo info = event.getSourceInfo();
                CompilationUnit sourceUnit = event.getCompilationUnit();
                int startPos = info.getStartPosition();
                int endPos = info.getEndPosition();
                int len = endPos - startPos + 1;
                byte[] bytes = new byte[len];
                raf.seek(startPos);
                raf.readFully(bytes);
                String text = this.mEncoding == null ? new String(bytes) : new String(bytes, this.mEncoding);
                int index = text.indexOf(40);
                if (index <= 0 || !(templateExists = this.mCompiler.getCompilationUnit(templateName = text.substring(0, index).trim(), sourceUnit) != null)) continue;
                ++this.mChangeCount;
                replacements.put(text, "call " + text);
            }
            raf.close();
            if (replacements.size() <= 0) {
                return;
            }
            this.print("Modifying: " + sourceFile);
            FileInputStream in = new FileInputStream(sourceFile);
            Reader reader = this.mEncoding == null ? new InputStreamReader(in) : new InputStreamReader((InputStream)in, this.mEncoding);
            reader = new BufferedReader(reader);
            StringBuffer sourceContents = new StringBuffer((int)sourceFile.length());
            while ((c = reader.read()) != -1) {
                sourceContents.append((char)c);
            }
            reader.close();
            String newContents = this.replace(sourceContents.toString(), replacements);
            FileOutputStream out = new FileOutputStream(sourceFile);
            Writer writer = this.mEncoding == null ? new OutputStreamWriter(out) : new OutputStreamWriter((OutputStream)out, this.mEncoding);
            writer = new BufferedWriter(writer);
            writer.write(newContents);
            writer.close();
        }

        @Override
        public void print(Object obj) {
            System.out.println(this.toString(obj));
        }
    }
}

