/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import org.teatrove.tea.compiler.CompilationUnit;
import org.teatrove.tea.compiler.ErrorEvent;
import org.teatrove.tea.compiler.ErrorListener;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.trove.io.LinePositionReader;

public class ConsoleErrorReporter
implements ErrorListener {
    private PrintStream mOut;
    private LinePositionReader mPositionReader;
    private CompilationUnit mPositionReaderUnit;

    public ConsoleErrorReporter(PrintStream out) {
        this.mOut = out;
    }

    public void close() throws IOException {
        if (this.mPositionReader != null) {
            this.mPositionReader.close();
        }
        this.mPositionReader = null;
        this.mPositionReaderUnit = null;
    }

    @Override
    public void compileError(ErrorEvent e) {
        this.mOut.println(e.getDetailedErrorMessage());
        SourceInfo info = e.getSourceInfo();
        CompilationUnit unit = e.getCompilationUnit();
        try {
            if (unit != null && info != null) {
                int line = info.getLine();
                int start = info.getStartPosition();
                int end = info.getEndPosition();
                if (this.mPositionReader == null || this.mPositionReaderUnit != unit || this.mPositionReader.getLineNumber() >= line) {
                    this.mPositionReaderUnit = unit;
                    this.mPositionReader = new LinePositionReader((Reader)new BufferedReader(unit.getReader()));
                }
                this.mPositionReader.skipForwardToLine(line);
                int position = this.mPositionReader.getNextPosition();
                String lineStr = this.mPositionReader.readLine();
                lineStr = LinePositionReader.cleanWhitespace((String)lineStr);
                this.mOut.println(lineStr);
                int indentSize = start - position;
                String indent = LinePositionReader.createSequence((char)' ', (int)indentSize);
                int markerSize = end - start + 1;
                String marker = LinePositionReader.createSequence((char)'^', (int)markerSize);
                this.mOut.print(indent);
                this.mOut.println(marker);
                this.mOut.println();
            }
        }
        catch (IOException ex) {
            Thread t = Thread.currentThread();
            t.getThreadGroup().uncaughtException(t, ex);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

