/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.teatrove.tea.compiler.CompilationUnit;
import org.teatrove.tea.compiler.Compiler;
import org.teatrove.tea.compiler.TemplateRepository;
import org.teatrove.tea.parsetree.Template;
import org.teatrove.tea.runtime.UtilityContext;
import org.teatrove.tea.util.AbstractCompiler;
import org.teatrove.tea.util.ConsoleErrorReporter;
import org.teatrove.trove.util.ClassInjector;

public class FileCompiler
extends AbstractCompiler {
    private File[] mRootSourceDirs;
    private Map<File, JarOfTemplates> mSrcJars;

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            FileCompiler.usage();
            return;
        }
        Class context = null;
        File destDir = null;
        boolean force = false;
        String rootPackage = null;
        String encoding = null;
        boolean guardian = false;
        File rootDir = null;
        ArrayList<String> templates = new ArrayList<String>(args.length);
        try {
            boolean parsingOptions = true;
            int i = 0;
            while (i < args.length) {
                String arg;
                if ((arg = args[i++]).startsWith("-") && parsingOptions) {
                    if (arg.equals("-context") && context == null) {
                        context = Class.forName(args[i++]);
                        continue;
                    }
                    if (arg.equals("-dest") && destDir == null) {
                        destDir = new File(args[i++]);
                        continue;
                    }
                    if (arg.equals("-force") && !force) {
                        force = true;
                        continue;
                    }
                    if (arg.equals("-package") && rootPackage == null) {
                        rootPackage = args[i++];
                        continue;
                    }
                    if (arg.equals("-encoding") && encoding == null) {
                        encoding = args[i++];
                        continue;
                    }
                    if (arg.equals("-guardian") && !guardian) {
                        guardian = true;
                        continue;
                    }
                } else {
                    if (parsingOptions) {
                        parsingOptions = false;
                        rootDir = new File(arg);
                        continue;
                    }
                    arg = arg.replace('/', '.');
                    arg = arg.replace(File.separatorChar, '.');
                    while (arg.startsWith(".")) {
                        arg = arg.substring(1);
                    }
                    while (arg.endsWith(".")) {
                        arg = arg.substring(0, arg.length() - 1);
                    }
                    templates.add(arg);
                    continue;
                }
                FileCompiler.usage();
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            FileCompiler.usage();
            return;
        }
        if (rootDir == null) {
            FileCompiler.usage();
            return;
        }
        if (context == null) {
            context = UtilityContext.class;
        }
        if (destDir == null) {
            destDir = rootDir;
        }
        FileCompiler compiler = new FileCompiler(rootDir, rootPackage, destDir, null, encoding);
        compiler.setRuntimeContext(context);
        compiler.setForceCompile(force);
        compiler.addErrorListener(new ConsoleErrorReporter(System.out));
        compiler.setExceptionGuardianEnabled(guardian);
        if (templates.size() == 0) {
            String[] names = compiler.compileAll(true);
        } else {
            String[] names = templates.toArray(new String[templates.size()]);
            names = compiler.compile(names);
        }
        int errorCount = compiler.getErrorCount();
        if (errorCount > 0) {
            String msg = String.valueOf(errorCount) + " error";
            if (errorCount != 1) {
                msg = msg + 's';
            }
            System.out.println(msg);
            System.exit(1);
        }
    }

    private static void usage() {
        String usageDetail = " -context <class>     Specify a runtime context class to compile against.\n -dest <directory>    Specify where to place generated class files.\n -force               Compile all templates, even if up-to-date.\n -package <package>   Root package to compile templates into.\n -encoding <encoding> Specify character encoding used by source files.\n -guardian            Enable the exception guardian.";
        System.out.print("\nUsage: ");
        System.out.print("java ");
        System.out.print(FileCompiler.class.getName());
        System.out.println(" {options} <template root directory> {templates}");
        System.out.println();
        System.out.println("where {options} includes:");
        System.out.println(usageDetail);
    }

    public FileCompiler(File rootSourceDir, String rootPackage, File rootDestDir, ClassInjector injector) {
        this(new File[]{rootSourceDir}, rootPackage, rootDestDir, injector, null);
    }

    public FileCompiler(File rootSourceDir, String rootPackage, File rootDestDir, ClassInjector injector, String encoding) {
        this(new File[]{rootSourceDir}, rootPackage, rootDestDir, injector, encoding);
    }

    public FileCompiler(File[] rootSourceDirs, String rootPackage, File rootDestDir, ClassInjector injector) {
        this(rootSourceDirs, rootPackage, rootDestDir, injector, null);
    }

    public FileCompiler(File[] rootSourceDirs, String rootPackage, File rootDestDir, ClassInjector injector, String encoding) {
        super(injector, rootPackage);
        this.init(rootSourceDirs, rootDestDir, encoding);
    }

    public FileCompiler(File[] rootSourceDirs, String rootPackage, File rootDestDir, ClassInjector injector, String encoding, Map<String, Template> parseTreeMap) {
        super(injector, rootPackage, parseTreeMap);
        this.init(rootSourceDirs, rootDestDir, encoding);
    }

    private JarOfTemplates getJarOfTemplates(File file) throws IOException {
        JarOfTemplates j;
        if (this.mSrcJars == null) {
            this.mSrcJars = Collections.synchronizedMap(new HashMap());
        }
        if ((j = this.mSrcJars.get(file)) == null) {
            j = new JarOfTemplates(file);
            this.mSrcJars.put(file, j);
        }
        return j;
    }

    private void init(File[] rootSourceDirs, File rootDestDir, String encoding) {
        this.mRootSourceDirs = (File[])rootSourceDirs.clone();
        this.mRootDestDir = rootDestDir;
        this.mEncoding = encoding;
        for (int i = 0; i < rootSourceDirs.length; ++i) {
            if (rootSourceDirs[i].isDirectory() || this.isJarUrl(rootSourceDirs[i])) continue;
            throw new IllegalArgumentException("Source location is not a directory or a jar URL: " + rootSourceDirs[i]);
        }
        if (rootDestDir != null && !rootDestDir.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory: " + rootDestDir);
        }
        if (!TemplateRepository.isInitialized()) {
            TemplateRepository.init(rootDestDir, this.getRootPackage());
        }
    }

    @Override
    public void setForceCompile(boolean force) {
        this.mForce = force;
    }

    public String[] compileAll(boolean recurse) throws IOException {
        return this.compile(this.getAllTemplateNames(recurse));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] compile(String[] names) throws IOException {
        try {
            ArrayList<String> nameList = new ArrayList<String>();
            Object[] allNames = this.getAllTemplateNames();
            Arrays.sort(allNames);
            for (int i = 0; i < names.length; ++i) {
                if (Arrays.binarySearch(allNames, names[i]) < 0) continue;
                nameList.add(names[i]);
            }
            String[] stringArray = super.compile(nameList.toArray(new String[nameList.size()]));
            return stringArray;
        }
        finally {
            if (this.mSrcJars != null) {
                for (File f : this.mSrcJars.keySet()) {
                    this.mSrcJars.remove(f).close();
                }
            }
        }
    }

    @Override
    public String[] getAllTemplateNames() throws IOException {
        return this.getAllTemplateNames(true);
    }

    private String[] getAllTemplateNames(boolean recurse) throws IOException {
        TreeSet<String> sources = new TreeSet<String>();
        for (int i = 0; i < this.mRootSourceDirs.length; ++i) {
            if (this.isJarUrl(this.mRootSourceDirs[i])) {
                JarOfTemplates j = this.getJarOfTemplates(this.mRootSourceDirs[i]);
                this.gatherJarSources(sources, j);
                continue;
            }
            this.gatherSources(sources, this.mRootSourceDirs[i], recurse);
        }
        return sources.toArray(new String[sources.size()]);
    }

    @Override
    public boolean sourceExists(String name) {
        return this.findRootSourceDir(name) != null || this.findJarSrc(name) != null;
    }

    private void gatherJarSources(Collection<String> sources, JarOfTemplates j) throws IOException {
        Enumeration<JarEntry> entries = j.getEntries();
        while (entries.hasMoreElements()) {
            String name = entries.nextElement().getName();
            if (!name.endsWith(".tea")) continue;
            name = name.substring(0, name.lastIndexOf(".tea"));
            if (sources.contains(name = name.replace('/', '.'))) continue;
            sources.add(name);
        }
    }

    private void gatherSources(Collection<String> templateNames, File sourceDir, boolean recurse) throws IOException {
        this.gatherSources(templateNames, sourceDir, null, recurse);
    }

    private void gatherSources(Collection<String> toCompile, File sourceDir, String parentName, boolean recurse) throws IOException {
        String[] list = sourceDir.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                String name;
                File file = new File(sourceDir, list[i]);
                if (file.isHidden()) continue;
                if (file.isDirectory()) {
                    if (!recurse) continue;
                    name = file.getName();
                    if (parentName != null) {
                        name = parentName + '.' + name;
                    }
                    this.gatherSources(toCompile, file, name, recurse);
                    continue;
                }
                if (!file.getName().endsWith(".tea")) continue;
                name = file.getName();
                int index = name.lastIndexOf(46);
                name = name.substring(0, index);
                if (parentName != null) {
                    name = parentName + '.' + name;
                }
                toCompile.add(name);
            }
        }
    }

    @Override
    protected CompilationUnit createCompilationUnit(String name) {
        File jarFile = this.findJarSrc(name);
        try {
            if (jarFile != null) {
                return new JarredUnit(jarFile, name, this);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return new Unit(name, (Compiler)this);
    }

    private File findRootSourceDir(String name) {
        String fileName = name.replace('.', File.separatorChar) + ".tea";
        for (int i = 0; i < this.mRootSourceDirs.length; ++i) {
            File file;
            if (this.mRootSourceDirs[i].isFile() && this.mRootSourceDirs[i].getPath().endsWith(".jar") || !(file = new File(this.mRootSourceDirs[i], fileName)).exists()) continue;
            return this.mRootSourceDirs[i];
        }
        return null;
    }

    private File findJarSrc(String name) {
        String fileName = name.replace('.', '/') + ".tea";
        for (File file : this.mRootSourceDirs) {
            if (!this.isJarUrl(file)) continue;
            try {
                JarOfTemplates jot = this.getJarOfTemplates(file);
                if (jot.getEntry(fileName) == null) continue;
                return file;
            }
            catch (IOException ex) {
                throw new RuntimeException("opening jar file: " + file, ex);
            }
        }
        return null;
    }

    private boolean isJarUrl(File file) {
        String path = file.toString();
        return path.startsWith("jar:") && path.endsWith("!");
    }

    class JarOfTemplates {
        private JarFile mJarFile;
        private JarURLConnection mConn;
        private URL mUrl;

        public JarOfTemplates(File file) throws IOException {
            this.mUrl = this.makeJarUrlFromFile(file);
            this.mConn = (JarURLConnection)this.mUrl.openConnection();
            this.mJarFile = this.mConn.getJarFile();
        }

        public JarEntry getEntry(JarEntry jarEntry) {
            return this.getEntry(jarEntry.getName());
        }

        public JarEntry getEntry(String name) {
            return this.mJarFile.getJarEntry(name);
        }

        public Enumeration<JarEntry> getEntries() {
            return this.mJarFile.entries();
        }

        public InputStream getInputStream(JarEntry jarEntry) throws IOException {
            return this.mJarFile.getInputStream(jarEntry);
        }

        public URL getUrl() {
            return this.mUrl;
        }

        public void close() throws IOException {
            if (this.mJarFile != null) {
                this.mJarFile.close();
            }
            this.mJarFile = null;
            this.mConn = null;
        }

        URL makeJarUrlFromFile(File path) {
            String urlStr = path.toString();
            if ((urlStr = urlStr.replace("\\", "/")).startsWith("jar:file:")) {
                urlStr = urlStr.replaceFirst("/", "///");
            } else if (urlStr.indexOf("//") < 0) {
                urlStr = urlStr.replaceFirst("/", "//");
            }
            if (!urlStr.endsWith("/")) {
                urlStr = urlStr + "/";
            }
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException("not a jar url: " + urlStr, ex);
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    public class JarredUnit
    extends FileUnit {
        private JarOfTemplates mJarOfTemplates;
        private URL mUrl;

        public JarredUnit(File file, String name, Compiler compiler) throws IOException {
            super(name, compiler);
            this.mJarOfTemplates = FileCompiler.this.getJarOfTemplates(file);
            this.mUrl = new URL(this.mJarOfTemplates.getUrl(), this.mJarOfTemplates.getEntry(this.mSourceFileName).toString());
        }

        @Override
        public String getSourceFileName() {
            return this.getJarEntry().getName();
        }

        public JarEntry getJarEntry() {
            return this.mJarOfTemplates.getEntry(this.mSourceFileName);
        }

        public URL getSourceUrl() {
            return this.mUrl;
        }

        @Override
        protected InputStream getTemplateSource(String templateSourceName) throws IOException {
            return this.mJarOfTemplates.getInputStream(this.getJarEntry());
        }

        @Override
        protected long getLastModified() {
            if (this.getJarEntry() == null) {
                return -1L;
            }
            return this.getJarEntry().getTime();
        }

        public void syncTimes() {
            if (this.mDestFile != null) {
                this.mDestFile.setLastModified(this.getJarEntry().getTime());
            }
        }
    }

    public class Unit
    extends FileUnit {
        private final File mSourceFile;

        Unit(String name, Compiler compiler) {
            super(name, compiler);
            File rootSourceDir = FileCompiler.this.findRootSourceDir(name);
            if (rootSourceDir == null) {
                rootSourceDir = FileCompiler.this.mRootSourceDirs[0];
            }
            this.mSourceFile = new File(rootSourceDir, this.mSourceFileName);
        }

        public File getSourceFile() {
            return this.mSourceFile;
        }

        @Override
        protected InputStream getTemplateSource(String templateSourceName) throws IOException {
            return new FileInputStream(this.mSourceFile);
        }

        @Override
        protected long getLastModified() {
            return this.mSourceFile.lastModified();
        }
    }

    public abstract class FileUnit
    extends AbstractCompiler.AbstractUnit {
        FileUnit(String name, Compiler compiler) {
            super(name, compiler);
        }
    }
}

