/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import org.teatrove.trove.generics.GenericType;

public class GenericPropertyDescriptor
extends PropertyDescriptor {
    private GenericType rootType;
    private GenericType genericType;
    private PropertyDescriptor property;

    public GenericPropertyDescriptor(PropertyDescriptor property) throws IntrospectionException {
        super(property.getName(), null, null);
        this.property = property;
    }

    public GenericPropertyDescriptor(GenericType rootType, PropertyDescriptor property) throws IntrospectionException {
        super(property.getName(), null, null);
        this.rootType = rootType;
        this.property = property;
    }

    @Override
    public synchronized Class<?> getPropertyType() {
        this.resolvePropertyType();
        return this.genericType.getRawType().getType();
    }

    public GenericType getGenericPropertyType() {
        this.resolvePropertyType();
        return this.genericType;
    }

    protected void resolvePropertyType() {
        if (this.genericType == null) {
            this.resolvePropertyType0();
        }
    }

    protected void resolvePropertyType0() {
        Method writeMethod;
        Class<?> propertyType = this.property.getPropertyType();
        Method readMethod = this.property.getReadMethod();
        this.genericType = readMethod != null ? new GenericType(this.rootType, readMethod.getReturnType(), readMethod.getGenericReturnType()) : ((writeMethod = this.property.getWriteMethod()) != null ? new GenericType(this.rootType, writeMethod.getParameterTypes()[0], writeMethod.getGenericParameterTypes()[0]) : new GenericType(this.rootType, propertyType));
    }

    @Override
    public synchronized Method getReadMethod() {
        return this.property.getReadMethod();
    }

    @Override
    public synchronized void setReadMethod(Method readMethod) throws IntrospectionException {
        if (this.property != null) {
            this.property.setReadMethod(readMethod);
        }
    }

    @Override
    public synchronized Method getWriteMethod() {
        return this.property.getWriteMethod();
    }

    @Override
    public synchronized void setWriteMethod(Method writeMethod) throws IntrospectionException {
        if (this.property != null) {
            this.property.setWriteMethod(writeMethod);
        }
    }

    @Override
    public boolean isBound() {
        return this.property.isBound();
    }

    @Override
    public void setBound(boolean bound) {
        this.property.setBound(bound);
    }

    @Override
    public boolean isConstrained() {
        return this.property.isConstrained();
    }

    @Override
    public void setConstrained(boolean constrained) {
        this.property.setConstrained(constrained);
    }

    @Override
    public void setPropertyEditorClass(Class<?> propertyEditorClass) {
        this.property.setPropertyEditorClass(propertyEditorClass);
    }

    @Override
    public Class<?> getPropertyEditorClass() {
        return this.property.getPropertyEditorClass();
    }

    @Override
    public PropertyEditor createPropertyEditor(Object bean) {
        return this.property.createPropertyEditor(bean);
    }

    @Override
    public String getName() {
        return this.property.getName();
    }

    @Override
    public void setName(String name) {
        if (this.property != null) {
            this.property.setName(name);
        }
    }

    @Override
    public String getDisplayName() {
        return this.property.getDisplayName();
    }

    @Override
    public void setDisplayName(String displayName) {
        this.property.setDisplayName(displayName);
    }

    @Override
    public boolean isExpert() {
        return this.property.isExpert();
    }

    @Override
    public void setExpert(boolean expert) {
        this.property.setExpert(expert);
    }

    @Override
    public boolean isHidden() {
        return this.property.isHidden();
    }

    @Override
    public void setHidden(boolean hidden) {
        this.property.setHidden(hidden);
    }

    @Override
    public boolean isPreferred() {
        return this.property.isPreferred();
    }

    @Override
    public void setPreferred(boolean preferred) {
        this.property.setPreferred(preferred);
    }

    @Override
    public String getShortDescription() {
        return this.property.getShortDescription();
    }

    @Override
    public void setShortDescription(String text) {
        this.property.setShortDescription(text);
    }

    @Override
    public void setValue(String attributeName, Object value) {
        this.property.setValue(attributeName, value);
    }

    @Override
    public Object getValue(String attributeName) {
        return this.property.getValue(attributeName);
    }

    @Override
    public Enumeration<String> attributeNames() {
        return this.property.attributeNames();
    }

    @Override
    public String toString() {
        return ((Object)this.property).toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.property.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.property.hashCode();
    }
}

