/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.teatrove.tea.compiler.CompilationUnit;
import org.teatrove.tea.compiler.Compiler;
import org.teatrove.tea.util.AbstractCompiler;
import org.teatrove.trove.util.ClassInjector;

public class ResourceCompiler
extends AbstractCompiler {
    public ResourceCompiler(ClassInjector injector) {
        this(injector, null);
    }

    public ResourceCompiler(ClassInjector injector, String packagePrefix) {
        super(injector, packagePrefix);
    }

    @Override
    public boolean sourceExists(String name) {
        String resName = '/' + name.replace('.', '/') + ".tea";
        return this.getClass().getResource(resName) != null;
    }

    @Override
    public String[] getAllTemplateNames() throws IOException {
        return new String[0];
    }

    @Override
    protected CompilationUnit createCompilationUnit(String name) {
        return new Unit(name, (Compiler)this);
    }

    private class Unit
    extends AbstractCompiler.AbstractUnit {
        public Unit(String name, Compiler compiler) {
            super(name, compiler);
        }

        @Override
        public Reader getReader() throws IOException {
            String resName = '/' + this.getSourceFileName();
            return new InputStreamReader(this.getClass().getResourceAsStream(resName));
        }

        @Override
        protected long getLastModified() {
            String resName = '/' + this.getSourceFileName();
            URL url = this.getClass().getResource(resName);
            if (url == null) {
                return -1L;
            }
            try {
                return url.openConnection().getLastModified();
            }
            catch (IOException ioe) {
                System.err.println("unable to get last modified for resource: " + resName);
                ioe.printStackTrace();
                return -1L;
            }
        }

        @Override
        protected InputStream getTemplateSource(String templateSourceName) throws IOException {
            String resName = '/' + this.getSourceFileName();
            return this.getClass().getResourceAsStream(resName);
        }
    }
}

