/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.teatrove.tea.compiler.CompilationUnit;
import org.teatrove.tea.compiler.Compiler;
import org.teatrove.tea.util.AbstractCompiler;
import org.teatrove.trove.util.ClassInjector;

public class StringCompiler
extends AbstractCompiler {
    private Hashtable<String, TemplateSource> mTemplateSources = new Hashtable();

    public StringCompiler(ClassInjector injector) {
        this(injector, null);
    }

    public StringCompiler(ClassInjector injector, String packagePrefix) {
        super(injector, packagePrefix);
    }

    @Override
    public boolean sourceExists(String name) {
        return this.mTemplateSources.containsKey(name);
    }

    @Override
    public String[] getAllTemplateNames() throws IOException {
        return this.mTemplateSources.keySet().toArray(new String[this.mTemplateSources.size()]);
    }

    @Override
    protected CompilationUnit createCompilationUnit(String name) {
        return new Unit(name, (Compiler)this);
    }

    public void setTemplateSource(String name, String source) {
        this.mTemplateSources.put(name, new TemplateSource(source));
    }

    private static class TemplateSource {
        private String mSource;
        private long mTimestamp;

        public TemplateSource(String source) {
            this.mSource = source;
            this.mTimestamp = System.currentTimeMillis();
        }

        public String getSource() {
            return this.mSource;
        }

        public long getTimestamp() {
            return this.mTimestamp;
        }
    }

    private class Unit
    extends AbstractCompiler.AbstractUnit {
        public Unit(String name, Compiler compiler) {
            super(name, compiler);
        }

        @Override
        protected long getLastModified() {
            TemplateSource source = (TemplateSource)StringCompiler.this.mTemplateSources.get(this.getName());
            return source == null ? 0L : source.getTimestamp();
        }

        @Override
        protected InputStream getTemplateSource(String templateSourceName) throws IOException {
            TemplateSource source = (TemplateSource)StringCompiler.this.mTemplateSources.get(this.getName());
            return new ByteArrayInputStream(source.getSource().getBytes("UTF-8"));
        }
    }
}

