/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.util;

import java.io.File;
import java.io.PrintStream;
import org.teatrove.tea.runtime.DefaultContext;
import org.teatrove.tea.runtime.TemplateLoader;
import org.teatrove.tea.util.ConsoleErrorReporter;
import org.teatrove.tea.util.FileCompiler;

public class TestCompiler
extends FileCompiler {
    public static void main(String[] args) throws Exception {
        File dir = new File(".");
        TestCompiler tc = new TestCompiler(dir, null, dir);
        tc.addErrorListener(new ConsoleErrorReporter(System.out));
        tc.setForceCompile(true);
        String[] names = tc.compile(args[0]);
        System.out.println("Compiled " + names.length + " sources");
        for (int i = 0; i < names.length; ++i) {
            System.out.println(names[i]);
        }
        int errorCount = tc.getErrorCount();
        if (errorCount > 0) {
            String msg = String.valueOf(errorCount) + " error";
            if (errorCount != 1) {
                msg = msg + 's';
            }
            System.out.println(msg);
            return;
        }
        TemplateLoader loader = new TemplateLoader();
        TemplateLoader.Template template = loader.getTemplate(args[0]);
        int length = args.length - 1;
        Object[] params = new Object[length];
        for (int i = 0; i < length; ++i) {
            params[i] = args[i + 1];
        }
        System.out.println("Executing " + template);
        template.execute(new Context(System.out), params);
    }

    public TestCompiler(File rootSourceDir, String rootPackage, File rootDestDir) {
        super(rootSourceDir, rootPackage, rootDestDir, null);
    }

    public static class Context
    extends DefaultContext {
        private PrintStream mOut;

        public Context(PrintStream out) {
            this.mOut = out;
        }

        @Override
        public void print(Object obj) {
            this.mOut.print(this.toString(obj));
        }
    }
}

