/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr;

import java.util.HashMap;
import java.util.Map;
import org.teavm.flavour.expr.ClassResolver;

public class ClassPathClassResolver
implements ClassResolver {
    private ClassLoader classLoader;
    private Map<String, String> cache = new HashMap<String, String>();

    public ClassPathClassResolver() {
        this(ClassLoader.getSystemClassLoader());
    }

    public ClassPathClassResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String findClass(String name) {
        String fullName = this.cache.get(name);
        if (fullName == null) {
            try {
                Class.forName(name, false, this.classLoader);
                fullName = name;
            }
            catch (ClassNotFoundException e) {
                fullName = "";
            }
            this.cache.put(name, fullName);
        }
        return !fullName.isEmpty() ? fullName : null;
    }
}

