/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.teavm.flavour.expr.ClassResolver;
import org.teavm.flavour.expr.CompilerVisitor;
import org.teavm.flavour.expr.Diagnostic;
import org.teavm.flavour.expr.Scope;
import org.teavm.flavour.expr.TypedPlan;
import org.teavm.flavour.expr.ast.AssignmentExpr;
import org.teavm.flavour.expr.ast.BoundVariable;
import org.teavm.flavour.expr.ast.Expr;
import org.teavm.flavour.expr.ast.LambdaExpr;
import org.teavm.flavour.expr.ast.PropertyExpr;
import org.teavm.flavour.expr.ast.VariableExpr;
import org.teavm.flavour.expr.type.GenericClass;
import org.teavm.flavour.expr.type.GenericMethod;
import org.teavm.flavour.expr.type.GenericTypeNavigator;
import org.teavm.flavour.expr.type.ValueType;
import org.teavm.flavour.expr.type.meta.ClassDescriberRepository;

public class Compiler {
    private ClassResolver classResolver;
    private Scope scope;
    private List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
    private List<Diagnostic> safeDiagnostics = Collections.unmodifiableList(this.diagnostics);
    private GenericTypeNavigator typeNavigator;

    public Compiler(ClassDescriberRepository classRepository, ClassResolver classResolver, Scope scope) {
        this.classResolver = classResolver;
        this.scope = scope;
        this.typeNavigator = new GenericTypeNavigator(classRepository);
    }

    public TypedPlan compile(Expr expr) {
        return this.compile(expr, null);
    }

    public TypedPlan compile(Expr expr, ValueType type) {
        this.diagnostics.clear();
        CompilerVisitor visitor = new CompilerVisitor(this.typeNavigator, this.classResolver, this.scope);
        visitor.expectedType = type;
        TypedPlan plan = expr.acceptVisitor(visitor);
        if (type != null) {
            plan = visitor.convert(expr, plan, type);
        }
        this.diagnostics.addAll(visitor.getDiagnostics());
        return plan;
    }

    public TypedPlan compileLambda(Expr expr, GenericClass cls) {
        if (!(expr instanceof LambdaExpr)) {
            GenericMethod sam = this.typeNavigator.findSingleAbstractMethod(cls);
            if (sam.getActualReturnType() == null && sam.getActualParameterTypes().length == 1 && (expr instanceof VariableExpr || expr instanceof PropertyExpr)) {
                BoundVariable var = new BoundVariable("$value$", sam.getActualParameterTypes()[0]);
                AssignmentExpr assignment = new AssignmentExpr(expr, new VariableExpr("$value$"));
                assignment.setStart(expr.getStart());
                assignment.setEnd(expr.getEnd());
                LambdaExpr lambda = new LambdaExpr(assignment, Arrays.asList(var));
                lambda.setStart(expr.getStart());
                lambda.setEnd(expr.getEnd());
                expr = lambda;
            } else {
                ArrayList<BoundVariable> boundVars = new ArrayList<BoundVariable>();
                if (sam.getActualParameterTypes().length == 1) {
                    boundVars.add(new BoundVariable("it", sam.getActualParameterTypes()[0]));
                } else {
                    for (ValueType arg : sam.getActualParameterTypes()) {
                        boundVars.add(new BoundVariable("", arg));
                    }
                }
                LambdaExpr lambda = new LambdaExpr(expr, boundVars);
                lambda.setStart(expr.getStart());
                lambda.setEnd(expr.getEnd());
                expr = lambda;
            }
        }
        return this.compile(expr, cls);
    }

    public List<Diagnostic> getDiagnostics() {
        return this.safeDiagnostics;
    }

    public boolean wasSuccessful() {
        return this.diagnostics.isEmpty();
    }
}

