/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.flavour.expr.ClassResolver;
import org.teavm.flavour.expr.CompilerCommons;
import org.teavm.flavour.expr.Diagnostic;
import org.teavm.flavour.expr.Location;
import org.teavm.flavour.expr.MethodLookup;
import org.teavm.flavour.expr.Scope;
import org.teavm.flavour.expr.TypedPlan;
import org.teavm.flavour.expr.ast.AssignmentExpr;
import org.teavm.flavour.expr.ast.BinaryExpr;
import org.teavm.flavour.expr.ast.BinaryOperation;
import org.teavm.flavour.expr.ast.BoundVariable;
import org.teavm.flavour.expr.ast.CastExpr;
import org.teavm.flavour.expr.ast.ConstantExpr;
import org.teavm.flavour.expr.ast.Expr;
import org.teavm.flavour.expr.ast.ExprVisitor;
import org.teavm.flavour.expr.ast.InstanceOfExpr;
import org.teavm.flavour.expr.ast.InvocationExpr;
import org.teavm.flavour.expr.ast.LambdaExpr;
import org.teavm.flavour.expr.ast.PropertyExpr;
import org.teavm.flavour.expr.ast.StaticInvocationExpr;
import org.teavm.flavour.expr.ast.StaticPropertyExpr;
import org.teavm.flavour.expr.ast.TernaryConditionExpr;
import org.teavm.flavour.expr.ast.ThisExpr;
import org.teavm.flavour.expr.ast.UnaryExpr;
import org.teavm.flavour.expr.ast.VariableExpr;
import org.teavm.flavour.expr.plan.ArithmeticCastPlan;
import org.teavm.flavour.expr.plan.ArithmeticType;
import org.teavm.flavour.expr.plan.ArrayConstructionPlan;
import org.teavm.flavour.expr.plan.ArrayLengthPlan;
import org.teavm.flavour.expr.plan.BinaryPlan;
import org.teavm.flavour.expr.plan.BinaryPlanType;
import org.teavm.flavour.expr.plan.CastFromIntegerPlan;
import org.teavm.flavour.expr.plan.CastPlan;
import org.teavm.flavour.expr.plan.CastToIntegerPlan;
import org.teavm.flavour.expr.plan.ConditionalPlan;
import org.teavm.flavour.expr.plan.ConstantPlan;
import org.teavm.flavour.expr.plan.ConstructionPlan;
import org.teavm.flavour.expr.plan.FieldAssignmentPlan;
import org.teavm.flavour.expr.plan.FieldPlan;
import org.teavm.flavour.expr.plan.GetArrayElementPlan;
import org.teavm.flavour.expr.plan.InstanceOfPlan;
import org.teavm.flavour.expr.plan.IntegerSubtype;
import org.teavm.flavour.expr.plan.InvocationPlan;
import org.teavm.flavour.expr.plan.LambdaPlan;
import org.teavm.flavour.expr.plan.LogicalBinaryPlan;
import org.teavm.flavour.expr.plan.LogicalBinaryPlanType;
import org.teavm.flavour.expr.plan.NegatePlan;
import org.teavm.flavour.expr.plan.NotPlan;
import org.teavm.flavour.expr.plan.Plan;
import org.teavm.flavour.expr.plan.ReferenceEqualityPlan;
import org.teavm.flavour.expr.plan.ReferenceEqualityPlanType;
import org.teavm.flavour.expr.plan.ThisPlan;
import org.teavm.flavour.expr.plan.VariablePlan;
import org.teavm.flavour.expr.type.GenericArray;
import org.teavm.flavour.expr.type.GenericClass;
import org.teavm.flavour.expr.type.GenericField;
import org.teavm.flavour.expr.type.GenericMethod;
import org.teavm.flavour.expr.type.GenericReference;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.GenericTypeNavigator;
import org.teavm.flavour.expr.type.NullType;
import org.teavm.flavour.expr.type.Primitive;
import org.teavm.flavour.expr.type.PrimitiveArray;
import org.teavm.flavour.expr.type.PrimitiveKind;
import org.teavm.flavour.expr.type.TypeArgument;
import org.teavm.flavour.expr.type.TypeInference;
import org.teavm.flavour.expr.type.TypeInferenceStatePoint;
import org.teavm.flavour.expr.type.TypeUtils;
import org.teavm.flavour.expr.type.TypeVar;
import org.teavm.flavour.expr.type.ValueType;
import org.teavm.flavour.expr.type.ValueTypeFormatter;
import org.teavm.flavour.expr.type.Variance;
import org.teavm.flavour.expr.type.meta.ClassDescriber;

class CompilerVisitor
implements ExprVisitor<TypedPlan> {
    private GenericTypeNavigator navigator;
    private Scope scope;
    private Map<String, ValueType> boundVars = new HashMap<String, ValueType>();
    private Map<String, String> boundVarRenamings = new HashMap<String, String>();
    private List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
    private ClassResolver classResolver;
    private ValueType lambdaReturnType;
    ValueType expectedType;

    CompilerVisitor(GenericTypeNavigator navigator, ClassResolver classes, Scope scope) {
        this.navigator = navigator;
        this.classResolver = classes;
        this.scope = scope;
    }

    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    public TypedPlan visit(BinaryExpr expr) {
        Expr firstOperand = expr.getFirstOperand();
        Expr secondOperand = expr.getSecondOperand();
        this.expectedType = null;
        TypedPlan firstPlan = firstOperand.acceptVisitor(this);
        this.expectedType = null;
        secondOperand.acceptVisitor(this);
        TypedPlan secondPlan = secondOperand.acceptVisitor(this);
        switch (expr.getOperation()) {
            case SUBTRACT: 
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: {
                ArithmeticTypeAndPlans result = this.getArithmeticTypeForPair(firstOperand, firstPlan, secondOperand, secondPlan);
                BinaryPlan plan = new BinaryPlan(result.first.getPlan(), result.second.getPlan(), this.getPlanType(expr.getOperation()), result.arithmeticType);
                return this.planWithLocation(plan, CompilerCommons.getType(result.arithmeticType), expr);
            }
            case AND: 
            case OR: {
                firstPlan = this.ensureBooleanType(firstOperand, firstPlan);
                secondPlan = this.ensureBooleanType(secondOperand, secondPlan);
                LogicalBinaryPlan plan = new LogicalBinaryPlan(firstPlan.getPlan(), secondPlan.getPlan(), this.getLogicalPlanType(expr.getOperation()));
                return this.planWithLocation(plan, Primitive.BOOLEAN, expr);
            }
            case EQUAL: 
            case NOT_EQUAL: {
                if (CompilerCommons.classesSuitableForComparison.contains(firstPlan.getType()) && CompilerCommons.classesSuitableForComparison.contains(secondPlan.getType())) {
                    ArithmeticTypeAndPlans result = this.getArithmeticTypeForPair(firstOperand, firstPlan, secondOperand, secondPlan);
                    BinaryPlan plan = new BinaryPlan(result.first.getPlan(), result.second.getPlan(), this.getPlanType(expr.getOperation()), result.arithmeticType);
                    return this.planWithLocation(plan, Primitive.BOOLEAN, expr);
                }
                ReferenceEqualityPlan plan = new ReferenceEqualityPlan(firstPlan.getPlan(), secondPlan.getPlan(), expr.getOperation() == BinaryOperation.EQUAL ? ReferenceEqualityPlanType.EQUAL : ReferenceEqualityPlanType.NOT_EQUAL);
                return this.planWithLocation(plan, Primitive.BOOLEAN, expr);
            }
            case LESS: 
            case LESS_OR_EQUAL: 
            case GREATER: 
            case GREATER_OR_EQUAL: {
                ArithmeticTypeAndPlans result = this.getArithmeticTypeForPair(firstOperand, firstPlan, secondOperand, secondPlan);
                BinaryPlan plan = new BinaryPlan(result.first.getPlan(), result.second.getPlan(), this.getPlanType(expr.getOperation()), result.arithmeticType);
                return this.planWithLocation(plan, Primitive.BOOLEAN, expr);
            }
            case GET_ELEMENT: {
                return this.compileGetElement(expr);
            }
            case ADD: {
                return this.compileAdd(expr);
            }
        }
        throw new AssertionError();
    }

    private TypedPlan compileAdd(BinaryExpr expr) {
        Expr firstOperand = expr.getFirstOperand();
        TypedPlan firstPlan = firstOperand.acceptVisitor(this);
        ValueType firstType = firstPlan.getType();
        Expr secondOperand = expr.getSecondOperand();
        TypedPlan secondPlan = secondOperand.acceptVisitor(this);
        ValueType secondType = secondPlan.getType();
        if (firstType.equals(TypeUtils.STRING_CLASS) || secondType.equals(TypeUtils.STRING_CLASS)) {
            InvocationPlan invocation;
            if (firstPlan.getPlan() instanceof InvocationPlan && (invocation = (InvocationPlan)firstPlan.getPlan()).getClassName().equals("java.lang.StringBuilder") && invocation.getMethodName().equals("toString")) {
                secondPlan = this.convertToString(expr.getSecondOperand(), secondPlan);
                Plan instance = invocation.getInstance();
                InvocationPlan append = new InvocationPlan("java.lang.StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", instance, secondPlan.getPlan());
                invocation.setInstance(append);
                return this.planWithLocation(invocation, TypeUtils.STRING_CLASS, expr);
            }
            firstPlan = this.convertToString(expr.getFirstOperand(), firstPlan);
            secondPlan = this.convertToString(expr.getSecondOperand(), secondPlan);
            ConstructionPlan construction = new ConstructionPlan("java.lang.StringBuilder", "()V", new Plan[0]);
            InvocationPlan invocation2 = new InvocationPlan("java.lang.StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", (Plan)construction, firstPlan.getPlan());
            invocation2 = new InvocationPlan("java.lang.StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", (Plan)invocation2, secondPlan.getPlan());
            invocation2 = new InvocationPlan("java.lang.StringBuilder", "toString", "()Ljava/lang/String;", (Plan)invocation2, new Plan[0]);
            return this.planWithLocation(invocation2, TypeUtils.STRING_CLASS, expr);
        }
        ArithmeticTypeAndPlans result = this.getArithmeticTypeForPair(firstOperand, firstPlan, secondOperand, secondPlan);
        BinaryPlan plan = new BinaryPlan(result.first.getPlan(), result.second.getPlan(), BinaryPlanType.ADD, result.arithmeticType);
        return this.planWithLocation(plan, CompilerCommons.getType(result.arithmeticType), expr);
    }

    private TypedPlan compileGetElement(BinaryExpr expr) {
        Expr firstOperand = expr.getFirstOperand();
        TypedPlan firstPlan = firstOperand.acceptVisitor(this);
        ValueType firstType = firstPlan.getType();
        Expr secondOperand = expr.getSecondOperand();
        TypedPlan secondPlan = secondOperand.acceptVisitor(this);
        ValueType secondType = secondPlan.getType();
        if (firstType instanceof GenericArray) {
            GenericArray arrayType = (GenericArray)firstType;
            secondPlan = this.ensureIntType(secondOperand, secondPlan);
            GetArrayElementPlan plan = new GetArrayElementPlan(firstPlan.getPlan(), secondPlan.getPlan());
            return this.planWithLocation(plan, arrayType.getElementType(), expr);
        }
        if (firstType instanceof PrimitiveArray) {
            PrimitiveArray arrayType = (PrimitiveArray)firstType;
            secondPlan = this.ensureIntType(secondOperand, secondPlan);
            GetArrayElementPlan plan = new GetArrayElementPlan(firstPlan.getPlan(), secondPlan.getPlan());
            return this.planWithLocation(plan, arrayType.getElementType(), expr);
        }
        if (firstType instanceof GenericClass) {
            Collection<GenericClass> classes = CompilerCommons.extractClasses(firstType);
            return this.compileInvocation(expr, firstPlan, classes, "get", Arrays.asList(secondOperand), this.expectedType);
        }
        return this.errorAndFakeResult(expr, "Can't apply subscript operator to " + firstType + " with argument of " + secondType);
    }

    private TypedPlan errorAndFakeResult(Expr expr, String message) {
        this.error(expr, message);
        return this.planWithLocation(new ConstantPlan(null), NullType.INSTANCE, expr);
    }

    @Override
    public TypedPlan visit(CastExpr expr) {
        this.expectedType = null;
        TypedPlan result = expr.getValue().acceptVisitor(this);
        return this.cast(expr, result, this.resolveType(expr.getTargetType(), expr));
    }

    private TypedPlan cast(Expr expr, TypedPlan plan, ValueType type) {
        ValueType sourceType = plan.getType();
        return (plan = this.tryCast(expr, plan, type)) != null ? plan : this.errorAndFakeResult(expr, "Can't cast " + sourceType + " to " + type);
    }

    private TypedPlan tryCast(Expr expr, TypedPlan plan, ValueType targetType) {
        if (plan.getType().equals(targetType)) {
            return plan;
        }
        if (targetType instanceof Primitive) {
            if (!(plan.type instanceof Primitive) && (plan = this.unbox(plan)) == null) {
                return null;
            }
            if ((plan = this.tryCastPrimitive(plan, (Primitive)targetType)) == null) {
                return null;
            }
            return plan;
        }
        if (plan.type instanceof Primitive) {
            plan = this.box(expr, plan);
        }
        if (!CompilerCommons.isSuperType(targetType, plan.type, this.navigator)) {
            GenericType erasure = ((GenericType)targetType).erasure();
            plan = new TypedPlan(new CastPlan(plan.plan, CompilerCommons.typeToString(erasure)), targetType);
        }
        return this.planWithLocation(plan.getPlan(), targetType, expr);
    }

    @Override
    public TypedPlan visit(InstanceOfExpr expr) {
        this.expectedType = null;
        expr.setCheckedType((GenericType)this.resolveType(expr.getCheckedType(), expr));
        Expr value = expr.getValue();
        TypedPlan valuePlan = value.acceptVisitor(this);
        GenericType checkedType = expr.getCheckedType();
        ValueType sourceType = valuePlan.getType();
        if (!(sourceType instanceof GenericClass)) {
            this.error(expr, "Can't check against " + checkedType);
            return this.planWithLocation(new ConstantPlan(false), Primitive.BOOLEAN, expr);
        }
        GenericType erasure = checkedType.erasure();
        InstanceOfPlan plan = new InstanceOfPlan(valuePlan.getPlan(), CompilerCommons.typeToString(erasure));
        return this.planWithLocation(plan, Primitive.BOOLEAN, expr);
    }

    @Override
    public TypedPlan visit(InvocationExpr expr) {
        TypedPlan instance;
        ValueType expectedType = this.expectedType;
        if (expr.getInstance() != null) {
            this.expectedType = null;
            instance = expr.getInstance().acceptVisitor(this);
        } else {
            instance = new TypedPlan(new ThisPlan(), this.scope.variableType("this"));
        }
        if (instance.type instanceof Primitive) {
            instance = this.box(expr.getInstance(), instance);
        }
        Collection<GenericClass> classes = CompilerCommons.extractClasses(instance.type);
        return this.compileInvocation(expr, instance, classes, expr.getMethodName(), expr.getArguments(), expectedType);
    }

    @Override
    public TypedPlan visit(StaticInvocationExpr expr) {
        ValueType expectedType = this.expectedType;
        return this.compileInvocation(expr, null, Collections.singleton(this.navigator.getGenericClass(expr.getClassName())), expr.getMethodName(), expr.getArguments(), expectedType);
    }

    private TypedPlan compileInvocation(Expr expr, TypedPlan instance, Collection<GenericClass> classes, String methodName, List<Expr> argumentExprList, ValueType expectedType) {
        Expr arg;
        int i;
        int i2;
        TypeInference inference = new TypeInference(this.navigator);
        MethodLookup lookup = new MethodLookup(inference, this.classResolver, this.navigator, this.scope);
        GenericMethod method = instance != null ? lookup.lookupVirtual(classes, methodName, argumentExprList) : lookup.lookupStatic(classes, methodName, argumentExprList);
        if (method == null) {
            return this.reportMissingMethod(expr, methodName, argumentExprList, lookup, classes, instance == null);
        }
        ValueType returnType = method.getActualReturnType();
        ValueType[] capturedReturnType = new ValueType[1];
        if (!this.addReturnTypeConstraint(method.getActualReturnType(), expectedType, inference, capturedReturnType)) {
            return this.errorAndFakeResult(expr, "Expected type " + expectedType + " does not match actual return type " + method.getActualReturnType());
        }
        if (capturedReturnType[0] != null) {
            returnType = capturedReturnType[0];
        }
        ValueType[] argTypes = method.getActualParameterTypes();
        ValueType[] matchParamTypes = new ValueType[argumentExprList.size()];
        TypeInferenceStatePoint statePointAfterLookup = inference.createStatePoint();
        inference.resolve();
        TypedPlan[] rawArguments = new TypedPlan[argumentExprList.size()];
        for (i2 = 0; i2 < argumentExprList.size(); ++i2) {
            TypedPlan argPlan;
            ValueType lastArg;
            Expr arg2 = argumentExprList.get(i2);
            ValueType paramType = lookup.isVarArgs() && i2 >= argTypes.length - 1 ? ((lastArg = argTypes[argTypes.length - 1]) instanceof PrimitiveArray ? ((PrimitiveArray)lastArg).getElementType() : ((GenericArray)lastArg).getElementType()) : argTypes[i2];
            matchParamTypes[i2] = paramType;
            if (arg2 instanceof LambdaExpr) continue;
            if (paramType instanceof GenericType) {
                paramType = ((GenericType)paramType).substitute(inference.getSubstitutions());
            }
            this.expectedType = paramType;
            rawArguments[i2] = argPlan = arg2.acceptVisitor(this);
        }
        statePointAfterLookup.restoreTo();
        for (i2 = 0; i2 < argumentExprList.size(); ++i2) {
            if (rawArguments[i2] == null || inference.subtypeConstraint(rawArguments[i2].getType(), matchParamTypes[i2])) continue;
            return this.errorAndFakeResult(expr, "Argument " + (i2 + 1) + " type " + rawArguments[i2].getType() + " does not match parameter type " + matchParamTypes[i2]);
        }
        TypeInferenceStatePoint statePointBeforeLambdas = inference.createStatePoint();
        if (!inference.resolve()) {
            return this.errorAndFakeResult(expr, "Could not infer type");
        }
        ValueType[] lambdaReturnTypes = new ValueType[rawArguments.length];
        for (i = 0; i < argumentExprList.size(); ++i) {
            TypedPlan lambdaPlan;
            arg = argumentExprList.get(i);
            if (!(arg instanceof LambdaExpr)) continue;
            ValueType paramType = matchParamTypes[i];
            if (paramType instanceof GenericType) {
                paramType = ((GenericType)paramType).substitute(inference.getSubstitutions());
            }
            this.expectedType = paramType;
            rawArguments[i] = lambdaPlan = arg.acceptVisitor(this);
            lambdaReturnTypes[i] = this.lambdaReturnType;
        }
        statePointBeforeLambdas.restoreTo();
        for (i = 0; i < argumentExprList.size(); ++i) {
            GenericMethod paramSam;
            arg = argumentExprList.get(i);
            if (!(arg instanceof LambdaExpr)) continue;
            LambdaExpr lambda = (LambdaExpr)arg;
            ValueType paramType = matchParamTypes[i];
            if (!(paramType instanceof GenericClass) || (paramSam = this.navigator.findSingleAbstractMethod((GenericClass)paramType)) == null) continue;
            ValueType[] paramParamTypes = paramSam.getActualParameterTypes();
            for (int j = 0; j < paramParamTypes.length; ++j) {
                ValueType lambdaArgType = lambda.getBoundVariables().get(j).getType();
                if (lambdaArgType == null || inference.subtypeConstraint(paramParamTypes[j], lambdaArgType)) continue;
                return this.errorAndFakeResult(expr, "Could not infer type");
            }
            ValueType lambdaReturnType = lambdaReturnTypes[i];
            if (paramSam.getActualReturnType() == null || lambdaReturnType == null || inference.subtypeConstraint(lambdaReturnType, paramSam.getActualReturnType())) continue;
            return this.errorAndFakeResult(expr, "Could not infer type");
        }
        if (!inference.resolve()) {
            return this.errorAndFakeResult(expr, "Could not infer type");
        }
        for (i = 0; i < matchParamTypes.length; ++i) {
            if (!(matchParamTypes[i] instanceof GenericType)) continue;
            matchParamTypes[i] = ((GenericType)matchParamTypes[i]).substitute(inference.getSubstitutions());
        }
        for (i = 0; i < argTypes.length; ++i) {
            if (!(argTypes[i] instanceof GenericType)) continue;
            argTypes[i] = ((GenericType)argTypes[i]).substitute(inference.getSubstitutions());
        }
        Plan[] convertedArguments = new Plan[rawArguments.length];
        for (int i3 = 0; i3 < convertedArguments.length; ++i3) {
            if (rawArguments[i3] == null) continue;
            convertedArguments[i3] = this.convert(argumentExprList.get(i3), rawArguments[i3], matchParamTypes[i3]).getPlan();
        }
        method = method.substitute(inference.getSubstitutions());
        if (returnType instanceof GenericType) {
            returnType = ((GenericType)returnType).substitute(inference.getSubstitutions());
        }
        String className = method.getDescriber().getOwner().getName();
        String desc = CompilerCommons.methodToDesc(method.getDescriber());
        if (lookup.isVarArgs()) {
            convertedArguments = this.convertVarArgs(convertedArguments, argTypes);
        }
        InvocationPlan plan = new InvocationPlan(className, methodName, desc, instance != null ? instance.plan : null, convertedArguments);
        return this.planWithLocation(plan, returnType, expr);
    }

    private boolean addReturnTypeConstraint(ValueType actualType, ValueType expectedType, TypeInference inference, ValueType[] newReturnTypeHolder) {
        GenericClass actualClass;
        if (actualType == null || expectedType == null) {
            return true;
        }
        if (actualType instanceof GenericClass && (actualClass = (GenericClass)actualType).getArguments().stream().anyMatch(arg -> arg.getVariance() != Variance.INVARIANT)) {
            ClassDescriber describer = this.navigator.getClassRepository().describe(actualClass.getName());
            List<TypeVar> typeParameters = Arrays.asList(describer.getTypeVariables());
            List<? extends TypeArgument> capturedTypeArgs = inference.captureConversionConstraint(typeParameters, actualClass.getArguments());
            if (capturedTypeArgs == null) {
                return false;
            }
            newReturnTypeHolder[0] = new GenericClass(actualClass.getName(), capturedTypeArgs);
            return true;
        }
        return inference.subtypeConstraint(actualType, expectedType);
    }

    private Plan[] convertVarArgs(Plan[] args, ValueType[] argTypes) {
        Plan[] varargs = new Plan[argTypes.length];
        for (int i = 0; i < varargs.length - 1; ++i) {
            varargs[i] = args[i];
        }
        Plan[] array = new Plan[args.length - varargs.length + 1];
        for (int i = 0; i < array.length; ++i) {
            array[i] = args[varargs.length - 1 + i];
        }
        ValueType lastArgType = argTypes[argTypes.length - 1];
        ValueType elementType = lastArgType instanceof PrimitiveArray ? ((PrimitiveArray)lastArgType).getElementType() : ((GenericArray)lastArgType).getElementType();
        ArrayConstructionPlan arrayPlan = new ArrayConstructionPlan(CompilerCommons.typeToString(elementType));
        arrayPlan.getElements().addAll(Arrays.asList(array));
        varargs[varargs.length - 1] = arrayPlan;
        return varargs;
    }

    private TypedPlan reportMissingMethod(Expr expr, String methodName, List<Expr> args, MethodLookup lookup, Collection<GenericClass> classes, boolean isStatic) {
        GenericMethod altMethod;
        TypedPlan result = this.planWithLocation(new ConstantPlan(null), NullType.INSTANCE, expr);
        TypeInference inference = new TypeInference(this.navigator);
        MethodLookup altLookup = new MethodLookup(inference, this.classResolver, this.navigator, this.scope);
        GenericMethod genericMethod = altMethod = isStatic ? altLookup.lookupVirtual(classes, methodName, args) : altLookup.lookupStatic(classes, methodName, args);
        if (altMethod != null && inference.resolve()) {
            if (isStatic) {
                this.error(expr, "Method should be called as an instance method: " + altMethod);
            } else {
                this.error(expr, "Method should be called as a static method: " + altMethod);
            }
            return result;
        }
        if (lookup.getCandidates().isEmpty()) {
            this.error(expr, "Method not found: " + methodName);
        } else if (lookup.getCandidates().size() == 1) {
            this.error(expr, "Method " + lookup.getCandidates().get(0) + " is not applicable to given arguments");
        } else {
            this.error(expr, "Ambiguous method invocation " + methodName);
        }
        return result;
    }

    @Override
    public TypedPlan visit(PropertyExpr expr) {
        this.expectedType = null;
        TypedPlan instance = expr.getInstance().acceptVisitor(this);
        if ((instance.type instanceof GenericArray || instance.type instanceof PrimitiveArray) && expr.getPropertyName().equals("length")) {
            return this.planWithLocation(new ArrayLengthPlan(instance.plan), Primitive.INT, expr);
        }
        if (instance.type instanceof Primitive) {
            instance = this.box(expr, instance);
        }
        Collection<GenericClass> classes = CompilerCommons.extractClasses(instance.type);
        return this.compilePropertyAccess(expr, instance, classes, expr.getPropertyName());
    }

    @Override
    public TypedPlan visit(StaticPropertyExpr expr) {
        Set<GenericClass> classes = Collections.singleton(this.navigator.getGenericClass(expr.getClassName()));
        return this.compilePropertyAccess(expr, null, classes, expr.getPropertyName());
    }

    private TypedPlan compilePropertyAccess(Expr expr, TypedPlan instance, Collection<GenericClass> classes, String propertyName) {
        boolean isStatic;
        GenericField field = this.findField(classes, propertyName);
        boolean bl = isStatic = instance == null;
        if (field != null) {
            if (isStatic == field.getDescriber().isStatic()) {
                FieldPlan plan = new FieldPlan(instance != null ? instance.plan : null, field.getDescriber().getOwner().getName(), field.getDescriber().getName(), CompilerCommons.typeToString(field.getDescriber().getRawType()));
                return this.planWithLocation(plan, field.getActualType(), expr);
            }
            return this.errorAndFakeResult(expr, "Field " + propertyName + " should " + (!isStatic ? "not " : "") + "be static");
        }
        GenericMethod getter = this.findGetter(classes, propertyName);
        if (getter != null) {
            if (isStatic == getter.getDescriber().isStatic()) {
                String desc = "()" + CompilerCommons.typeToString(getter.getDescriber().getRawReturnType());
                InvocationPlan plan = new InvocationPlan(getter.getDescriber().getOwner().getName(), getter.getDescriber().getName(), desc, instance != null ? instance.plan : null, new Plan[0]);
                return this.planWithLocation(plan, getter.getActualReturnType(), expr);
            }
            return this.errorAndFakeResult(expr, "Method " + getter.getDescriber().getName() + " should " + (!isStatic ? "not " : "") + "be static");
        }
        if (instance.plan instanceof ThisPlan) {
            return this.errorAndFakeResult(expr, "Variable " + propertyName + " was not found");
        }
        return this.errorAndFakeResult(expr, "Property " + propertyName + " was not found");
    }

    @Override
    public TypedPlan visit(UnaryExpr expr) {
        this.expectedType = null;
        TypedPlan operand = expr.getOperand().acceptVisitor(this);
        switch (expr.getOperation()) {
            case NEGATE: {
                ArithmeticTypeAndPlan result = this.getArithmeticType(expr, operand);
                NegatePlan plan = new NegatePlan(result.plan.getPlan(), result.type);
                return this.planWithLocation(plan, CompilerCommons.getType(result.type), expr);
            }
            case NOT: {
                operand = this.ensureBooleanType(expr, operand);
                NotPlan plan = new NotPlan(operand.getPlan());
                return this.planWithLocation(plan, Primitive.BOOLEAN, expr);
            }
        }
        throw new AssertionError((Object)"Should not get here");
    }

    @Override
    public TypedPlan visit(VariableExpr expr) {
        ValueType type = this.boundVars.get(expr.getName());
        if (type != null) {
            String boundName = this.boundVarRenamings.get(expr.getName());
            return this.planWithLocation(new VariablePlan(boundName), type, expr);
        }
        type = this.scope.variableType(expr.getName());
        if (type == null) {
            type = this.scope.variableType("this");
            return this.compilePropertyAccess(expr, new TypedPlan(new ThisPlan(), type), CompilerCommons.extractClasses(type), expr.getName());
        }
        return this.planWithLocation(new VariablePlan(expr.getName()), type, expr);
    }

    @Override
    public TypedPlan visit(ThisExpr expr) {
        ValueType type = this.scope.variableType("this");
        return this.planWithLocation(new ThisPlan(), type, expr);
    }

    @Override
    public TypedPlan visit(LambdaExpr expr) {
        GenericMethod lambdaSam = null;
        if (this.expectedType instanceof GenericClass) {
            lambdaSam = this.navigator.findSingleAbstractMethod((GenericClass)this.expectedType);
        }
        if (lambdaSam == null) {
            return this.errorAndFakeResult(expr, "Can't infer type of the lambda expression");
        }
        ValueType[] actualArgTypes = lambdaSam.getActualParameterTypes();
        ValueType[] oldVarTypes = new ValueType[expr.getBoundVariables().size()];
        String[] oldRenamings = new String[oldVarTypes.length];
        HashSet<String> usedNames = new HashSet<String>();
        ArrayList<String> boundVarNames = new ArrayList<String>();
        for (int i = 0; i < oldVarTypes.length; ++i) {
            BoundVariable boundVar = expr.getBoundVariables().get(i);
            if (!boundVar.getName().isEmpty()) {
                oldVarTypes[i] = this.boundVars.get(boundVar.getName());
                oldRenamings[i] = this.boundVarRenamings.get(boundVar.getName());
                if (!usedNames.add(boundVar.getName())) {
                    this.error(expr, "Duplicate bound variable name: " + boundVar.getName());
                    continue;
                }
                ValueType boundVarType = boundVar.getType();
                if (boundVarType == null) {
                    boundVarType = actualArgTypes[i];
                } else if (!CompilerCommons.isSuperType(boundVarType, actualArgTypes[i], this.navigator)) {
                    this.error(expr, "Expected parameter type " + actualArgTypes[i] + " is not a subtype of actually declared parameterType" + boundVarType);
                }
                this.boundVars.put(boundVar.getName(), boundVarType);
                String renaming = "$" + this.boundVarRenamings.size();
                this.boundVarRenamings.put(boundVar.getName(), renaming);
                boundVarNames.add(renaming);
                continue;
            }
            boundVarNames.add("");
        }
        this.expectedType = lambdaSam.getActualReturnType();
        TypedPlan body = expr.getBody().acceptVisitor(this);
        this.lambdaReturnType = body.getType();
        if (lambdaSam.getActualReturnType() != null) {
            body = this.convert(expr.getBody(), body, lambdaSam.getActualReturnType());
        }
        String className = lambdaSam.getDescriber().getOwner().getName();
        String methodName = lambdaSam.getDescriber().getName();
        String methodDesc = CompilerCommons.methodToDesc(lambdaSam.getDescriber());
        LambdaPlan lambda = new LambdaPlan(body.plan, className, methodName, methodDesc, boundVarNames);
        for (int i = 0; i < oldVarTypes.length; ++i) {
            BoundVariable boundVar = expr.getBoundVariables().get(i);
            if (boundVar.getName().isEmpty()) continue;
            this.boundVars.put(boundVar.getName(), oldVarTypes[i]);
            this.boundVarRenamings.put(boundVar.getName(), oldRenamings[i]);
        }
        return this.planWithLocation(lambda, lambdaSam.getActualOwner(), expr);
    }

    @Override
    public TypedPlan visit(ConstantExpr expr) {
        ValueType type;
        if (expr.getValue() == null) {
            type = NullType.INSTANCE;
        } else if (expr.getValue() instanceof Boolean) {
            type = Primitive.BOOLEAN;
        } else if (expr.getValue() instanceof Character) {
            type = Primitive.CHAR;
        } else if (expr.getValue() instanceof Byte) {
            type = Primitive.BYTE;
        } else if (expr.getValue() instanceof Short) {
            type = Primitive.SHORT;
        } else if (expr.getValue() instanceof Integer) {
            type = Primitive.INT;
        } else if (expr.getValue() instanceof Long) {
            type = Primitive.LONG;
        } else if (expr.getValue() instanceof Float) {
            type = Primitive.FLOAT;
        } else if (expr.getValue() instanceof Double) {
            type = Primitive.DOUBLE;
        } else if (expr.getValue() instanceof String) {
            type = TypeUtils.STRING_CLASS;
        } else {
            throw new IllegalArgumentException("Don't know how to compile constant: " + expr.getValue());
        }
        return this.planWithLocation(new ConstantPlan(expr.getValue()), type, expr);
    }

    @Override
    public TypedPlan visit(TernaryConditionExpr expr) {
        ValueType b;
        Object expectedType = null;
        this.expectedType = Primitive.BOOLEAN;
        TypedPlan condition = expr.getCondition().acceptVisitor(this);
        condition = this.convert(expr.getCondition(), condition, Primitive.BOOLEAN);
        this.expectedType = expectedType;
        TypedPlan consequent = expr.getConsequent().acceptVisitor(this);
        this.expectedType = expectedType;
        TypedPlan alternative = expr.getAlternative().acceptVisitor(this);
        ValueType a = consequent.getType();
        ValueType type = CompilerCommons.commonSupertype(a, b = alternative.getType(), this.navigator);
        if (type == null) {
            ValueTypeFormatter formatter = new ValueTypeFormatter();
            return this.errorAndFakeResult(expr, "Clauses of ternary conditional operator are not compatible: " + formatter.format(a) + " vs. " + formatter.format(b));
        }
        consequent = this.convert(expr.getConsequent(), consequent, type);
        alternative = this.convert(expr.getAlternative(), alternative, type);
        return this.planWithLocation(new ConditionalPlan(condition.getPlan(), consequent.getPlan(), alternative.getPlan()), type, expr);
    }

    @Override
    public TypedPlan visit(AssignmentExpr expr) {
        if (expr.getTarget() instanceof VariableExpr) {
            ValueType instanceType = this.scope.variableType("this");
            String identifier = ((VariableExpr)expr.getTarget()).getName();
            TypedPlan instance = new TypedPlan(new ThisPlan(), instanceType);
            return this.compileAssignment(instance, CompilerCommons.extractClasses(instanceType), identifier, expr.getValue(), expr);
        }
        if (expr.getTarget() instanceof PropertyExpr) {
            PropertyExpr property = (PropertyExpr)expr.getTarget();
            TypedPlan instance = property.getInstance().acceptVisitor(this);
            ValueType instanceType = instance.getType();
            String identifier = property.getPropertyName();
            return this.compileAssignment(instance, CompilerCommons.extractClasses(instanceType), identifier, expr.getValue(), expr);
        }
        if (expr.getTarget() instanceof StaticPropertyExpr) {
            StaticPropertyExpr property = (StaticPropertyExpr)expr.getTarget();
            GenericClass instanceType = this.navigator.getGenericClass(property.getClassName());
            String identifier = property.getPropertyName();
            return this.compileAssignment(null, CompilerCommons.extractClasses(instanceType), identifier, expr.getValue(), expr);
        }
        this.error(expr.getTarget(), "Invalid left side of assignment");
        return this.planWithLocation(new ThisPlan(), this.voidType(), expr);
    }

    private GenericType voidType() {
        return new GenericClass("java.lang.Void");
    }

    private TypedPlan compileAssignment(TypedPlan instance, Collection<GenericClass> classes, String name, Expr value, Expr expr) {
        TypedPlan valuePlan = value.acceptVisitor(this);
        if (valuePlan.getType() == null) {
            this.error(value, "Right side of assignment must return a value");
            return this.planWithLocation(new ThisPlan(), this.voidType(), expr);
        }
        GenericField field = this.findField(classes, name);
        if (field != null) {
            String owner = field.getDescriber().getOwner().getName();
            String fieldName = field.getDescriber().getName();
            String desc = CompilerCommons.typeToString(field.getDescriber().getRawType());
            return this.planWithLocation(new FieldAssignmentPlan(instance != null ? instance.getPlan() : null, owner, fieldName, desc, valuePlan.getPlan()), this.voidType(), expr);
        }
        GenericMethod setter = this.findSetter(classes, name, valuePlan.getType());
        if (setter != null) {
            String owner = setter.getDescriber().getOwner().getName();
            String methodName = setter.getDescriber().getName();
            String methodDesc = CompilerCommons.methodToDesc(setter.getDescriber());
            return this.planWithLocation(new InvocationPlan(owner, methodName, methodDesc, instance != null ? instance.getPlan() : null, valuePlan.getPlan()), this.voidType(), expr);
        }
        this.error(expr, "Property not found: " + name);
        return this.planWithLocation(new ThisPlan(), this.voidType(), expr);
    }

    private GenericField findField(Collection<GenericClass> classes, String name) {
        for (GenericClass cls : classes) {
            GenericField field = this.navigator.getField(cls, name);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    private GenericMethod findGetter(Collection<GenericClass> classes, String name) {
        String getterName = this.getGetterName(name);
        String booleanGetterName = this.getBooleanGetterName(name);
        for (GenericClass cls : classes) {
            GenericMethod method = this.navigator.getMethod(cls, getterName, new GenericClass[0]);
            if (method == null && (method = this.navigator.getMethod(cls, booleanGetterName, new GenericClass[0])) != null && method.getActualReturnType() != Primitive.BOOLEAN) {
                method = null;
            }
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private GenericMethod findSetter(Collection<GenericClass> classes, String propertyName, ValueType type) {
        String setterName = this.getSetterName(propertyName);
        for (GenericClass cls : classes) {
            for (GenericMethod method : this.navigator.findMethods(cls, setterName, 1)) {
                if (!CompilerCommons.isLooselyCompatibleType(method.getActualParameterTypes()[0], type, this.navigator)) continue;
                return method;
            }
        }
        return null;
    }

    private String getGetterName(String propertyName) {
        if (propertyName.isEmpty()) {
            return "get";
        }
        return "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private String getSetterName(String propertyName) {
        if (propertyName.isEmpty()) {
            return "set";
        }
        return "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private String getBooleanGetterName(String propertyName) {
        if (propertyName.isEmpty()) {
            return "is";
        }
        return "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private TypedPlan ensureBooleanType(Expr expr, TypedPlan plan) {
        return this.convert(expr, plan, Primitive.BOOLEAN);
    }

    private TypedPlan ensureIntType(Expr expr, TypedPlan plan) {
        return this.convert(expr, plan, Primitive.INT);
    }

    private TypedPlan convertToString(Expr expr, TypedPlan value) {
        if (value.getType().equals(TypeUtils.STRING_CLASS)) {
            return value;
        }
        ValueType type = value.getType();
        Plan plan = value.getPlan();
        if (type instanceof Primitive) {
            GenericClass wrapperClass = (GenericClass)TypeUtils.tryBox(type);
            plan = new InvocationPlan(wrapperClass.getName(), "toString", "(" + CompilerCommons.typeToString(type) + ")Ljava/lang/String;", null, plan);
        } else {
            plan = new InvocationPlan("java.lang.String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;", null, plan);
        }
        return this.planWithLocation(plan, TypeUtils.STRING_CLASS, expr);
    }

    private ArithmeticTypeAndPlan getArithmeticType(Expr expr, TypedPlan plan) {
        ValueType initialType = plan.getType();
        if (!(plan.getType() instanceof Primitive)) {
            plan = this.unbox(plan);
        }
        if (plan != null) {
            ArithmeticType type;
            PrimitiveKind kind = ((Primitive)plan.type).getKind();
            IntegerSubtype subtype = CompilerCommons.getIntegerSubtype(kind);
            if (subtype != null) {
                plan = this.planWithLocation(new CastToIntegerPlan(subtype, plan.plan), Primitive.INT, expr);
                kind = ((Primitive)plan.type).getKind();
            }
            if ((type = CompilerCommons.getArithmeticType(kind)) != null) {
                return new ArithmeticTypeAndPlan(type, plan);
            }
        }
        this.error(expr, "Invalid operand type: " + initialType);
        return new ArithmeticTypeAndPlan(ArithmeticType.INT, this.planWithLocation(new ConstantPlan(0), Primitive.INT, expr));
    }

    private ArithmeticTypeAndPlans getArithmeticTypeForPair(Expr firstExpr, TypedPlan firstPlan, Expr secondExpr, TypedPlan secondPlan) {
        ArithmeticTypeAndPlan firstResult = this.getArithmeticType(firstExpr, firstPlan);
        ArithmeticTypeAndPlan secondResult = this.getArithmeticType(secondExpr, secondPlan);
        ArithmeticType firstType = firstResult.type;
        ArithmeticType secondType = secondResult.type;
        firstPlan = firstResult.plan;
        secondPlan = secondResult.plan;
        ArithmeticType common = ArithmeticType.values()[Math.max(firstType.ordinal(), secondType.ordinal())];
        if (firstType != common) {
            firstPlan = this.planWithLocation(new ArithmeticCastPlan(firstType, common, firstPlan.getPlan()), CompilerCommons.getType(common), firstExpr);
        }
        if (secondType != common) {
            secondPlan = this.planWithLocation(new ArithmeticCastPlan(secondType, common, secondPlan.getPlan()), CompilerCommons.getType(common), secondExpr);
        }
        return new ArithmeticTypeAndPlans(common, firstPlan, secondPlan);
    }

    private BinaryPlanType getPlanType(BinaryOperation op) {
        switch (op) {
            case ADD: {
                return BinaryPlanType.ADD;
            }
            case SUBTRACT: {
                return BinaryPlanType.SUBTRACT;
            }
            case MULTIPLY: {
                return BinaryPlanType.MULTIPLY;
            }
            case DIVIDE: {
                return BinaryPlanType.DIVIDE;
            }
            case REMAINDER: {
                return BinaryPlanType.REMAINDER;
            }
            case EQUAL: {
                return BinaryPlanType.EQUAL;
            }
            case NOT_EQUAL: {
                return BinaryPlanType.NOT_EQUAL;
            }
            case LESS: {
                return BinaryPlanType.LESS;
            }
            case LESS_OR_EQUAL: {
                return BinaryPlanType.LESS_OR_EQUAL;
            }
            case GREATER: {
                return BinaryPlanType.GREATER;
            }
            case GREATER_OR_EQUAL: {
                return BinaryPlanType.GREATER_OR_EQUAL;
            }
        }
        throw new AssertionError((Object)("Don't know how to map binary operation " + (Object)((Object)op) + " to plan"));
    }

    private LogicalBinaryPlanType getLogicalPlanType(BinaryOperation op) {
        switch (op) {
            case AND: {
                return LogicalBinaryPlanType.AND;
            }
            case OR: {
                return LogicalBinaryPlanType.OR;
            }
        }
        throw new AssertionError((Object)("Don't know how to map binary operation " + (Object)((Object)op) + " to plan"));
    }

    TypedPlan convert(Expr expr, TypedPlan plan, ValueType targetType) {
        TypedPlan convertedPlan = this.tryConvert(expr, plan, targetType);
        return convertedPlan != null ? convertedPlan : this.errorAndFakeResult(expr, "Can't convert " + plan.getType() + " to " + targetType);
    }

    private TypedPlan tryConvert(Expr expr, TypedPlan plan, ValueType targetType) {
        if (plan.getType() == null) {
            return null;
        }
        if (plan.getType().equals(targetType)) {
            return plan;
        }
        if (plan.getType().equals(NullType.INSTANCE)) {
            return new TypedPlan(plan.plan, targetType);
        }
        if (targetType instanceof Primitive) {
            if (!(plan.type instanceof Primitive) && (plan = this.unbox(plan)) == null) {
                return null;
            }
            if (!CompilerCommons.hasImplicitConversion(((Primitive)plan.type).getKind(), ((Primitive)targetType).getKind())) {
                return null;
            }
            if ((plan = this.tryCastPrimitive(plan, (Primitive)targetType)) == null) {
                return null;
            }
            return plan;
        }
        if (plan.type instanceof Primitive && (plan = this.box(expr, plan)) == null) {
            return null;
        }
        if (!CompilerCommons.isErasedSuperType(targetType, plan.type, this.navigator)) {
            return null;
        }
        return new TypedPlan(plan.plan, targetType);
    }

    private TypedPlan tryCastPrimitive(TypedPlan plan, Primitive targetType) {
        Primitive sourceType = (Primitive)plan.type;
        if (sourceType == targetType) {
            return plan;
        }
        if (sourceType.getKind() == PrimitiveKind.BOOLEAN) {
            if (targetType != Primitive.BOOLEAN) {
                return null;
            }
        } else {
            ArithmeticType sourceArithmetic;
            IntegerSubtype subtype = CompilerCommons.getIntegerSubtype(sourceType.getKind());
            if (subtype != null) {
                plan = new TypedPlan(new CastToIntegerPlan(subtype, plan.plan), Primitive.INT);
                sourceType = (Primitive)plan.type;
            }
            if ((sourceArithmetic = CompilerCommons.getArithmeticType(sourceType.getKind())) == null) {
                return null;
            }
            subtype = CompilerCommons.getIntegerSubtype(targetType.getKind());
            ArithmeticType targetArithmetic = CompilerCommons.getArithmeticType(targetType.getKind());
            if (targetArithmetic == null) {
                if (subtype == null) {
                    return null;
                }
                targetArithmetic = ArithmeticType.INT;
            }
            plan = new TypedPlan(new ArithmeticCastPlan(sourceArithmetic, targetArithmetic, plan.plan), CompilerCommons.getType(targetArithmetic));
            if (subtype != null) {
                plan = new TypedPlan(new CastFromIntegerPlan(subtype, plan.plan), targetType);
            }
        }
        return plan;
    }

    private TypedPlan unbox(TypedPlan plan) {
        GenericClass cls;
        if (plan.type instanceof GenericReference) {
            TypeVar v = ((GenericReference)plan.type).getVar();
            cls = v.getLowerBound().stream().filter(bound -> TypeUtils.tryUnbox(bound) != bound).findFirst().orElse(null);
            if (cls == null) {
                return null;
            }
        } else if (plan.type instanceof GenericClass) {
            cls = (GenericClass)plan.type;
        } else {
            return null;
        }
        Primitive primitive = TypeUtils.unbox(cls);
        if (primitive == null) {
            return null;
        }
        String methodName = primitive.getKind().name().toLowerCase() + "Value";
        return new TypedPlan(new InvocationPlan(cls.getName(), methodName, "()" + CompilerCommons.typeToString(primitive), plan.plan, new Plan[0]), primitive);
    }

    private TypedPlan box(Expr expr, TypedPlan plan) {
        if (!(plan.type instanceof Primitive)) {
            return null;
        }
        GenericClass wrapper = TypeUtils.box(plan.type);
        if (wrapper == null) {
            return null;
        }
        return this.planWithLocation(new InvocationPlan(wrapper.getName(), "valueOf", "(" + CompilerCommons.typeToString(plan.type) + ")" + CompilerCommons.typeToString(wrapper), null, plan.plan), wrapper, expr);
    }

    private ValueType resolveType(ValueType type, Expr expr) {
        if (type instanceof GenericClass) {
            GenericClass cls = (GenericClass)type;
            String resolvedName = this.classResolver.findClass(cls.getName());
            if (resolvedName == null) {
                this.error(expr, "Class not found: " + cls.getName());
                return type;
            }
            boolean changed = !resolvedName.equals(cls.getName());
            ArrayList<TypeArgument> arguments = new ArrayList<TypeArgument>();
            for (TypeArgument typeArgument : cls.getArguments()) {
                TypeArgument resolvedArg = typeArgument.mapBound(bound -> (GenericType)this.resolveType((ValueType)bound, expr));
                arguments.add(resolvedArg);
                changed |= resolvedArg != typeArgument;
            }
            return !changed ? type : new GenericClass(resolvedName, arguments);
        }
        if (type instanceof GenericArray) {
            GenericArray array = (GenericArray)type;
            GenericType elementType = (GenericType)this.resolveType(array.getElementType(), expr);
            return elementType == array.getElementType() ? type : new GenericArray(elementType);
        }
        return type;
    }

    private void error(Expr expr, String message) {
        this.diagnostics.add(new Diagnostic(expr.getStart(), expr.getEnd(), message));
    }

    private TypedPlan planWithLocation(Plan plan, ValueType type, Expr expr) {
        plan.setLocation(new Location(expr.getStart(), expr.getEnd()));
        return new TypedPlan(plan, type);
    }

    static class ArithmeticTypeAndPlans {
        ArithmeticType arithmeticType;
        TypedPlan first;
        TypedPlan second;

        ArithmeticTypeAndPlans(ArithmeticType arithmeticType, TypedPlan first, TypedPlan second) {
            this.arithmeticType = arithmeticType;
            this.first = first;
            this.second = second;
        }
    }

    static class ArithmeticTypeAndPlan {
        ArithmeticType type;
        TypedPlan plan;

        ArithmeticTypeAndPlan(ArithmeticType type, TypedPlan plan) {
            this.type = type;
            this.plan = plan;
        }
    }
}

