/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teavm.flavour.expr.ClassResolver;

public class ImportingClassResolver
implements ClassResolver {
    private ClassResolver underlyingClassResolver;
    private Map<String, String> cache = new HashMap<String, String>();
    private List<Import> imports = new ArrayList<Import>();

    public ImportingClassResolver(ClassResolver underlyingClassResolver) {
        this.underlyingClassResolver = underlyingClassResolver;
    }

    public ImportingClassResolver importClass(String name) {
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            Import imp = new Import();
            imp.name = name;
            imp.className = name.substring(index + 1);
            this.imports.add(imp);
        }
        return this;
    }

    public ImportingClassResolver importPackage(String name) {
        Import imp = new Import();
        imp.name = name;
        this.imports.add(imp);
        return this;
    }

    @Override
    public String findClass(String name) {
        String fullName = this.cache.get(name);
        if (fullName == null) {
            fullName = this.underlyingClassResolver.findClass(name);
            if (fullName == null && this.isSimpleName(name)) {
                fullName = this.findClassBySimpleName(name);
            }
            if (fullName == null) {
                fullName = "";
            }
            this.cache.put(name, fullName);
        }
        return !fullName.isEmpty() ? fullName : null;
    }

    private boolean isSimpleName(String name) {
        return name.indexOf(46) < 0;
    }

    private String findClassBySimpleName(String name) {
        for (Import imp : this.imports) {
            if (imp.className != null) {
                if (!name.equals(imp.className)) continue;
                return imp.name;
            }
            String fullName = this.underlyingClassResolver.findClass(imp.name + "." + name);
            if (fullName == null) continue;
            return fullName;
        }
        return null;
    }

    static class Import {
        String name;
        String className;

        Import() {
        }
    }
}

