/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.expr;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.teavm.flavour.expr.InterpretationException;
import org.teavm.flavour.expr.plan.ArithmeticCastPlan;
import org.teavm.flavour.expr.plan.ArrayConstructionPlan;
import org.teavm.flavour.expr.plan.ArrayLengthPlan;
import org.teavm.flavour.expr.plan.BinaryPlan;
import org.teavm.flavour.expr.plan.CastFromIntegerPlan;
import org.teavm.flavour.expr.plan.CastPlan;
import org.teavm.flavour.expr.plan.CastToIntegerPlan;
import org.teavm.flavour.expr.plan.ConditionalPlan;
import org.teavm.flavour.expr.plan.ConstantPlan;
import org.teavm.flavour.expr.plan.ConstructionPlan;
import org.teavm.flavour.expr.plan.FieldAssignmentPlan;
import org.teavm.flavour.expr.plan.FieldPlan;
import org.teavm.flavour.expr.plan.GetArrayElementPlan;
import org.teavm.flavour.expr.plan.InstanceOfPlan;
import org.teavm.flavour.expr.plan.InvocationPlan;
import org.teavm.flavour.expr.plan.LambdaPlan;
import org.teavm.flavour.expr.plan.LogicalBinaryPlan;
import org.teavm.flavour.expr.plan.NegatePlan;
import org.teavm.flavour.expr.plan.NotPlan;
import org.teavm.flavour.expr.plan.ObjectPlan;
import org.teavm.flavour.expr.plan.ObjectPlanEntry;
import org.teavm.flavour.expr.plan.PlanVisitor;
import org.teavm.flavour.expr.plan.ReferenceEqualityPlan;
import org.teavm.flavour.expr.plan.ThisPlan;
import org.teavm.flavour.expr.plan.VariablePlan;

class InterpreterVisitor
implements PlanVisitor {
    private Map<String, Object> variables;
    Object value;
    private Map<String, Class<?>> classCache = new HashMap();
    private Map<String, Field> fieldCache = new HashMap<String, Field>();
    private Map<String, Method> methodCache = new HashMap<String, Method>();
    private Map<String, Constructor<?>> constructorCache = new HashMap();

    InterpreterVisitor(Map<String, Object> variables) {
        this.variables = variables;
    }

    @Override
    public void visit(ConstantPlan plan) {
        this.value = plan.getValue();
    }

    @Override
    public void visit(VariablePlan plan) {
        this.value = this.variables.get(plan.getName());
    }

    @Override
    public void visit(BinaryPlan plan) {
        plan.getFirstOperand().acceptVisitor(this);
        Object a = this.value;
        plan.getSecondOperand().acceptVisitor(this);
        Object b = this.value;
        block0 : switch (plan.getType()) {
            case ADD: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.value = (Integer)a + (Integer)b;
                        break;
                    }
                    case LONG: {
                        this.value = (Long)a + (Long)b;
                        break;
                    }
                    case FLOAT: {
                        this.value = Float.valueOf(((Float)a).floatValue() + ((Float)b).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.value = (Double)a + (Double)b;
                    }
                }
                break;
            }
            case SUBTRACT: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.value = (Integer)a - (Integer)b;
                        break;
                    }
                    case LONG: {
                        this.value = (Long)a - (Long)b;
                        break;
                    }
                    case FLOAT: {
                        this.value = Float.valueOf(((Float)a).floatValue() - ((Float)b).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.value = (Double)a - (Double)b;
                    }
                }
                break;
            }
            case MULTIPLY: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.value = (Integer)a * (Integer)b;
                        break;
                    }
                    case LONG: {
                        this.value = (Long)a * (Long)b;
                        break;
                    }
                    case FLOAT: {
                        this.value = Float.valueOf(((Float)a).floatValue() * ((Float)b).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.value = (Double)a * (Double)b;
                    }
                }
                break;
            }
            case DIVIDE: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.value = (Integer)a / (Integer)b;
                        break;
                    }
                    case LONG: {
                        this.value = (Long)a / (Long)b;
                        break;
                    }
                    case FLOAT: {
                        this.value = Float.valueOf(((Float)a).floatValue() / ((Float)b).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.value = (Double)a / (Double)b;
                    }
                }
                break;
            }
            case REMAINDER: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.value = (Integer)a % (Integer)b;
                        break;
                    }
                    case LONG: {
                        this.value = (Long)a % (Long)b;
                        break;
                    }
                    case FLOAT: {
                        this.value = Float.valueOf(((Float)a).floatValue() % ((Float)b).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.value = (Double)a % (Double)b;
                    }
                }
                break;
            }
            case EQUAL: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.value = ((Integer)a).intValue() == ((Integer)b).intValue();
                        break;
                    }
                    case LONG: {
                        this.value = ((Long)a).intValue() == ((Long)b).intValue();
                        break;
                    }
                    case FLOAT: {
                        this.value = ((Float)a).floatValue() == ((Float)b).floatValue();
                        break;
                    }
                    case DOUBLE: {
                        this.value = ((Double)a).doubleValue() == ((Double)b).doubleValue();
                    }
                }
                break;
            }
            case NOT_EQUAL: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.value = ((Integer)a).intValue() != ((Integer)b).intValue();
                        break;
                    }
                    case LONG: {
                        this.value = ((Long)a).intValue() != ((Long)b).intValue();
                        break;
                    }
                    case FLOAT: {
                        this.value = ((Float)a).floatValue() != ((Float)b).floatValue();
                        break;
                    }
                    case DOUBLE: {
                        this.value = ((Double)a).doubleValue() != ((Double)b).doubleValue();
                    }
                }
                break;
            }
            case GREATER: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.value = (Integer)a > (Integer)b;
                        break;
                    }
                    case LONG: {
                        this.value = (Long)a > (Long)b;
                        break;
                    }
                    case FLOAT: {
                        this.value = ((Float)a).floatValue() > ((Float)b).floatValue();
                        break;
                    }
                    case DOUBLE: {
                        this.value = (Double)a > (Double)b;
                    }
                }
                break;
            }
            case GREATER_OR_EQUAL: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.value = (Integer)a >= (Integer)b;
                        break;
                    }
                    case LONG: {
                        this.value = (Long)a >= (Long)b;
                        break;
                    }
                    case FLOAT: {
                        this.value = ((Float)a).floatValue() >= ((Float)b).floatValue();
                        break;
                    }
                    case DOUBLE: {
                        this.value = (Double)a >= (Double)b;
                    }
                }
                break;
            }
            case LESS: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.value = (Integer)a < (Integer)b;
                        break;
                    }
                    case LONG: {
                        this.value = (Long)a < (Long)b;
                        break;
                    }
                    case FLOAT: {
                        this.value = ((Float)a).floatValue() < ((Float)b).floatValue();
                        break;
                    }
                    case DOUBLE: {
                        this.value = (Double)a < (Double)b;
                    }
                }
                break;
            }
            case LESS_OR_EQUAL: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.value = (Integer)a <= (Integer)b;
                        break block0;
                    }
                    case LONG: {
                        this.value = (Long)a <= (Long)b;
                        break block0;
                    }
                    case FLOAT: {
                        this.value = ((Float)a).floatValue() <= ((Float)b).floatValue();
                        break block0;
                    }
                    case DOUBLE: {
                        this.value = (Double)a <= (Double)b;
                    }
                }
            }
        }
    }

    @Override
    public void visit(NegatePlan plan) {
        plan.getOperand().acceptVisitor(this);
        switch (plan.getValueType()) {
            case INT: {
                this.value = -((Integer)this.value).intValue();
                break;
            }
            case LONG: {
                this.value = -((Long)this.value).longValue();
                break;
            }
            case FLOAT: {
                this.value = Float.valueOf(-((Float)this.value).floatValue());
                break;
            }
            case DOUBLE: {
                this.value = -((Double)this.value).doubleValue();
            }
        }
    }

    @Override
    public void visit(ReferenceEqualityPlan plan) {
        plan.getFirstOperand().acceptVisitor(this);
        Object a = this.value;
        plan.getSecondOperand().acceptVisitor(this);
        Object b = this.value;
        switch (plan.getType()) {
            case EQUAL: {
                this.value = a == b;
                break;
            }
            case NOT_EQUAL: {
                this.value = a != b;
            }
        }
    }

    @Override
    public void visit(LogicalBinaryPlan plan) {
        plan.getFirstOperand().acceptVisitor(this);
        Boolean a = (Boolean)this.value;
        switch (plan.getType()) {
            case AND: {
                if (!a.booleanValue()) {
                    this.value = false;
                    break;
                }
                plan.getSecondOperand().acceptVisitor(this);
                break;
            }
            case OR: {
                if (a.booleanValue()) {
                    this.value = true;
                    break;
                }
                plan.getSecondOperand().acceptVisitor(this);
            }
        }
    }

    @Override
    public void visit(NotPlan plan) {
        plan.getOperand().acceptVisitor(this);
        this.value = (Boolean)this.value == false;
    }

    @Override
    public void visit(CastPlan plan) {
        plan.getOperand().acceptVisitor(this);
        if (this.value == null) {
            return;
        }
        Class<?> type = this.decodeType(plan.getTargetType());
        if (!type.isInstance(this.value)) {
            throw new InterpretationException("Can't cast value to " + type);
        }
    }

    @Override
    public void visit(ArithmeticCastPlan plan) {
        plan.getOperand().acceptVisitor(this);
        block0 : switch (plan.getSourceType()) {
            case INT: {
                switch (plan.getTargetType()) {
                    case INT: {
                        break;
                    }
                    case LONG: {
                        this.value = (long)((Integer)this.value).intValue();
                        break;
                    }
                    case FLOAT: {
                        this.value = Float.valueOf(((Integer)this.value).intValue());
                        break;
                    }
                    case DOUBLE: {
                        this.value = (double)((Integer)this.value).intValue();
                    }
                }
                break;
            }
            case LONG: {
                switch (plan.getTargetType()) {
                    case INT: {
                        this.value = (int)((Long)this.value).longValue();
                        break;
                    }
                    case LONG: {
                        break;
                    }
                    case FLOAT: {
                        this.value = Float.valueOf(((Long)this.value).longValue());
                        break;
                    }
                    case DOUBLE: {
                        this.value = (double)((Long)this.value).longValue();
                    }
                }
                break;
            }
            case FLOAT: {
                switch (plan.getTargetType()) {
                    case INT: {
                        this.value = ((Float)this.value).intValue();
                        break;
                    }
                    case LONG: {
                        this.value = ((Float)this.value).longValue();
                        break;
                    }
                    case FLOAT: {
                        break;
                    }
                    case DOUBLE: {
                        this.value = ((Float)this.value).doubleValue();
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (plan.getTargetType()) {
                    case INT: {
                        this.value = ((Double)this.value).intValue();
                        break block0;
                    }
                    case LONG: {
                        this.value = ((Double)this.value).longValue();
                        break block0;
                    }
                    case FLOAT: {
                        this.value = Float.valueOf(((Double)this.value).floatValue());
                        break block0;
                    }
                }
            }
        }
    }

    @Override
    public void visit(CastFromIntegerPlan plan) {
        plan.getOperand().acceptVisitor(this);
        switch (plan.getType()) {
            case BYTE: {
                this.value = ((Integer)this.value).byteValue();
                break;
            }
            case CHAR: {
                this.value = Character.valueOf((char)((Integer)this.value).intValue());
                break;
            }
            case SHORT: {
                this.value = ((Integer)this.value).shortValue();
            }
        }
    }

    @Override
    public void visit(CastToIntegerPlan plan) {
        plan.getOperand().acceptVisitor(this);
        switch (plan.getType()) {
            case BYTE: {
                this.value = ((Byte)this.value).intValue();
                break;
            }
            case CHAR: {
                this.value = (int)((Character)this.value).charValue();
                break;
            }
            case SHORT: {
                this.value = ((Short)this.value).intValue();
            }
        }
    }

    @Override
    public void visit(GetArrayElementPlan plan) {
        plan.getArray().acceptVisitor(this);
        Object array = this.value;
        plan.getIndex().acceptVisitor(this);
        int index = (Integer)this.value;
        this.value = Array.get(array, index);
    }

    @Override
    public void visit(ArrayLengthPlan plan) {
        plan.getArray().acceptVisitor(this);
        this.value = Array.getLength(this.value);
    }

    @Override
    public void visit(FieldPlan plan) {
        Object instance;
        if (plan.getInstance() != null) {
            plan.getInstance().acceptVisitor(this);
            instance = this.value;
        } else {
            instance = null;
        }
        try {
            this.value = this.getField(plan.getClassName(), plan.getFieldName()).get(instance);
        }
        catch (IllegalAccessException e) {
            throw new InterpretationException("Can't access field " + plan.getClassName() + "." + plan.getFieldName(), e);
        }
    }

    @Override
    public void visit(FieldAssignmentPlan plan) {
        Object instance;
        if (plan.getInstance() != null) {
            plan.getInstance().acceptVisitor(this);
            instance = this.value;
        } else {
            instance = null;
        }
        plan.getValue().acceptVisitor(this);
        try {
            this.getField(plan.getClassName(), plan.getFieldName()).set(instance, this.value);
        }
        catch (IllegalAccessException e) {
            throw new InterpretationException("Can't access field " + plan.getClassName() + "." + plan.getFieldName(), e);
        }
        this.value = null;
    }

    @Override
    public void visit(InstanceOfPlan plan) {
        plan.getOperand().acceptVisitor(this);
        if (this.value == null) {
            this.value = false;
            return;
        }
        Class<?> type = this.decodeType(plan.getClassName());
        this.value = type.isInstance(this.value);
    }

    @Override
    public void visit(InvocationPlan plan) {
        Object instance;
        if (plan.getInstance() != null) {
            plan.getInstance().acceptVisitor(this);
            instance = this.value;
        } else {
            instance = null;
        }
        Object[] arguments = new Object[plan.getArguments().size()];
        for (int i = 0; i < arguments.length; ++i) {
            plan.getArguments().get(i).acceptVisitor(this);
            arguments[i] = this.value;
        }
        Method method = this.getMethod(plan.getClassName(), plan.getMethodName(), plan.getMethodDesc());
        try {
            this.value = method.invoke(instance, arguments);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InterpretationException("Can't access method " + plan.getClassName() + "." + plan.getMethodName() + plan.getMethodDesc(), e);
        }
    }

    @Override
    public void visit(ConstructionPlan plan) {
        Object[] arguments = new Object[plan.getArguments().size()];
        for (int i = 0; i < arguments.length; ++i) {
            plan.getArguments().get(i).acceptVisitor(this);
            arguments[i] = this.value;
        }
        Constructor<?> ctor = this.getConstructor(plan.getClassName(), plan.getMethodDesc());
        try {
            this.value = ctor.newInstance(arguments);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new InterpretationException("Can't access constructor " + plan.getClassName() + ".<init>" + plan.getMethodDesc(), e);
        }
    }

    @Override
    public void visit(ArrayConstructionPlan plan) {
        TypeDecoder decoder = new TypeDecoder(plan.getElementType());
        Class<?> type = decoder.decode();
        Object array = Array.newInstance(type, plan.getElements().size());
        for (int i = 0; i < plan.getElements().size(); ++i) {
            plan.getElements().get(i).acceptVisitor(this);
            Array.set(array, i, this.value);
        }
        this.value = array;
    }

    @Override
    public void visit(ConditionalPlan plan) {
        plan.getCondition().acceptVisitor(this);
        Boolean condition = (Boolean)this.value;
        if (condition.booleanValue()) {
            plan.getConsequent().acceptVisitor(this);
        } else {
            plan.getAlternative().acceptVisitor(this);
        }
    }

    @Override
    public void visit(ThisPlan plan) {
        this.value = this.variables.get("this");
    }

    @Override
    public void visit(LambdaPlan plan) {
        Class<?> cls = this.getClass(plan.getClassName());
        Method proxyMethod = this.getMethod(plan.getClassName(), plan.getMethodName(), plan.getMethodDesc());
        this.value = Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{cls}, (proxy, method, args) -> {
            Object oldValue = this.value;
            this.value = null;
            if (method.equals(proxyMethod)) {
                int i;
                Object[] oldVars = new Object[plan.getBoundVars().size()];
                for (i = 0; i < plan.getBoundVars().size(); ++i) {
                    oldVars[i] = this.variables.get(plan.getBoundVars().get(i));
                    this.variables.put(plan.getBoundVars().get(i), args[i]);
                }
                plan.getBody().acceptVisitor(this);
                for (i = 0; i < plan.getBoundVars().size(); ++i) {
                    this.variables.put(plan.getBoundVars().get(i), oldVars[i]);
                }
            }
            Object result = this.value;
            this.value = oldValue;
            return result;
        });
    }

    @Override
    public void visit(ObjectPlan plan) {
        Object instance;
        Class<?> cls = this.getClass(plan.getClassName());
        try {
            instance = cls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InterpretationException("Can't access constructor " + plan.getClassName() + ".<init>()", e);
        }
        for (ObjectPlanEntry entry : plan.getEntries()) {
            Method method = this.getMethod(cls.getName(), entry.getSetterName(), entry.getSetterDesc());
            entry.getValue().acceptVisitor(this);
            try {
                method.invoke(instance, this.value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new InterpretationException("Can't access method " + plan.getClassName() + "." + entry.getSetterName() + entry.getSetterDesc(), e);
            }
        }
        this.value = instance;
    }

    private Class<?> decodeType(String type) {
        return new TypeDecoder(type).decode();
    }

    private Class<?> getClass(String name) {
        Class<?> cls = this.classCache.get(name);
        if (cls == null) {
            try {
                cls = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            this.classCache.put(name, cls);
        }
        return cls;
    }

    private Field getField(String className, String fieldName) {
        String key = className + "#" + fieldName;
        Field field = this.fieldCache.get(key);
        if (field == null) {
            Class<?> cls = this.getClass(className);
            if (cls == null) {
                return null;
            }
            try {
                field = cls.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                return null;
            }
            this.fieldCache.put(key, field);
        }
        return field;
    }

    private Method getMethod(String className, String methodName, String desc) {
        String key = className + "#" + methodName + desc;
        Method method = this.methodCache.get(key);
        if (method == null) {
            ArrayList argumentTypes = new ArrayList();
            TypeDecoder decoder = new TypeDecoder(desc);
            if (decoder.text.charAt(decoder.position++) != '(') {
                throw new InterpretationException("Wrong method descriptor " + desc);
            }
            while (decoder.text.charAt(decoder.position) != ')') {
                argumentTypes.add(decoder.decode());
            }
            Class<?> cls = this.getClass(className);
            if (cls == null) {
                return null;
            }
            try {
                method = cls.getMethod(methodName, argumentTypes.toArray(new Class[0]));
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            this.methodCache.put(key, method);
        }
        return method;
    }

    private Constructor<?> getConstructor(String className, String desc) {
        String key = className + "#" + desc;
        Constructor<?> ctor = this.constructorCache.get(key);
        if (ctor == null) {
            ArrayList argumentTypes = new ArrayList();
            TypeDecoder decoder = new TypeDecoder(desc);
            if (decoder.text.charAt(decoder.position++) != '(') {
                throw new InterpretationException("Wrong method descriptor " + desc);
            }
            while (decoder.text.charAt(decoder.position) != ')') {
                argumentTypes.add(decoder.decode());
            }
            Class<?> cls = this.getClass(className);
            if (cls == null) {
                return null;
            }
            try {
                ctor = cls.getConstructor(argumentTypes.toArray(new Class[0]));
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            this.constructorCache.put(key, ctor);
        }
        return ctor;
    }

    class TypeDecoder {
        int position;
        final String text;

        TypeDecoder(String text) {
            this.text = text;
        }

        Class<?> decode() {
            switch (this.text.charAt(this.position++)) {
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'V': {
                    return Void.TYPE;
                }
                case 'L': {
                    int index = this.text.indexOf(59, this.position);
                    Class cls = InterpreterVisitor.this.getClass(this.text.substring(this.position, index).replace('/', '.'));
                    this.position = index + 1;
                    return cls;
                }
                case '[': {
                    return Array.newInstance(this.decode(), 0).getClass();
                }
            }
            throw new InterpretationException("Error parsing type descriptor");
        }
    }
}

